/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.BlobInputStream;
import COM.ibm.db2.app.BlobOutputStream;
import COM.ibm.db2.app.BlobWithIO;
import COM.ibm.db2.app.Lob;
import java.io.InputStream;
import java.io.OutputStream;

class BlobWithDB2Buffer
extends Lob
implements BlobWithIO {
    long bufferPtr;
    int bufferSize;
    int bufferUsedType;
    long bufferUsedPtr;

    BlobWithDB2Buffer(long l7, int n2, int n3, long l8) throws Exception {
        this.bufferPtr = l7;
        this.bufferSize = n2;
        this.bufferUsedType = n3;
        this.bufferUsedPtr = l8;
    }

    @Override
    public void close() {
        this.bufferPtr = 0L;
    }

    @Override
    void assertOpen() throws Exception {
        if (this.bufferPtr == 0L) {
            throw new Exception("Blob is closed.");
        }
    }

    @Override
    public long size() throws Exception {
        this.assertOpen();
        return BlobWithDB2Buffer.getSize(this.bufferUsedType, this.bufferUsedPtr);
    }

    @Override
    public InputStream getInputStream() throws Exception {
        return new BlobInputStream(this);
    }

    @Override
    public OutputStream getOutputStream() throws Exception {
        return new BlobOutputStream(this);
    }

    @Override
    public synchronized void append(byte[] byArray, int n2, int n3) throws Exception {
        this.assertOpen();
        if (this.size() + (long)n3 > (long)this.bufferSize) {
            throw new Exception("cannot exceed maximum length: " + this.bufferSize);
        }
        BlobWithDB2Buffer.doAppend(byArray, n2, n3, this.bufferPtr, this.bufferUsedType, this.bufferUsedPtr);
    }

    @Override
    public synchronized int substr(int n2, byte[] byArray, int n3, int n4) throws Exception {
        this.assertOpen();
        int n5 = Math.min((int)this.size() - n2, n4);
        BlobWithDB2Buffer.doSubstr(n2, byArray, n3, n4, this.bufferPtr);
        return n5;
    }

    static native int getSize(int var0, long var1) throws Exception;

    static native void doAppend(byte[] var0, int var1, int var2, long var3, int var5, long var6) throws Exception;

    static native void doSubstr(int var0, byte[] var1, int var2, int var3, long var4) throws Exception;
}

