/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc.pool;

import com.nuodb.jdbc.logger.Logger;
import com.nuodb.jdbc.pool.ObjectFactory;
import com.nuodb.jdbc.pool.ObjectKey;
import com.nuodb.jdbc.pool.ObjectPool;
import com.nuodb.jdbc.pool.ObjectPoolConfig;
import com.nuodb.jdbc.pool.ObjectPoolException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultObjectPool<K extends ObjectKey, V, I>
implements ObjectPool<K, V, I> {
    private String name = EvictionTask.class.getSimpleName() + System.identityHashCode(this);
    private Logger logger;
    private ConcurrentHashMap<K, Queue<V>> objectMap = new ConcurrentHashMap();
    private ConcurrentHashMap<V, ObjectState> stateMap = new ConcurrentHashMap();
    private AtomicLong activeObjects = new AtomicLong(0L);
    private AtomicLong idleObjects = new AtomicLong(0L);
    private Timer evictionTimer;
    private ObjectFactory<K, V, I> objectFactory;
    private ObjectPoolConfig objectPoolConfig = ObjectPoolConfig.DEFAULT_OBJECT_POOL_CONFIG;
    private boolean closed;
    private ObjectLock<K> objectLock;
    private Runnable fillCallback;

    public DefaultObjectPool() {
        this.init();
    }

    protected void init() {
        int maxActive = (int)this.objectPoolConfig.getMaxActive();
        int maxActivePerGroup = (int)this.objectPoolConfig.getMaxActivePerGroup();
        this.objectLock = maxActive > 0 || maxActivePerGroup > 0 ? new BlockObjectLock(maxActive, maxActivePerGroup) : new GrowObjectLock();
        this.startEvictionTask(this.objectPoolConfig.getIdleValidationInterval());
    }

    protected void startEvictionTask(long delay) {
        if (this.evictionTimer != null) {
            this.evictionTimer.cancel();
            this.evictionTimer = null;
        }
        if (delay > 0L) {
            this.evictionTimer = new Timer(true);
            this.evictionTimer.schedule((TimerTask)new EvictionTask(), delay, delay);
        }
    }

    @Override
    public long getActiveObjects() {
        return this.activeObjects.get();
    }

    @Override
    public long getIdleObjects() {
        return this.idleObjects.get();
    }

    private synchronized boolean synchronizedOffer(K key, V object) {
        Queue<V> objects = this.getObjects(key);
        return objects.offer(object);
    }

    @Override
    public void addObject(K key, I info) throws Exception {
        this.checkOpen();
        V object = this.createObject(key, info);
        if (this.synchronizedOffer(key, object)) {
            this.idleObjects.incrementAndGet();
        } else {
            this.closeObject(key, object, true, true);
        }
    }

    @Override
    public V borrowObject(K key, I info) throws Exception {
        V object;
        block4: {
            this.checkOpen();
            Queue<V> objects = this.getObjects(key);
            long maxAge = this.objectPoolConfig.getMaxAge();
            boolean testOnBorrow = this.objectPoolConfig.isTestOnBorrow();
            while (true) {
                this.objectLock.acquire(key);
                object = objects.poll();
                if (object == null) {
                    try {
                        object = this.createObject(key, info);
                        this.activeObjects.incrementAndGet();
                        break block4;
                    }
                    catch (Exception exception) {
                        this.objectLock.release(key);
                        throw exception;
                    }
                }
                this.activeObjects.incrementAndGet();
                this.idleObjects.decrementAndGet();
                ObjectState state = this.stateMap.get(object);
                long currentTime = System.currentTimeMillis();
                if ((maxAge <= 0L || currentTime <= state.getCreateTime() + maxAge) && (!testOnBorrow || this.validateObject(key, object))) break;
                this.closeObject(key, object, true, true);
            }
            this.objectFactory.activateObject(key, object, info);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(K key, V object, I info) throws Exception {
        this.checkOpen();
        ObjectState state = this.addObjectState(object);
        if (info != null) {
            state.setInfo(info);
        }
        long maxAge = this.objectPoolConfig.getMaxAge();
        boolean testOnReturn = this.objectPoolConfig.isTestOnReturn();
        try {
            if (maxAge != 0L && System.currentTimeMillis() > state.getCreateTime() + maxAge || testOnReturn && !this.validateObject(key, object)) {
                this.closeObject(key, object, true, false);
            } else {
                this.returnObject(key, object);
            }
        }
        finally {
            this.objectLock.release(key);
        }
    }

    @Override
    public void removeObject(K key, V object) throws Exception {
        this.checkOpen();
        Queue<V> objects = this.getObjects(key);
        if (objects != null && objects.remove(object)) {
            this.closeObject(key, object, true, true);
        }
    }

    protected void returnObject(K key, V object) throws Exception {
        ObjectState state = this.stateMap.get(object);
        if (state == null) {
            return;
        }
        this.objectFactory.passivateObject(key, object, state.getInfo());
        if (this.synchronizedOffer(key, object)) {
            this.idleObjects.incrementAndGet();
            this.activeObjects.decrementAndGet();
        } else {
            this.closeObject(key, object, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.checkOpen();
        try {
            this.startEvictionTask(-1L);
            for (Map.Entry<K, Queue<V>> entry : this.objectMap.entrySet()) {
                V object;
                ObjectKey key = (ObjectKey)entry.getKey();
                Queue<V> queue = entry.getValue();
                while ((object = queue.poll()) != null) {
                    this.closeObject(key, object, true, true);
                }
            }
        }
        finally {
            this.closed = true;
        }
    }

    protected final void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException(String.format("Pool %s is not open", this.getName()));
        }
    }

    protected Queue<V> getObjects(K objectKey) {
        Queue<V> queue;
        Queue<V> result = this.objectMap.get(objectKey);
        if (result == null && (queue = this.objectMap.putIfAbsent(objectKey, result = new ConcurrentLinkedQueue<V>())) != null) {
            result = this.objectMap.get(objectKey);
        }
        return result;
    }

    protected V createObject(K key, I info) throws Exception {
        V object = this.objectFactory.createObject(key, info);
        this.addObjectState(object).setInfo(info);
        return object;
    }

    protected ObjectState addObjectState(V object) {
        ObjectState newState = new ObjectState();
        ObjectState oldState = this.stateMap.putIfAbsent((ObjectState)object, newState);
        return oldState != null ? oldState : newState;
    }

    protected boolean validateObject(K key, V object) throws Exception {
        ObjectState state;
        boolean result = true;
        long validationInterval = this.objectPoolConfig.getValidationInterval();
        if (validationInterval > 0L && (state = this.stateMap.get(object)) != null && System.currentTimeMillis() > state.getValidateTime() + validationInterval) {
            result = this.objectFactory.validateObject(key, object, state.getInfo());
            state.setValidateTime(System.currentTimeMillis());
        }
        return result;
    }

    protected void closeObject(K key, V object, boolean decrementIdleObjects, boolean releaseLock) throws Exception {
        ObjectState state = this.stateMap.get(object);
        if (state == null) {
            return;
        }
        this.closeObject(key, object, state.getInfo(), decrementIdleObjects, releaseLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeObject(K key, V object, I info, boolean decrementIdleObjects, boolean releaseLock) throws Exception {
        try {
            this.objectFactory.closeObject(key, object, info);
        }
        finally {
            this.stateMap.remove(object);
            if (decrementIdleObjects) {
                this.idleObjects.decrementAndGet();
            }
            if (releaseLock) {
                this.objectLock.release(key);
            }
        }
    }

    @Override
    public ObjectFactory<K, V, I> getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public void setObjectFactory(ObjectFactory<K, V, I> objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ObjectPoolConfig getObjectPoolConfig() {
        return this.objectPoolConfig;
    }

    @Override
    public void setObjectPoolConfig(ObjectPoolConfig objectPoolConfig) {
        this.objectPoolConfig = objectPoolConfig != null ? objectPoolConfig : ObjectPoolConfig.DEFAULT_OBJECT_POOL_CONFIG;
        this.init();
    }

    @Override
    public void setFillCallback(Runnable callback) {
        this.fillCallback = callback;
    }

    protected void fillPool() {
        long minIdle = this.objectPoolConfig.getMinIdle();
        if (minIdle == 0L || this.fillCallback == null) {
            return;
        }
        long objectToCreate = Math.min(minIdle - this.idleObjects.get(), this.objectPoolConfig.getMaxActive() - this.activeObjects.get());
        int i = 0;
        while ((long)i < objectToCreate) {
            this.fillCallback.run();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evictObjects() throws Exception {
        Queue<V> queue;
        long maxIdle = this.objectPoolConfig.getMaxIdle();
        long maxAge = this.objectPoolConfig.getMaxAge();
        boolean testWhileIdle = this.objectPoolConfig.isTestWhileIdle();
        block3: while (this.idleObjects.get() > maxIdle) {
            for (Map.Entry<K, Queue<V>> entry : this.objectMap.entrySet()) {
                ObjectKey key = (ObjectKey)entry.getKey();
                queue = entry.getValue();
                V object = queue.poll();
                if (object == null) continue;
                this.closeObject(key, object, true, true);
                if (this.idleObjects.get() > maxIdle) continue;
                continue block3;
            }
        }
        if (maxAge > 0L || testWhileIdle) {
            HashSet<V> visited = new HashSet<V>();
            block5: for (Map.Entry<K, Queue<Object>> entry : this.objectMap.entrySet()) {
                V object;
                ObjectKey key = (ObjectKey)entry.getKey();
                Queue<V> queue2 = entry.getValue();
                while ((object = queue2.poll()) != null) {
                    if (!visited.add(object)) {
                        queue2.offer(object);
                        continue block5;
                    }
                    ObjectState state = this.stateMap.get(object);
                    if (state == null) continue;
                    if (maxAge > 0L && System.currentTimeMillis() > state.getCreateTime() + maxAge) {
                        this.closeObject(key, object, state.getInfo(), true, true);
                        continue;
                    }
                    if (testWhileIdle && !this.validateObject(key, object)) {
                        this.closeObject(key, object, state.getInfo(), true, true);
                        continue;
                    }
                    queue2.offer(object);
                }
            }
        }
        this.fillPool();
        DefaultObjectPool defaultObjectPool = this;
        synchronized (defaultObjectPool) {
            Iterator<Map.Entry<K, Queue<V>>> iterator = this.objectMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, Queue<Object>> entry;
                entry = iterator.next();
                queue = entry.getValue();
                if (!queue.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    class GrowObjectLock
    implements ObjectLock<K> {
        GrowObjectLock() {
        }

        @Override
        public void acquire(K objectKey) throws Exception {
        }

        @Override
        public void release(K objectKey) throws Exception {
        }
    }

    class BlockObjectLock
    implements ObjectLock<K> {
        private final int maxActivePerGroup;
        private final Semaphore activeObjects;
        private final ConcurrentHashMap<ObjectKey, Semaphore> activeObjectsPerGroupMap = new ConcurrentHashMap();

        public BlockObjectLock(int maxActive, int maxActivePerGroup) {
            this.activeObjects = maxActive != 0 ? new Semaphore(maxActive) : null;
            this.maxActivePerGroup = maxActivePerGroup;
        }

        @Override
        public void acquire(K objectKey) {
            Semaphore activeObjects = this.getActiveObjects();
            Semaphore activeObjectsPerGroup = this.getMaxActivePerGroup(objectKey.getGroupKey());
            while (true) {
                try {
                    this.acquire(activeObjects, activeObjectsPerGroup);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        protected void acquire(Semaphore activeObjects, Semaphore activeObjectsPerGroup) throws InterruptedException {
            long maxWait = DefaultObjectPool.this.objectPoolConfig.getMaxWait();
            boolean maxActivePerGroupAcquired = false;
            if (activeObjectsPerGroup != null) {
                if (maxWait == 0L) {
                    activeObjectsPerGroup.acquire();
                    maxActivePerGroupAcquired = true;
                } else {
                    maxActivePerGroupAcquired = activeObjectsPerGroup.tryAcquire(Math.max(1L, maxWait), TimeUnit.MILLISECONDS);
                    if (!maxActivePerGroupAcquired) {
                        throw new ObjectPoolException("Timeout while waiting for an object to be returned to the pool");
                    }
                }
            }
            if (activeObjects != null) {
                try {
                    if (maxWait == 0L) {
                        activeObjects.acquire();
                    } else if (!activeObjects.tryAcquire(Math.max(1L, maxWait), TimeUnit.MILLISECONDS)) {
                        throw new ObjectPoolException("Timeout while waiting for a object to be returned to the pool");
                    }
                }
                catch (Exception exception) {
                    if (maxActivePerGroupAcquired) {
                        activeObjectsPerGroup.release();
                    }
                    throw exception;
                }
            }
        }

        @Override
        public void release(K objectKey) {
            this.release(this.getActiveObjects(), this.getMaxActivePerGroup(objectKey.getGroupKey()));
        }

        protected void release(Semaphore activeObjects, Semaphore activeObjectsPerGroup) {
            if (activeObjectsPerGroup != null) {
                activeObjectsPerGroup.release();
            }
            if (activeObjects != null) {
                activeObjects.release();
            }
        }

        private Semaphore getActiveObjects() {
            return this.activeObjects;
        }

        private Semaphore getMaxActivePerGroup(ObjectKey groupKey) {
            Semaphore semaphore;
            Semaphore result = null;
            if (groupKey != null && this.maxActivePerGroup > 0 && (semaphore = this.activeObjectsPerGroupMap.putIfAbsent(groupKey, result = new Semaphore(this.maxActivePerGroup))) != null) {
                result = this.activeObjectsPerGroupMap.get(groupKey);
            }
            return result;
        }
    }

    static interface ObjectLock<K> {
        public void acquire(K var1) throws Exception;

        public void release(K var1) throws Exception;
    }

    class EvictionTask
    extends TimerTask {
        EvictionTask() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    DefaultObjectPool.this.evictObjects();
                }
                catch (Exception exception) {
                    Logger logger = DefaultObjectPool.this.getLogger();
                    if (logger == null) break block2;
                    logger.warn(String.format("Eviction from %s pool failure", DefaultObjectPool.this.getName()), exception);
                }
            }
        }
    }

    class ObjectState {
        private long createTime = System.currentTimeMillis();
        private long validateTime;
        private I info;

        ObjectState() {
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public long getValidateTime() {
            return this.validateTime;
        }

        public void setValidateTime(long validateTime) {
            this.validateTime = validateTime;
        }

        public I getInfo() {
            return this.info;
        }

        public void setInfo(I info) {
            this.info = info;
        }
    }
}

