/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Clob;
import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.Value;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;

public class ValueString
extends Value {
    String value;

    public ValueString() {
    }

    public ValueString(String val) {
        this.value = val;
    }

    public ValueString(Object val) {
        this.value = val instanceof String ? (String)val : val.toString();
    }

    public ValueString(Clob val) {
        this.value = val.value;
    }

    public ValueString(java.sql.Clob val) throws SQLException {
        this.value = val.getSubString(0L, (int)val.length());
    }

    @Override
    int getType() {
        return 1;
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeString(this.value);
    }

    @Override
    String getString() {
        return this.value;
    }

    @Override
    byte getByte() throws SQLException {
        try {
            return Byte.parseByte(this.value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Unable to convert string: " + this.value, e);
        }
    }

    @Override
    short getShort() throws SQLException {
        try {
            return Short.parseShort(this.value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Unable to convert string: " + this.value, e);
        }
    }

    @Override
    int getInt() throws SQLException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Unable to convert string: " + this.value, e);
        }
    }

    @Override
    long getLong() throws SQLException {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Unable to convert string: " + this.value, e);
        }
    }

    @Override
    float getFloat() throws SQLException {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Unable to convert string: " + this.value, e);
        }
    }

    @Override
    double getDouble() throws SQLException {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Unable to convert string: " + this.value, e);
        }
    }

    @Override
    Object getObject() {
        return this.getString();
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.value);
    }

    @Override
    Date getDate(SQLContext context) throws SQLException {
        try {
            return new Date(this.getDateFormatter(context.getTimeZone()).parse(this.value).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(MessageFormat.format("Unable to parse \"{0}\" into a Date", this.value), e);
        }
    }

    @Override
    Timestamp getTimestamp(SQLContext context) throws SQLException {
        try {
            return new Timestamp(this.getFractionsTimestamp(context.getTimeZone()).parse(this.value).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(MessageFormat.format("Unable to parse \"{0}\" into a Timestamp", this.value), e);
        }
    }

    @Override
    Time getTime(SQLContext context) throws SQLException {
        int idx = this.value.indexOf(46);
        DateFormat sdf = idx < 0 ? this.getSimpleTime(context.getTimeZone()) : this.getFractionsTime(context.getTimeZone());
        try {
            return new Time(sdf.parse(this.value).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(MessageFormat.format("Unable to parse \"{0}\" into a Time", this.value), e);
        }
    }

    @Override
    boolean getBoolean() {
        return this.value == null ? false : "true".equalsIgnoreCase(this.value);
    }
}

