/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Connection;
import com.nuodb.jdbc.ConnectionKey;
import com.nuodb.jdbc.pool.ObjectKey;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;

class StatementKey
implements ObjectKey {
    private final ConnectionKey connectionKey;
    private final Connection connection;
    private StatementType statementType = StatementType.STATEMENT;
    private String sql;
    private Integer resultSetType;
    private Integer resultSetConcurrency;
    private Integer resultSetHoldability;
    private Integer autoGeneratedKeys;
    private int[] columnIndexes;
    private String[] columnNames;

    public StatementKey(ConnectionKey connectionKey, Connection connection) {
        this.connectionKey = connectionKey;
        this.connection = connection;
    }

    public StatementKey(ConnectionKey connectionKey, Connection connection, int resultSetType, int resultSetConcurrency) {
        this.connectionKey = connectionKey;
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public StatementKey(ConnectionKey connectionKey, Connection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connectionKey = connectionKey;
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public StatementKey(ConnectionKey connectionKey, Connection connection, StatementType statementType, String sql) {
        this.connectionKey = connectionKey;
        this.connection = connection;
        this.statementType = statementType;
        this.sql = sql;
    }

    public StatementKey(ConnectionKey connectionKey, Connection connection, StatementType statementType, String sql, int resultSetType, int resultSetConcurrency) {
        this.connectionKey = connectionKey;
        this.connection = connection;
        this.statementType = statementType;
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public StatementKey(ConnectionKey connectionKey, Connection connection, StatementType statementType, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connectionKey = connectionKey;
        this.connection = connection;
        this.sql = sql;
        this.statementType = statementType;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public StatementKey(ConnectionKey connectionKey, Connection connection, StatementType statementType, String sql, int autoGeneratedKeys) {
        this.connectionKey = connectionKey;
        this.connection = connection;
        this.statementType = statementType;
        this.sql = sql;
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public StatementKey(ConnectionKey connectionKey, Connection connection, StatementType statementType, String sql, int[] columnIndexes) {
        this.connectionKey = connectionKey;
        this.connection = connection;
        this.statementType = statementType;
        this.sql = sql;
        this.columnIndexes = columnIndexes;
    }

    public StatementKey(ConnectionKey connectionKey, Connection connection, StatementType statementType, String sql, String[] columnNames) {
        this.connectionKey = connectionKey;
        this.connection = connection;
        this.statementType = statementType;
        this.sql = sql;
        this.columnNames = columnNames;
    }

    @Override
    public ObjectKey getGroupKey() {
        return this.connectionKey;
    }

    public ConnectionKey getConnectionKey() {
        return this.connectionKey;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public String getSql() {
        return this.sql;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public Integer getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public Integer getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Integer getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementKey that = (StatementKey)o;
        if (this.connectionKey != null ? !this.connectionKey.equals(that.connectionKey) : that.connectionKey != null) {
            return false;
        }
        if (this.connection != null ? !this.connection.equals(that.connection) : that.connection != null) {
            return false;
        }
        if (this.statementType != that.statementType) {
            return false;
        }
        if (this.sql != null ? !this.sql.equals(that.sql) : that.sql != null) {
            return false;
        }
        if (this.resultSetType != null ? !this.resultSetType.equals(that.resultSetType) : that.resultSetType != null) {
            return false;
        }
        if (this.resultSetConcurrency != null ? !this.resultSetConcurrency.equals(that.resultSetConcurrency) : that.resultSetConcurrency != null) {
            return false;
        }
        if (this.resultSetHoldability != null ? !this.resultSetHoldability.equals(that.resultSetHoldability) : that.resultSetHoldability != null) {
            return false;
        }
        if (this.autoGeneratedKeys != null ? !this.autoGeneratedKeys.equals(that.autoGeneratedKeys) : that.autoGeneratedKeys != null) {
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, that.columnIndexes)) {
            return false;
        }
        return Arrays.equals(this.columnNames, that.columnNames);
    }

    public int hashCode() {
        int result = this.connectionKey != null ? this.connectionKey.hashCode() : 0;
        result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
        result = 31 * result + (this.statementType != null ? this.statementType.hashCode() : 0);
        result = 31 * result + (this.sql != null ? this.sql.hashCode() : 0);
        result = 31 * result + (this.resultSetType != null ? this.resultSetType.hashCode() : 0);
        result = 31 * result + (this.resultSetConcurrency != null ? this.resultSetConcurrency.hashCode() : 0);
        result = 31 * result + (this.resultSetHoldability != null ? this.resultSetHoldability.hashCode() : 0);
        result = 31 * result + (this.autoGeneratedKeys != null ? this.autoGeneratedKeys.hashCode() : 0);
        result = 31 * result + (this.columnIndexes != null ? Arrays.hashCode(this.columnIndexes) : 0);
        result = 31 * result + (this.columnNames != null ? Arrays.hashCode(this.columnNames) : 0);
        return result;
    }

    public static enum StatementType {
        STATEMENT(Statement.class),
        PREPARED_STATEMENT(PreparedStatement.class),
        CALLABLE_STATEMENT(CallableStatement.class);

        private final Class statementClass;

        private StatementType(Class statementClass) {
            this.statementClass = statementClass;
        }

        public Class getStatementClass() {
            return this.statementClass;
        }
    }
}

