/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.xml;

import com.nuodb.impl.util.Op;
import com.nuodb.impl.xml.AttributeImpl;
import com.nuodb.impl.xml.Doc;
import com.nuodb.xml.Attribute;
import com.nuodb.xml.Tag;
import com.nuodb.xml.XmlException;
import java.util.Iterator;

public class TagImpl
implements Tag {
    String name;
    TagImpl children;
    AttributeImpl attributes;
    TagImpl sibling;
    String innerText;
    String outerText;
    boolean cdata;
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    static String[] escapes = new String[256];

    public TagImpl() {
    }

    public TagImpl(String newName) {
        this.name = newName;
    }

    public void parse(String tag) throws XmlException {
        Doc doc = new Doc(tag);
        doc.skipWhite();
        if (!doc.match('<')) {
            throw new XmlException("expected xml tag, got " + doc.getTail());
        }
        this.name = doc.getToken();
        if (this.name.equals("?xml")) {
            this.parseAttributes(doc);
            doc.setDeclaration(this.attributes);
            this.attributes = null;
        } else if (!this.parseAttributes(doc)) {
            this.parseChildren(doc);
        }
    }

    public void parse(Doc doc) throws XmlException {
        doc.skipWhite();
        if (!doc.match('<')) {
            throw new XmlException("expected xml tag, got: " + doc.getTail());
        }
        this.name = doc.getToken();
        if (!this.parseAttributes(doc)) {
            this.parseChildren(doc);
        }
        this.outerText = doc.parseText();
    }

    @Override
    public boolean isNamed(String string) {
        return this.name.equals(string);
    }

    public TagImpl(String tag, Doc doc) throws XmlException {
        this.name = tag;
        if (!this.parseAttributes(doc)) {
            this.parseChildren(doc);
        }
        this.outerText = doc.parseText();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getText() {
        return this.innerText;
    }

    @Override
    public void setText(String text) {
        this.innerText = text;
    }

    public void setCData(String text) {
        this.innerText = text;
        this.cdata = true;
    }

    @Override
    public Tag addChild(String name) {
        TagImpl child = new TagImpl(name);
        return this.addChild(child);
    }

    @Override
    public Tag addChild(Tag t) {
        if (!(t instanceof TagImpl)) {
            throw new IllegalArgumentException("Cannot child instance from different implementation");
        }
        TagImpl tag = (TagImpl)t;
        tag.sibling = null;
        if (this.children == null) {
            this.children = tag;
        } else {
            TagImpl child = this.children;
            while (true) {
                if (child.sibling == null) {
                    child.sibling = tag;
                    break;
                }
                child = child.sibling;
            }
        }
        return tag;
    }

    public Tag insert(String name, String attribute, int sequence) {
        TagImpl child = new TagImpl(name);
        child.addAttribute(attribute, sequence);
        this.insert(child, attribute, sequence);
        return child;
    }

    public void insert(TagImpl tag, String attribute, int sequence) {
        TagImpl prior = null;
        TagImpl child = this.children;
        while (child != null && sequence >= child.getIntAttribute(attribute, 1000000)) {
            prior = child;
            child = child.sibling;
        }
        if (prior == null) {
            tag.sibling = this.children;
            this.children = tag;
        } else {
            tag.sibling = prior.sibling;
            prior.sibling = tag;
        }
    }

    public boolean deleteItem(TagImpl item) {
        TagImpl prior = null;
        TagImpl child = this.children;
        while (child != null) {
            if (child == item) {
                if (prior == null) {
                    this.children = item.sibling;
                } else {
                    prior.sibling = item.sibling;
                }
                return true;
            }
            prior = child;
            child = child.sibling;
        }
        return false;
    }

    @Override
    public void addAttribute(String name, int value) {
        this.addAttribute(name, String.valueOf(value));
    }

    @Override
    public void addAttribute(String name, boolean value) {
        this.addAttribute(name, value ? TRUE : FALSE);
    }

    @Override
    public void addAttribute(String name, long value) {
        this.addAttribute(name, String.valueOf(value));
    }

    @Override
    public void addAttribute(String name, String value) {
        this.addAttribute(new AttributeImpl(name, value));
    }

    @Override
    public void addAttribute(String name, Tag source) throws XmlException {
        this.addAttribute(new AttributeImpl(name, source.getAttribute(name)));
    }

    public void addAttribute(AttributeImpl attribute) {
        attribute.sibling = null;
        if (this.attributes == null) {
            this.attributes = attribute;
        } else {
            AttributeImpl attr = this.attributes;
            while (true) {
                if (attr.sibling == null) {
                    attr.sibling = attribute;
                    break;
                }
                attr = attr.sibling;
            }
        }
    }

    @Override
    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    @Override
    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, value ? TRUE : FALSE);
    }

    @Override
    public void setAttribute(String name, long value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, Tag source) throws XmlException {
        this.setAttribute(name, source.getAttribute(name));
    }

    @Override
    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new AttributeImpl(name, value);
            this.attributes.sibling = null;
        } else {
            AttributeImpl attr = this.attributes;
            while (true) {
                if (attr.getName().equals(name)) {
                    attr.setValue(value);
                    break;
                }
                if (attr.sibling == null) {
                    attr.sibling = new AttributeImpl(name, value);
                    attr.sibling.sibling = null;
                    break;
                }
                attr = attr.sibling;
            }
        }
    }

    public boolean parseAttributes(Doc doc) throws XmlException {
        AttributeImpl attr = null;
        boolean empty = false;
        while (true) {
            doc.skipWhite();
            if (doc.match('/')) {
                empty = true;
                continue;
            }
            if (doc.match('>')) break;
            AttributeImpl attribute = new AttributeImpl(doc);
            if (attr == null) {
                this.attributes = attribute;
            } else {
                attr.sibling = attribute;
            }
            attr = attribute;
        }
        return empty;
    }

    public void parseChildren(Doc doc) throws XmlException {
        this.innerText = doc.parseText();
        TagImpl child = null;
        while (true) {
            if (!doc.match('<')) {
                doc.print("Tag.parseChildren: ", 30);
                throw new XmlException("invalid xml document -- malformed");
            }
            String string = doc.getToken();
            if (string.isEmpty()) {
                throw new XmlException("invalid xml document - malformed \"<" + doc.parseText() + "\"");
            }
            if (string.charAt(0) == '/') {
                if (!doc.match('>')) {
                    throw new XmlException("invalid xml ending tag");
                }
                int l = this.name.length();
                if (string.length() != l + 1) {
                    throw new XmlException("invalid xml document -- unmatched tag \"" + this.name + "\"");
                }
                for (int n = 0; n < l; ++n) {
                    if (this.name.charAt(n) == string.charAt(n + 1)) continue;
                    throw new XmlException("invalid xml document -- unmatched tag \"" + this.name + "\"");
                }
                return;
            }
            TagImpl item = new TagImpl(string, doc);
            if (child == null) {
                this.children = item;
            } else {
                child.sibling = item;
            }
            child = item;
        }
    }

    public boolean isTag() {
        return true;
    }

    @Override
    public void print() {
        this.prettyPrint(0);
        System.out.println();
    }

    @Override
    public void prettyPrint(int column) {
        this.space(column);
        System.out.print("<" + this.name);
        AttributeImpl attribute = this.attributes;
        while (attribute != null) {
            attribute.print();
            attribute = attribute.sibling;
        }
        if (this.children == null && this.innerText == null) {
            System.out.println("/>");
        } else if (this.children == null && this.innerText != null) {
            System.out.println("> " + this.innerText + " </" + this.name + ">");
        } else {
            System.out.println(">");
            ++column;
            TagImpl item = this.children;
            while (item != null) {
                item.prettyPrint(column);
                item = item.sibling;
            }
            this.space(--column);
            System.out.println("</" + this.name + ">");
        }
    }

    public String toString() {
        StringBuilder stringBuffer = new StringBuilder();
        this.gen(0, stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public void gen(int level, StringBuilder buffer) {
        int start = buffer.length();
        buffer.append("<");
        buffer.append(this.name);
        int attrIndent = level * 2 + 1 + buffer.length() - start;
        int attrLimit = buffer.length() + 60;
        AttributeImpl attribute = this.attributes;
        while (attribute != null) {
            int len = buffer.length();
            if (len < attrLimit) {
                buffer.append(" ");
            } else {
                buffer.append("\n");
                this.indent(attrIndent, buffer);
                attrLimit = len + 60;
            }
            buffer.append(attribute.getName());
            buffer.append("=\"");
            try {
                this.putQuotedText(attribute.getValue(), buffer);
            }
            catch (NullPointerException e) {
                throw new NullPointerException("null value for attribute: " + attribute.getName());
            }
            buffer.append("\"");
            attribute = attribute.sibling;
        }
        if (this.innerText != null) {
            buffer.append(">");
            if (this.cdata) {
                buffer.append("<![CDATA[");
                buffer.append(this.innerText);
                buffer.append("]]>");
            } else {
                this.putQuotedText(this.innerText, buffer);
            }
        } else {
            if (this.children == null) {
                buffer.append("/>\n");
                return;
            }
            buffer.append(">\n");
        }
        ++level;
        TagImpl child = this.children;
        while (child != null) {
            this.space(level, buffer);
            child.gen(level, buffer);
            child = child.sibling;
        }
        if (this.children != null || this.innerText == null) {
            this.space(level - 1, buffer);
        }
        buffer.append("</");
        buffer.append(this.name);
        buffer.append(">\n");
    }

    public void putQuotedText(String text, StringBuilder buffer) {
        int length = text.length();
        for (int n = 0; n < length; ++n) {
            char c = text.charAt(n);
            if (c < escapes.length && escapes[c] != null) {
                buffer.append(escapes[c]);
                continue;
            }
            buffer.append(c);
        }
    }

    public void space(int level, StringBuilder buffer) {
        for (int n = 0; n < level; ++n) {
            buffer.append("  ");
        }
    }

    public void indent(int spaces, StringBuilder buffer) {
        for (int n = 0; n < spaces; ++n) {
            buffer.append(" ");
        }
    }

    @Override
    public Iterator<Tag> iterator() {
        return new Children(this);
    }

    @Override
    public Iterator<Tag> children() {
        return new Children(this);
    }

    @Override
    public Iterator<Attribute> getAttributes() {
        return new Attr(this);
    }

    @Override
    public String getAttribute(String name) throws XmlException {
        AttributeImpl attribute = this.attributes;
        while (attribute != null) {
            if (attribute.name.equals(name)) {
                return attribute.value;
            }
            attribute = attribute.sibling;
        }
        throw new XmlException("can't find attribute \"" + name + "\"");
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        AttributeImpl attribute = this.attributes;
        while (attribute != null) {
            if (attribute.name.equals(name)) {
                return attribute.value;
            }
            attribute = attribute.sibling;
        }
        return defaultValue;
    }

    @Override
    public int getIntAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Op.getInt(value);
    }

    @Override
    public int getIntAttribute(String name) throws XmlException {
        String value = this.getAttribute(name, null);
        if (value == null) {
            throw new XmlException("can't find attribute \"" + name + "\"");
        }
        return Op.getInt(value);
    }

    @Override
    public boolean getBooleanAttribute(String name, boolean defaultValue) {
        String value = this.getAttribute(name, null);
        if (value == null) {
            return defaultValue;
        }
        return value.equals(TRUE) || value.trim().equals("1");
    }

    @Override
    public boolean getBooleanAttribute(String name) throws XmlException {
        String value = this.getAttribute(name, null);
        if (value == null) {
            throw new XmlException("can't find attribute \"" + name + "\"");
        }
        return value.equals(TRUE) || value.trim().equals("1");
    }

    @Override
    public long getLongAttribute(String name, long defaultValue) {
        String value = this.getAttribute(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Op.getLong(value);
    }

    @Override
    public long getLongAttribute(String name) throws XmlException {
        String value = this.getAttribute(name, null);
        if (value == null) {
            throw new XmlException("can't find attribute \"" + name + "\"");
        }
        return Op.getLong(value);
    }

    @Override
    public String getValue() {
        if (this.children != null && this.children.sibling == null) {
            return this.children.getValue();
        }
        return null;
    }

    @Override
    public Tag getChild(String name) throws XmlException {
        Tag child = this.findChild(name);
        if (child != null) {
            return child;
        }
        throw new XmlException("can't find \"" + name + "\" in XML tag");
    }

    @Override
    public Tag findChild(String attribute, String value) {
        TagImpl item = this.children;
        while (item != null) {
            if (item.getAttribute(attribute, "").equals(value)) {
                return item;
            }
            item = item.sibling;
        }
        return null;
    }

    @Override
    public Tag findChild(String name) {
        TagImpl item = this.children;
        while (item != null) {
            if (item.isTag() && item.name.equals(name)) {
                return item;
            }
            item = item.sibling;
        }
        return null;
    }

    public void space(int column) {
        for (int n = 0; n < column; ++n) {
            System.out.print("  ");
        }
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null;
    }

    @Override
    public int getAttributeCount() {
        int i = 0;
        Iterator<Attribute> it = this.getAttributes();
        while (it.hasNext()) {
            ++i;
            it.next();
        }
        return i;
    }

    @Override
    public int getChildCount() {
        int i = 0;
        Iterator<Tag> it = this.children();
        while (it.hasNext()) {
            ++i;
            it.next();
        }
        return i;
    }

    @Override
    public void print(StringBuilder stringBuffer) {
        this.print(0, stringBuffer);
    }

    public void print(int level, StringBuilder stringBuffer) {
        for (int n = 0; n < level; ++n) {
            stringBuffer.append("   ");
        }
        stringBuffer.append(this.name);
        String sep = " ";
        AttributeImpl attribute = this.attributes;
        while (attribute != null) {
            stringBuffer.append(sep);
            stringBuffer.append(attribute.name);
            stringBuffer.append("=");
            stringBuffer.append(attribute.value);
            sep = ", ";
            attribute = attribute.sibling;
        }
        stringBuffer.append("\n");
        TagImpl child = this.children;
        while (child != null) {
            child.print(level + 1, stringBuffer);
            child = child.sibling;
        }
    }

    static {
        TagImpl.escapes[38] = "&amp;";
        TagImpl.escapes[39] = "&apos;";
        TagImpl.escapes[34] = "&quot;";
        TagImpl.escapes[60] = "&lt;";
        TagImpl.escapes[62] = "&gt;";
    }

    class Attr
    implements Iterator<Attribute> {
        AttributeImpl nextAttribute;

        public Attr(TagImpl tag) {
            this.nextAttribute = tag.attributes;
        }

        @Override
        public boolean hasNext() {
            return this.nextAttribute != null;
        }

        @Override
        public Attribute next() {
            AttributeImpl attribute = this.nextAttribute;
            this.nextAttribute = attribute.sibling;
            return attribute;
        }

        @Override
        public void remove() {
            assert (false);
        }
    }

    class Children
    implements Iterator<Tag> {
        TagImpl sibling;

        public Children(TagImpl tag) {
            this.sibling = tag.children;
        }

        @Override
        public boolean hasNext() {
            return this.sibling != null;
        }

        @Override
        public Tag next() {
            TagImpl object = this.sibling;
            this.sibling = this.sibling.sibling;
            return object;
        }

        @Override
        public void remove() {
            assert (false);
        }
    }
}

