/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.Preconditions;

public class DataSize {
    private static char[] units = new char[]{'b', 'k', 'm', 'g'};
    private static long[] multiplier = new long[]{1L, 1024L, 0x100000L, 0x40000000L};
    public static final String suffixesShort = "B/K/M/G";
    public static final String suffixesLong = "bytes/kilobytes/megabytes/gigabytes";

    public static long asBytes(String data) {
        Preconditions.checkArgument(data != null && data.trim().length() > 0, "empty string");
        char last = Character.toLowerCase(data.charAt(data.length() - 1));
        if (last >= '0' && last <= '9') {
            return Long.parseLong(data);
        }
        String number = data.substring(0, data.length() - 1);
        Preconditions.checkArgument(!number.contains(".") || last != 'b', "fractional bytes: %s", data);
        for (int i = 0; i <= units.length - 1; ++i) {
            if (units[i] != last) continue;
            return (long)(Float.parseFloat(number) * (float)multiplier[i]);
        }
        throw new IllegalArgumentException("Invalid unit suffix '" + last + "'. Allowed suffixes are " + suffixesShort + " (" + suffixesLong + "). Default is B if no suffix is provided.");
    }

    public static String bytesAsString(long data) {
        if (data < 1L) {
            return Long.toString(data);
        }
        for (int i = multiplier.length - 1; i >= 0; --i) {
            if (Math.abs(data) < multiplier[i]) continue;
            return String.format("%.1f%s", Float.valueOf((float)data / (float)multiplier[i]), Character.valueOf(units[i]));
        }
        throw new IllegalArgumentException("Invalid size '" + Long.toString(data) + "'. Data sizes may end in a unit suffix " + suffixesShort + " (" + suffixesLong + "). The default is B if no suffix is provided.");
    }
}

