/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats.metrics;

import com.nuodb.impl.stats.metrics.MetricSeriesImpl;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.stats.metrics.MetricBreakdownSeries;
import com.nuodb.stats.metrics.MetricPoint;
import com.nuodb.stats.metrics.MetricSeries;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetricBreakdownSeriesImpl
implements MetricBreakdownSeries {
    private Set<MetricSeries> data = new HashSet<MetricSeries>();

    public MetricBreakdownSeriesImpl() {
    }

    public MetricBreakdownSeriesImpl(Set<MetricSeries> data) {
        this.data = data;
    }

    public MetricBreakdownSeriesImpl(Tag tag) throws XmlException {
        Preconditions.checkArgument("MetricBreakdownSeries".equals(tag.getName()), "not a MetricBreakdownSeries tag: %s", tag);
        Iterator<Tag> tags = tag.children();
        while (tags.hasNext()) {
            this.data.add(new MetricSeriesImpl(tags.next()));
        }
    }

    @Override
    public MetricBreakdownSeries encode(Tag tag) {
        for (MetricSeries item : this.data) {
            tag.addChild(item.toTag());
        }
        return this;
    }

    @Override
    public Tag toTag() {
        Tag t = TagFactory.createTag("MetricBreakdownSeries");
        this.encode(t);
        return t;
    }

    @Override
    public Set<MetricSeries> getData() {
        return this.data;
    }

    @Override
    public MetricBreakdownSeries setData(Set<MetricSeries> data) {
        this.data = data;
        return this;
    }

    public MetricBreakdownSeries setData(Map<String, List<MetricPoint>> series) {
        for (Map.Entry<String, List<MetricPoint>> entry : series.entrySet()) {
            this.data.add(new MetricSeriesImpl(entry.getValue(), entry.getKey()));
        }
        return this;
    }

    public Map<String, List<MetricPoint>> asMap() {
        HashMap<String, List<MetricPoint>> result = new HashMap<String, List<MetricPoint>>(this.data.size());
        for (MetricSeries series : this.data) {
            series.getBreakdownValue();
            result.put(series.getBreakdownValue(), series.getData());
        }
        return result;
    }
}

