/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.net;

import com.nuodb.impl.net.LengthUtil;
import com.nuodb.impl.security.Cipher;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CryptoInputStream
extends InputStream {
    InputStream stream;
    Cipher cipher;
    byte[] lengthBuffer;

    public CryptoInputStream(InputStream inputStream) {
        this.stream = new BufferedInputStream(inputStream);
        this.lengthBuffer = new byte[4];
    }

    public void encrypt(Cipher encryptionEngine) {
        this.cipher = encryptionEngine;
    }

    @Override
    public int read() throws IOException {
        if (this.cipher == null) {
            return this.stream.read();
        }
        byte[] buffer = new byte[1];
        int n = this.cipher.read(this.stream, buffer, 0, 1);
        return n == 0 ? -1 : buffer[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.cipher == null) {
            return this.stream.read(b, offset, length);
        }
        return this.cipher.read(this.stream, b, offset, length);
    }

    public int readLength() throws IOException {
        return LengthUtil.readLength(this.stream, this.lengthBuffer);
    }

    public byte[] readMessage() throws IOException {
        int length = this.readLength();
        byte[] data = new byte[length];
        this.read(data);
        return data;
    }
}

