/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.net;

import com.nuodb.impl.net.SocketListener;
import com.nuodb.impl.security.RemotePassword;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.io.IOException;
import java.io.InterruptedIOException;

public final class AuthUtil {
    public static final String DEFAULT_CIPHER = "RC4";

    public static void initiateAuthorizedSession(SocketListener listener, String serviceName, String authzType) throws IOException {
        Tag tag = TagFactory.createTag("Authorize");
        tag.addAttribute("TargetService", serviceName);
        tag.addAttribute("Type", authzType);
        listener.send(tag);
    }

    public static byte[] runSRPExchange(SocketListener listener, String serviceName, String cipherName, String username, String password) throws IOException {
        AuthUtil.initiateAuthorizedSession(listener, serviceName, "SRP");
        RemotePassword rp = new RemotePassword();
        Tag tag = TagFactory.createTag("SRPRequest");
        tag.addAttribute("ClientKey", rp.genClientKey());
        tag.addAttribute("Cipher", cipherName);
        tag.addAttribute("Username", username);
        listener.send(tag);
        try {
            tag = listener.getXmlMessage();
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException("Login credentials were rejected");
        }
        try {
            return rp.computeSessionKey(username, password, tag.getAttribute("Salt"), tag.getAttribute("ServerKey"));
        }
        catch (XmlException xmle) {
            throw new IOException("Invalid response message", xmle);
        }
    }
}

