/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.agent;

import com.nuodb.impl.util.Preconditions;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.bind.DatatypeConverter;

public final class TLSCertificate
implements Comparable<TLSCertificate> {
    public static final String REVOKED_BASE64 = "REVOKED";
    private static final String delimiter = "-";
    private final int version;
    private final String base64;

    public TLSCertificate(int version, String base64) {
        this.version = version;
        this.base64 = base64;
        this.validate();
    }

    public TLSCertificate(int version, byte[] bytes) {
        this(version, DatatypeConverter.printBase64Binary((byte[])bytes));
    }

    public TLSCertificate(String encoded) {
        Preconditions.checkArgument(!StringUtils.isBlank(encoded), "Encoded cert can not be empty.");
        int versionEnd = encoded.indexOf(delimiter);
        Preconditions.checkArgument(versionEnd != -1, "Version was not found in encoded certificate.");
        this.version = Integer.parseInt(encoded.substring(0, versionEnd));
        this.base64 = encoded.substring(versionEnd + 1);
        this.validate();
    }

    public TLSCertificate(Tag peerTag) {
        Preconditions.checkArgument(peerTag != null, "peerTag can not be null.");
        this.version = peerTag.getIntAttribute("Version", 0);
        this.base64 = peerTag.getText();
        this.validate();
    }

    private void validate() {
        Preconditions.checkArgument(!StringUtils.isBlank(this.base64), "Empty certificate data");
        Preconditions.checkArgument(this.version > 0, "version has to be larger than 0");
    }

    public int getVersion() {
        return this.version;
    }

    public String getBase64() {
        return this.base64;
    }

    public String toString() {
        return this.version + delimiter + this.base64;
    }

    public InputStream toInputStream() {
        byte[] decoded = DatatypeConverter.parseBase64Binary((String)this.base64);
        return new ByteArrayInputStream(decoded);
    }

    public Tag toPeerTag() {
        Tag peerTag = TagFactory.createTag("Peer");
        peerTag.addAttribute("Version", this.version);
        peerTag.setText(this.base64);
        return peerTag;
    }

    public boolean isRevoked() {
        return this.base64.equals(REVOKED_BASE64);
    }

    @Override
    public int compareTo(TLSCertificate other) {
        return this.getVersion() - other.getVersion();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof TLSCertificate) {
            TLSCertificate anotherCert = (TLSCertificate)anObject;
            return this.version == anotherCert.version && this.base64.equals(anotherCert.base64);
        }
        return false;
    }
}

