/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaTextBorder;
import com.bulenkov.iconloader.util.GraphicsConfig;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class DarculaPasswordFieldUI
extends BasicPasswordFieldUI {
    private FocusListener myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            DarculaPasswordFieldUI.this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarculaPasswordFieldUI.this.getComponent().repaint();
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarculaPasswordFieldUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this.myFocusListener);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.myFocusListener);
        super.uninstallListeners();
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Border border;
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        if (parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if ((border = c.getBorder()) instanceof DarculaTextBorder) {
            g.setColor(c.getBackground());
            int width = c.getWidth();
            int height = c.getHeight();
            Insets i = border.getBorderInsets(c);
            if (c.hasFocus()) {
                GraphicsConfig config = new GraphicsConfig(g);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g.fillRoundRect(i.left - 5, i.top - 2, width - i.left - i.right + 10, height - i.top - i.bottom + 6, 5, 5);
                config.restore();
            } else {
                g.fillRect(i.left - 5, i.top - 2, width - i.left - i.right + 12, height - i.top - i.bottom + 6);
            }
        } else {
            super.paintBackground(g);
        }
    }
}

