/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import com.jidesoft.thirdparty.prefuse.util.collections.AbstractHashMap;
import java.util.ArrayList;
import java.util.Arrays;

public class IntObjectHashMap
extends AbstractHashMap
implements Cloneable {
    protected static final int defaultCapacity = 277;
    protected static final double defaultMinLoadFactor = 0.2;
    protected static final double defaultMaxLoadFactor = 0.5;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected int[] table;
    protected Object[] values;
    protected byte[] state;
    protected int freeEntries;

    public IntObjectHashMap() {
        this(277);
    }

    public IntObjectHashMap(int n2) {
        this(n2, 0.2, 0.5);
    }

    public IntObjectHashMap(int n2, double d2, double d3) {
        this.setUp(n2, d2, d3);
    }

    @Override
    public void clear() {
        Arrays.fill(this.state, (byte)0);
        Arrays.fill(this.values, null);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        try {
            IntObjectHashMap intObjectHashMap = (IntObjectHashMap)super.clone();
            intObjectHashMap.table = (int[])intObjectHashMap.table.clone();
            intObjectHashMap.values = (Object[])intObjectHashMap.values.clone();
            intObjectHashMap.state = (byte[])intObjectHashMap.state.clone();
            return intObjectHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean containsKey(int n2) {
        return this.indexOfKey(n2) >= 0;
    }

    public boolean containsValue(Object object) {
        return this.indexOfValue(object) >= 0;
    }

    @Override
    public void ensureCapacity(int n2) {
        if (this.table.length < n2) {
            int n3 = this.nextPrime(n2);
            this.rehash(n3);
        }
    }

    public Object get(int n2) {
        int n3 = this.indexOfKey(n2);
        if (n3 < 0) {
            return null;
        }
        return this.values[n3];
    }

    protected int indexOfInsertion(int n2) {
        int[] nArray = this.table;
        byte[] byArray = this.state;
        int n3 = nArray.length;
        int n4 = n2 & Integer.MAX_VALUE;
        int n5 = n4 % n3;
        int n6 = n4 % (n3 - 2);
        if (n6 == 0) {
            n6 = 1;
        }
        while (byArray[n5] == 1 && nArray[n5] != n2) {
            if ((n5 -= n6) >= 0) continue;
            n5 += n3;
        }
        if (byArray[n5] == 2) {
            int n7 = n5;
            while (byArray[n5] != 0 && (byArray[n5] == 2 || nArray[n5] != n2)) {
                if ((n5 -= n6) >= 0) continue;
                n5 += n3;
            }
            if (byArray[n5] == 0) {
                n5 = n7;
            }
        }
        if (byArray[n5] == 1) {
            return -n5 - 1;
        }
        return n5;
    }

    protected int indexOfKey(int n2) {
        int[] nArray = this.table;
        byte[] byArray = this.state;
        int n3 = nArray.length;
        int n4 = n2 & Integer.MAX_VALUE;
        int n5 = n4 % n3;
        int n6 = n4 % (n3 - 2);
        if (n6 == 0) {
            n6 = 1;
        }
        while (byArray[n5] != 0 && (byArray[n5] == 2 || nArray[n5] != n2)) {
            if ((n5 -= n6) >= 0) continue;
            n5 += n3;
        }
        if (byArray[n5] == 0) {
            return -1;
        }
        return n5;
    }

    protected int indexOfValue(Object object) {
        Object[] objectArray = this.values;
        byte[] byArray = this.state;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            if (byArray[n2] != 1 || objectArray[n2] != object) continue;
            return n2;
        }
        return -1;
    }

    public int keyOf(Object object) {
        int n2 = this.indexOfValue(object);
        if (n2 < 0) {
            return Integer.MIN_VALUE;
        }
        return this.table[n2];
    }

    public int keys(int[] nArray) {
        int[] nArray2 = this.table;
        byte[] byArray = this.state;
        if (nArray.length < this.distinct) {
            return -1;
        }
        int n2 = 0;
        int n3 = nArray2.length;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            nArray[n2++] = nArray2[n3];
        }
        return this.distinct;
    }

    public boolean put(int n2, Object object) {
        int n3 = this.indexOfInsertion(n2);
        if (n3 < 0) {
            n3 = -n3 - 1;
            this.values[n3] = object;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n4 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n4);
            return this.put(n2, object);
        }
        this.table[n3] = n2;
        this.values[n3] = object;
        if (this.state[n3] == 0) {
            --this.freeEntries;
        }
        this.state[n3] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n5 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n5);
        }
        return true;
    }

    protected void rehash(int n2) {
        int n3 = this.table.length;
        int[] nArray = this.table;
        Object[] objectArray = this.values;
        byte[] byArray = this.state;
        int[] nArray2 = new int[n2];
        Object[] objectArray2 = new Object[n2];
        byte[] byArray2 = new byte[n2];
        this.lowWaterMark = this.chooseLowWaterMark(n2, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
        this.table = nArray2;
        this.values = objectArray2;
        this.state = byArray2;
        this.freeEntries = n2 - this.distinct;
        int n4 = n3;
        while (n4-- > 0) {
            if (byArray[n4] != 1) continue;
            int n5 = nArray[n4];
            int n6 = this.indexOfInsertion(n5);
            nArray2[n6] = n5;
            objectArray2[n6] = objectArray[n4];
            byArray2[n6] = 1;
        }
    }

    public boolean removeKey(int n2) {
        int n3 = this.indexOfKey(n2);
        if (n3 < 0) {
            return false;
        }
        this.state[n3] = 2;
        this.values[n3] = null;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n4 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n4);
        }
        return true;
    }

    @Override
    protected void setUp(int n2, double d2, double d3) {
        int n3 = n2;
        super.setUp(n3, d2, d3);
        n3 = this.nextPrime(n3);
        if (n3 == 0) {
            n3 = 1;
        }
        this.table = new int[n3];
        this.values = new Object[n3];
        this.state = new byte[n3];
        this.minLoadFactor = d2;
        this.maxLoadFactor = n3 == Integer.MAX_VALUE ? 1.0 : d3;
        this.distinct = 0;
        this.freeEntries = n3;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n3, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int n2 = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n2) {
            this.rehash(n2);
        }
    }

    public void values(ArrayList arrayList) {
        Object[] objectArray = this.values;
        byte[] byArray = this.state;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            arrayList.add(objectArray[n2]);
        }
    }
}

