/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.event.ColumnListener;
import com.jidesoft.thirdparty.prefuse.data.util.Index;
import com.jidesoft.thirdparty.prefuse.util.DataLib;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;
import com.jidesoft.thirdparty.prefuse.util.collections.DefaultLiteralComparator;
import java.util.Comparator;
import java.util.Map;

public class ColumnMetadata
implements ColumnListener {
    private Table \u011d;
    private String \u0119;
    private boolean \u0124;
    private boolean \u011a;
    private Comparator \u0122;
    private Object \u0118;
    private int \u011b;
    private int \u0121;
    private int \u0126;
    private int \u0120;
    private Double \u011c;
    private Double \u0123;
    private Double \u011f;
    private Object[] \u011e;
    private Map \u0125;

    public ColumnMetadata(Table table, String string) {
        this(table, string, DefaultLiteralComparator.getInstance(), true);
    }

    public ColumnMetadata(Table table, String string, Comparator comparator, boolean bl) {
        this.\u011d = table;
        this.\u0119 = string;
        this.\u0122 = comparator;
        this.\u0124 = bl;
    }

    public void dispose() {
        this.\u011d.getColumn(this.\u0119).removeColumnListener(this);
    }

    private void \u0103() {
        this.\u011b = -1;
        this.\u0121 = -1;
        this.\u0126 = -1;
        this.\u0120 = -1;
        this.\u011c = null;
        this.\u0123 = null;
        this.\u011f = null;
        this.\u011e = null;
        this.\u0125 = null;
    }

    public void calculateValues() {
        this.\u0103();
        boolean bl = this.\u0124;
        this.\u0124 = true;
        this.getMinimumRow();
        this.getMaximumRow();
        this.getMedianRow();
        this.getUniqueCount();
        if (TypeLib.isNumericType(this.\u011d.getColumnType(this.\u0119))) {
            this.getMean();
            this.getDeviation();
            this.getSum();
        }
        this.getOrdinalArray();
        this.getOrdinalMap();
        this.\u011a = true;
        this.\u0124 = bl;
    }

    private void \u0104() {
        if (this.\u011a) {
            return;
        }
        if (this.\u0124) {
            this.\u0103();
            this.\u011d.getColumn(this.\u0119).addColumnListener(this);
        } else {
            this.calculateValues();
        }
        this.\u011a = true;
    }

    public Comparator getComparator() {
        return this.\u0122;
    }

    public void setComparator(Comparator comparator) {
        this.\u0122 = comparator;
        this.\u0103();
    }

    public Object getDefaultValue() {
        return this.\u0118;
    }

    public int getMinimumRow() {
        this.\u0104();
        if (this.\u011b == -1 && this.\u0124) {
            Index index = this.\u011d.getIndex(this.\u0119);
            this.\u011b = index != null ? index.minimum() : DataLib.min(this.\u011d.tuples(), this.\u0119, this.\u0122).getRow();
        }
        return this.\u011b;
    }

    public int getMaximumRow() {
        this.\u0104();
        if (this.\u0121 == -1 && this.\u0124) {
            Index index = this.\u011d.getIndex(this.\u0119);
            this.\u0121 = index != null ? index.maximum() : DataLib.max(this.\u011d.tuples(), this.\u0119, this.\u0122).getRow();
        }
        return this.\u0121;
    }

    public int getMedianRow() {
        this.\u0104();
        if (this.\u0126 == -1 && this.\u0124) {
            Index index = this.\u011d.getIndex(this.\u0119);
            if (index != null) {
                this.\u0121 = index.median();
            } else {
                this.\u0126 = DataLib.median(this.\u011d.tuples(), this.\u0119, this.\u0122).getRow();
            }
        }
        return this.\u0126;
    }

    public int getUniqueCount() {
        this.\u0104();
        if (this.\u0120 == -1 && this.\u0124) {
            Index index = this.\u011d.getIndex(this.\u0119);
            this.\u0120 = index != null ? index.uniqueCount() : DataLib.uniqueCount(this.\u011d.tuples(), this.\u0119);
        }
        return this.\u0120;
    }

    public double getMean() {
        this.\u0104();
        if (this.\u011c == null && this.\u0124) {
            this.\u011c = new Double(DataLib.mean(this.\u011d.tuples(), this.\u0119));
        }
        return this.\u011c;
    }

    public double getDeviation() {
        this.\u0104();
        if (this.\u0123 == null && this.\u0124) {
            this.\u0123 = new Double(DataLib.deviation(this.\u011d.tuples(), this.\u0119, this.getMean()));
        }
        return this.\u0123;
    }

    public double getSum() {
        this.\u0104();
        if (this.\u011f == null && this.\u0124) {
            this.\u011f = new Double(DataLib.sum(this.\u011d.tuples(), this.\u0119));
        }
        return this.\u011f;
    }

    public Object[] getOrdinalArray() {
        this.\u0104();
        if (this.\u011e == null && this.\u0124) {
            this.\u011e = DataLib.ordinalArray(this.\u011d.tuples(), this.\u0119, this.\u0122);
        }
        return this.\u011e;
    }

    public Map getOrdinalMap() {
        this.\u0104();
        if (this.\u0125 == null && this.\u0124) {
            this.\u0125 = DataLib.ordinalMap(this.\u011d.tuples(), this.\u0119, this.\u0122);
        }
        return this.\u0125;
    }

    @Override
    public void columnChanged(Column column, int n2, int n3, int n4) {
        this.\u0103();
    }

    @Override
    public void columnChanged(Column column, int n2, boolean bl) {
        this.columnChanged(column, 0, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, double d2) {
        this.columnChanged(column, 0, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, float f2) {
        this.columnChanged(column, 0, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, int n3) {
        this.columnChanged(column, 0, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, long l2) {
        this.columnChanged(column, 0, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, Object object) {
        this.columnChanged(column, 0, n2, n2);
    }
}

