/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.column.BooleanColumn;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.column.ConstantColumn;
import com.jidesoft.thirdparty.prefuse.data.column.DoubleColumn;
import com.jidesoft.thirdparty.prefuse.data.column.ExpressionColumn;
import com.jidesoft.thirdparty.prefuse.data.column.FloatColumn;
import com.jidesoft.thirdparty.prefuse.data.column.IntColumn;
import com.jidesoft.thirdparty.prefuse.data.column.LongColumn;
import com.jidesoft.thirdparty.prefuse.data.column.ObjectColumn;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;

public class ColumnFactory {
    public static final Column getColumn(Class clazz) {
        return ColumnFactory.getColumn(clazz, 0, 0, null);
    }

    public static final Column getColumn(Class clazz, int n2) {
        return ColumnFactory.getColumn(clazz, n2, n2, null);
    }

    public static final Column getColumn(Class clazz, int n2, Object object) {
        return ColumnFactory.getColumn(clazz, n2, n2, object);
    }

    public static final Column getColumn(Class clazz, int n2, int n3, Object object) {
        if (clazz == Integer.TYPE) {
            if (object == null) {
                return new IntColumn(n2);
            }
            int n4 = (Integer)object;
            return new IntColumn(n2, n2, n4);
        }
        if (clazz == Long.TYPE) {
            if (object == null) {
                return new LongColumn(n2);
            }
            long l2 = (Long)object;
            return new LongColumn(n2, n2, l2);
        }
        if (clazz == Float.TYPE) {
            if (object == null) {
                return new FloatColumn(n2);
            }
            float f2 = ((Float)object).floatValue();
            return new FloatColumn(n2, n2, f2);
        }
        if (clazz == Double.TYPE) {
            if (object == null) {
                return new DoubleColumn(n2);
            }
            double d2 = (Double)object;
            return new DoubleColumn(n2, n2, d2);
        }
        if (clazz == Boolean.TYPE) {
            if (object == null) {
                return new BooleanColumn(n2);
            }
            boolean bl = (Boolean)object;
            return new BooleanColumn(n2, n2, bl);
        }
        if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Void.TYPE) {
            throw new DataTypeException(clazz);
        }
        return new ObjectColumn(clazz, n2, n2, object);
    }

    public static final Column getColumn(Table table, Expression expression) {
        return new ExpressionColumn(table, expression);
    }

    public static final Column getConstantColumn(Class clazz, Object object) {
        return new ConstantColumn(clazz, object);
    }
}

