/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data;

import com.jidesoft.thirdparty.prefuse.data.Table;
import java.util.HashMap;

public class Schema
implements Cloneable {
    private String[] \u0101;
    private Class[] \u0106;
    private Object[] \u0104;
    private HashMap \u0103;
    private int \u0102;
    private boolean \u0105;

    public Schema() {
        this(10);
    }

    public Schema(int n2) {
        this.\u0101 = new String[n2];
        this.\u0106 = new Class[n2];
        this.\u0104 = new Object[n2];
        this.\u0102 = 0;
        this.\u0105 = false;
    }

    public Schema(String[] stringArray, Class[] classArray) {
        this(stringArray.length);
        if (stringArray.length != classArray.length) {
            throw new IllegalArgumentException("Input arrays should be the same length");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.addColumn(stringArray[i2], classArray[i2], null);
        }
    }

    public Schema(String[] stringArray, Class[] classArray, Object[] objectArray) {
        this(stringArray.length);
        if (stringArray.length != classArray.length || classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Input arrays should be the same length");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.addColumn(stringArray[i2], classArray[i2], objectArray[i2]);
        }
    }

    public Object clone() {
        return new Schema(this.\u0101, this.\u0106, this.\u0104);
    }

    protected void initLookup() {
        this.\u0103 = new HashMap();
        for (int i2 = 0; i2 < this.\u0101.length; ++i2) {
            this.\u0103.put(this.\u0101[i2], new Integer(i2));
        }
    }

    public Schema lockSchema() {
        this.\u0105 = true;
        return this;
    }

    public boolean isLocked() {
        return this.\u0105;
    }

    public void addColumn(String string, Class clazz) {
        this.addColumn(string, clazz, null);
    }

    public void addColumn(String string, Class clazz, Object object) {
        int n2;
        if (this.\u0105) {
            throw new IllegalStateException("Can not add column to a locked Schema.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null column names are not allowed.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Null column types are not allowed.");
        }
        for (n2 = 0; n2 < this.\u0102; ++n2) {
            if (!this.\u0101[n2].equals(string)) continue;
            throw new IllegalArgumentException("Duplicate column names are not allowed: " + this.\u0101[n2]);
        }
        if (this.\u0101.length == this.\u0102) {
            n2 = 3 * this.\u0101.length / 2 + 1;
            String[] stringArray = new String[n2];
            Class[] classArray = new Class[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.\u0101, 0, stringArray, 0, this.\u0102);
            System.arraycopy(this.\u0106, 0, classArray, 0, this.\u0102);
            System.arraycopy(this.\u0104, 0, objectArray, 0, this.\u0102);
            this.\u0101 = stringArray;
            this.\u0106 = classArray;
            this.\u0104 = objectArray;
        }
        this.\u0101[this.\u0102] = string;
        this.\u0106[this.\u0102] = clazz;
        this.\u0104[this.\u0102] = object;
        if (this.\u0103 != null) {
            this.\u0103.put(string, new Integer(this.\u0102));
        }
        ++this.\u0102;
    }

    public int getColumnCount() {
        return this.\u0102;
    }

    public String getColumnName(int n2) {
        return this.\u0101[n2];
    }

    public int getColumnIndex(String string) {
        Integer n2;
        if (this.\u0103 == null) {
            this.initLookup();
        }
        return (n2 = (Integer)this.\u0103.get(string)) == null ? -1 : n2;
    }

    public Class getColumnType(int n2) {
        return this.\u0106[n2];
    }

    public Class getColumnType(String string) {
        int n2 = this.getColumnIndex(string);
        return n2 < 0 ? null : this.\u0106[n2];
    }

    public Object getDefault(int n2) {
        return this.\u0104[n2];
    }

    public Object getDefault(String string) {
        int n2 = this.getColumnIndex(string);
        return n2 < 0 ? null : this.\u0104[n2];
    }

    public void setDefault(int n2, Object object) {
        if (this.\u0105) {
            throw new IllegalStateException("Can not update default values of a locked Schema.");
        }
        this.\u0104[n2] = object;
    }

    public void setDefault(String string, Object object) {
        if (this.\u0105) {
            throw new IllegalStateException("Can not update default values of a locked Schema.");
        }
        int n2 = this.getColumnIndex(string);
        this.\u0104[n2] = object;
    }

    public void setDefault(String string, int n2) {
        this.setDefault(string, (Object)new Integer(n2));
    }

    public void setDefault(String string, long l2) {
        this.setDefault(string, (Object)new Long(l2));
    }

    public void setDefault(String string, float f2) {
        this.setDefault(string, (Object)new Float(f2));
    }

    public void setDefault(String string, double d2) {
        this.setDefault(string, (Object)new Double(d2));
    }

    public void setDefault(String string, boolean bl) {
        this.setDefault(string, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)object;
        if (this.\u0102 != schema.getColumnCount()) {
            return false;
        }
        for (int i2 = 0; i2 < this.\u0102; ++i2) {
            if (this.\u0101[i2].equals(schema.getColumnName(i2)) && this.\u0106[i2].equals(schema.getColumnType(i2)) && this.\u0104[i2].equals(schema.getDefault(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean isAssignableFrom(Schema schema) {
        int n2 = schema.getColumnCount();
        if (n2 > this.\u0102) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getColumnIndex(schema.getColumnName(i2));
            if (n3 < 0) {
                return false;
            }
            if (this.\u0106[n3].equals(schema.getColumnType(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.\u0102; ++i2) {
            int n3 = i2 + 1;
            int n4 = n3 * this.\u0101[i2].hashCode();
            n4 ^= n3 * this.\u0106[i2].hashCode();
            if (this.\u0104[i2] != null) {
                n4 ^= this.\u0104[i2].hashCode();
            }
            n2 ^= n4;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Schema[");
        for (int i2 = 0; i2 < this.\u0102; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('(').append(this.\u0101[i2]).append(", ");
            stringBuffer.append(this.\u0106[i2].getName()).append(", ");
            stringBuffer.append(this.\u0104[i2]).append(')');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Table instantiate() {
        return this.instantiate(0);
    }

    public Table instantiate(int n2) {
        Table table = new Table(n2, this.\u0102);
        for (int i2 = 0; i2 < this.\u0102; ++i2) {
            table.addColumn(this.\u0101[i2], this.\u0106[i2], this.\u0104[i2]);
        }
        return table;
    }
}

