/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ResizableMouseInputAdapter
extends MouseInputAdapter {
    private static Rectangle \u0106;
    private int \u0103;
    private int \u0102;
    private int \u0105;
    protected static final int RESIZE_NONE = 0;
    private boolean \u0101 = false;
    private Resizable \u0104;

    public ResizableMouseInputAdapter(Resizable resizable) {
        this.\u0104 = resizable;
    }

    private boolean \u0101(int n2) {
        return this.\u0104 != null && (this.\u0104.getResizableCorners() & n2) != 0;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Serializable serializable;
        Point point;
        this.\u0105 = 0;
        \u0106 = this.\u0104.getComponent().getBounds();
        if (this.\u0104.isTopLevel()) {
            point = new Point(ResizableMouseInputAdapter.\u0106.x, ResizableMouseInputAdapter.\u0106.y);
            SwingUtilities.convertPointToScreen(point, this.\u0104.getComponent());
            ResizableMouseInputAdapter.\u0106.x = point.x;
            ResizableMouseInputAdapter.\u0106.y = point.y;
        }
        point = new Point(mouseEvent.getX(), mouseEvent.getY());
        SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
        this.\u0103 = point.x;
        this.\u0102 = point.y;
        if (mouseEvent.getSource() instanceof Resizable.ResizeCorner) {
            serializable = (Resizable.ResizeCorner)mouseEvent.getSource();
            this.\u0105 = serializable.getCorner();
        } else if (mouseEvent.getSource() == this.\u0104.getComponent()) {
            serializable = this.\u0104.getResizeInsets();
            if (mouseEvent.getX() <= ((Insets)serializable).left) {
                this.\u0105 = ((Insets)serializable).top > 0 && mouseEvent.getY() < this.\u0104.getResizeCornerSize() + ((Insets)serializable).top ? 1 : (((Insets)serializable).bottom > 0 && mouseEvent.getY() > this.\u0104.getComponent().getHeight() - this.\u0104.getResizeCornerSize() - ((Insets)serializable).bottom ? 64 : 128);
            } else if (((Insets)serializable).right > 0 && mouseEvent.getX() >= this.\u0104.getComponent().getWidth() - ((Insets)serializable).right) {
                this.\u0105 = ((Insets)serializable).top > 0 && mouseEvent.getY() < this.\u0104.getResizeCornerSize() + ((Insets)serializable).top ? 4 : (((Insets)serializable).bottom > 0 && mouseEvent.getY() > this.\u0104.getComponent().getHeight() - this.\u0104.getResizeCornerSize() - ((Insets)serializable).bottom ? 16 : 8);
            } else if (((Insets)serializable).top > 0 && mouseEvent.getY() <= ((Insets)serializable).top) {
                this.\u0105 = ((Insets)serializable).left > 0 && mouseEvent.getX() < this.\u0104.getResizeCornerSize() + ((Insets)serializable).left ? 1 : (((Insets)serializable).right > 0 && mouseEvent.getX() > this.\u0104.getComponent().getWidth() - this.\u0104.getResizeCornerSize() - ((Insets)serializable).right ? 4 : 2);
            } else if (((Insets)serializable).bottom > 0 && mouseEvent.getY() >= this.\u0104.getComponent().getHeight() - ((Insets)serializable).bottom) {
                this.\u0105 = ((Insets)serializable).left > 0 && mouseEvent.getX() < this.\u0104.getResizeCornerSize() + ((Insets)serializable).left ? 64 : (((Insets)serializable).right > 0 && mouseEvent.getX() > this.\u0104.getComponent().getWidth() - this.\u0104.getResizeCornerSize() - ((Insets)serializable).right ? 16 : 32);
            } else {
                this.\u0101 = true;
                return;
            }
        }
        serializable = Cursor.getDefaultCursor();
        if (this.\u0101(this.\u0105)) {
            boolean bl = this.\u0104.getComponent().getComponentOrientation().isLeftToRight();
            switch (this.\u0105) {
                case 32: {
                    serializable = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 2: {
                    serializable = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 128: {
                    serializable = Cursor.getPredefinedCursor(bl ? 10 : 11);
                    break;
                }
                case 8: {
                    serializable = Cursor.getPredefinedCursor(bl ? 11 : 10);
                    break;
                }
                case 16: {
                    serializable = Cursor.getPredefinedCursor(bl ? 5 : 4);
                    break;
                }
                case 64: {
                    serializable = Cursor.getPredefinedCursor(bl ? 4 : 5);
                    break;
                }
                case 1: {
                    serializable = Cursor.getPredefinedCursor(bl ? 6 : 7);
                    break;
                }
                case 4: {
                    serializable = Cursor.getPredefinedCursor(bl ? 7 : 6);
                }
            }
            Container container = this.\u0104.getComponent().getTopLevelAncestor();
            if (container instanceof JFrame) {
                ((JFrame)container).getGlassPane().setVisible(true);
                ((JFrame)container).getGlassPane().setCursor((Cursor)serializable);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setVisible(true);
                ((JApplet)container).getGlassPane().setCursor((Cursor)serializable);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setVisible(true);
                ((JWindow)container).getGlassPane().setCursor((Cursor)serializable);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setVisible(true);
                ((JDialog)container).getGlassPane().setCursor((Cursor)serializable);
            }
            this.\u0104.beginResizing(this.\u0105);
        } else {
            this.\u0105 = 0;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n2;
        int n3;
        if (\u0106 == null) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Component component = (Component)mouseEvent.getSource();
        SwingUtilities.convertPointToScreen(point, component);
        int n4 = this.\u0103 - point.x;
        int n5 = this.\u0102 - point.y;
        Dimension dimension = this.\u0104.getComponent().getMinimumSize();
        Dimension dimension2 = this.\u0104.getComponent().getMaximumSize();
        Point point2 = new Point(this.\u0104.getComponent().getX(), this.\u0104.getComponent().getY());
        if (this.\u0104.isTopLevel()) {
            SwingUtilities.convertPointToScreen(point2, this.\u0104.getComponent());
        }
        int n6 = point2.x;
        int n7 = point2.y;
        Rectangle rectangle = this.\u0104.isTopLevel() ? new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE) : this.\u0104.getComponent().getParent().getBounds();
        int n8 = this.\u0105;
        boolean bl = this.\u0104.getComponent().getComponentOrientation().isLeftToRight();
        if (!bl) {
            switch (this.\u0105) {
                case 1: {
                    n8 = 4;
                }
                case 4: {
                    n8 = 1;
                }
                case 64: {
                    n8 = 16;
                }
                case 16: {
                    n8 = 64;
                }
                case 128: {
                    n8 = 8;
                }
                case 8: {
                    n8 = 128;
                }
            }
        }
        int n9 = this.\u0104.getSnapGridSize();
        switch (n8) {
            case 0: {
                return;
            }
            case 2: {
                if (ResizableMouseInputAdapter.\u0106.height + n5 < dimension.height) {
                    n5 = -(ResizableMouseInputAdapter.\u0106.height - dimension.height);
                } else if (ResizableMouseInputAdapter.\u0106.height + n5 > dimension2.height) {
                    n5 = dimension2.height - ResizableMouseInputAdapter.\u0106.height;
                }
                n6 = ResizableMouseInputAdapter.\u0106.x;
                n7 = ResizableMouseInputAdapter.\u0106.y - n5;
                if (n9 > 0 && n7 % n9 != 0) {
                    n7 = n7 > 0 ? (n7 % n9 > n9 / 2 ? (n7 += n9 - n7 % n9) : (n7 -= n7 % n9)) : (-n7 % n9 > n9 / 2 ? (n7 -= n9 - -n7 % n9) : (n7 += -n7 % n9));
                }
                n5 = ResizableMouseInputAdapter.\u0106.y - n7;
                n3 = ResizableMouseInputAdapter.\u0106.width;
                n2 = ResizableMouseInputAdapter.\u0106.height + n5;
                break;
            }
            case 4: {
                if (ResizableMouseInputAdapter.\u0106.height + n5 < dimension.height) {
                    n5 = -(ResizableMouseInputAdapter.\u0106.height - dimension.height);
                } else if (ResizableMouseInputAdapter.\u0106.height + n5 > dimension2.height) {
                    n5 = dimension2.height - ResizableMouseInputAdapter.\u0106.height;
                }
                if (ResizableMouseInputAdapter.\u0106.width - n4 < dimension.width) {
                    n4 = ResizableMouseInputAdapter.\u0106.width - dimension.width;
                } else if (ResizableMouseInputAdapter.\u0106.width - n4 > dimension2.width) {
                    n4 = -(dimension2.width - ResizableMouseInputAdapter.\u0106.width);
                }
                if (ResizableMouseInputAdapter.\u0106.x + ResizableMouseInputAdapter.\u0106.width - n4 > rectangle.width) {
                    n4 = ResizableMouseInputAdapter.\u0106.x + ResizableMouseInputAdapter.\u0106.width - rectangle.width;
                }
                n6 = ResizableMouseInputAdapter.\u0106.x;
                n7 = ResizableMouseInputAdapter.\u0106.y - n5;
                if (n9 > 0 && n7 % n9 != 0) {
                    n7 = n7 > 0 ? (n7 % n9 > n9 / 2 ? (n7 += n9 - n7 % n9) : (n7 -= n7 % n9)) : (-n7 % n9 > n9 / 2 ? (n7 -= n9 - -n7 % n9) : (n7 += -n7 % n9));
                }
                n5 = ResizableMouseInputAdapter.\u0106.y - n7;
                n3 = ResizableMouseInputAdapter.\u0106.width - n4;
                if (n9 > 0 && n3 % n9 != 0) {
                    n3 = n3 > 0 ? (n3 % n9 > n9 / 2 ? (n3 += n9 - n3 % n9) : (n3 -= n3 % n9)) : (-n3 % n9 > n9 / 2 ? (n3 -= n9 - -n3 % n9) : (n3 += -n3 % n9));
                }
                n2 = ResizableMouseInputAdapter.\u0106.height + n5;
                break;
            }
            case 8: {
                if (ResizableMouseInputAdapter.\u0106.width - n4 < dimension.width) {
                    n4 = ResizableMouseInputAdapter.\u0106.width - dimension.width;
                } else if (ResizableMouseInputAdapter.\u0106.width - n4 > dimension2.width) {
                    n4 = -(dimension2.width - ResizableMouseInputAdapter.\u0106.width);
                }
                if (ResizableMouseInputAdapter.\u0106.x + ResizableMouseInputAdapter.\u0106.width - n4 > rectangle.width) {
                    n4 = ResizableMouseInputAdapter.\u0106.x + ResizableMouseInputAdapter.\u0106.width - rectangle.width;
                }
                n3 = ResizableMouseInputAdapter.\u0106.width - n4;
                if (n9 > 0 && n3 % n9 != 0) {
                    n3 = n3 > 0 ? (n3 % n9 > n9 / 2 ? (n3 += n9 - n3 % n9) : (n3 -= n3 % n9)) : (-n3 % n9 > n9 / 2 ? (n3 -= n9 - -n3 % n9) : (n3 += -n3 % n9));
                }
                n2 = ResizableMouseInputAdapter.\u0106.height;
                break;
            }
            case 16: {
                if (ResizableMouseInputAdapter.\u0106.width - n4 < dimension.width) {
                    n4 = ResizableMouseInputAdapter.\u0106.width - dimension.width;
                } else if (ResizableMouseInputAdapter.\u0106.width - n4 > dimension2.width) {
                    n4 = -(dimension2.width - ResizableMouseInputAdapter.\u0106.width);
                }
                if (ResizableMouseInputAdapter.\u0106.x + ResizableMouseInputAdapter.\u0106.width - n4 > rectangle.width) {
                    n4 = ResizableMouseInputAdapter.\u0106.x + ResizableMouseInputAdapter.\u0106.width - rectangle.width;
                }
                if (ResizableMouseInputAdapter.\u0106.height - n5 < dimension.height) {
                    n5 = ResizableMouseInputAdapter.\u0106.height - dimension.height;
                } else if (ResizableMouseInputAdapter.\u0106.height - n5 > dimension2.height) {
                    n5 = -(dimension2.height - ResizableMouseInputAdapter.\u0106.height);
                }
                if (ResizableMouseInputAdapter.\u0106.y + ResizableMouseInputAdapter.\u0106.height - n5 > rectangle.height) {
                    n5 = ResizableMouseInputAdapter.\u0106.y + ResizableMouseInputAdapter.\u0106.height - rectangle.height;
                }
                n3 = ResizableMouseInputAdapter.\u0106.width - n4;
                n2 = ResizableMouseInputAdapter.\u0106.height - n5;
                if (n9 > 0 && n2 % n9 != 0) {
                    n2 = n2 > 0 ? (n2 % n9 > n9 / 2 ? (n2 += n9 - n2 % n9) : (n2 -= n2 % n9)) : (-n2 % n9 > n9 / 2 ? (n2 -= n9 - -n2 % n9) : (n2 += -n2 % n9));
                }
                if (n9 <= 0 || n3 % n9 == 0) break;
                if (n3 > 0) {
                    if (n3 % n9 > n9 / 2) {
                        n3 += n9 - n3 % n9;
                        break;
                    }
                    n3 -= n3 % n9;
                    break;
                }
                if (-n3 % n9 > n9 / 2) {
                    n3 -= n9 - -n3 % n9;
                    break;
                }
                n3 += -n3 % n9;
                break;
            }
            case 32: {
                if (ResizableMouseInputAdapter.\u0106.height - n5 < dimension.height) {
                    n5 = ResizableMouseInputAdapter.\u0106.height - dimension.height;
                } else if (ResizableMouseInputAdapter.\u0106.height - n5 > dimension2.height) {
                    n5 = -(dimension2.height - ResizableMouseInputAdapter.\u0106.height);
                }
                if (ResizableMouseInputAdapter.\u0106.y + ResizableMouseInputAdapter.\u0106.height - n5 > rectangle.height) {
                    n5 = ResizableMouseInputAdapter.\u0106.y + ResizableMouseInputAdapter.\u0106.height - rectangle.height;
                }
                n3 = ResizableMouseInputAdapter.\u0106.width;
                n2 = ResizableMouseInputAdapter.\u0106.height - n5;
                if (n9 <= 0 || n2 % n9 == 0) break;
                if (n2 > 0) {
                    if (n2 % n9 > n9 / 2) {
                        n2 += n9 - n2 % n9;
                        break;
                    }
                    n2 -= n2 % n9;
                    break;
                }
                if (-n2 % n9 > n9 / 2) {
                    n2 -= n9 - -n2 % n9;
                    break;
                }
                n2 += -n2 % n9;
                break;
            }
            case 64: {
                if (ResizableMouseInputAdapter.\u0106.height - n5 < dimension.height) {
                    n5 = ResizableMouseInputAdapter.\u0106.height - dimension.height;
                } else if (ResizableMouseInputAdapter.\u0106.height - n5 > dimension2.height) {
                    n5 = -(dimension2.height - ResizableMouseInputAdapter.\u0106.height);
                }
                if (ResizableMouseInputAdapter.\u0106.y + ResizableMouseInputAdapter.\u0106.height - n5 > rectangle.height) {
                    n5 = ResizableMouseInputAdapter.\u0106.y + ResizableMouseInputAdapter.\u0106.height - rectangle.height;
                }
                if (ResizableMouseInputAdapter.\u0106.width + n4 < dimension.width) {
                    n4 = -(ResizableMouseInputAdapter.\u0106.width - dimension.width);
                } else if (ResizableMouseInputAdapter.\u0106.width + n4 > dimension2.width) {
                    n4 = dimension2.width - ResizableMouseInputAdapter.\u0106.width;
                }
                n6 = ResizableMouseInputAdapter.\u0106.x - n4;
                if (n9 > 0 && n6 % n9 != 0) {
                    n6 = n6 > 0 ? (n6 % n9 > n9 / 2 ? (n6 += n9 - n6 % n9) : (n6 -= n6 % n9)) : (-n6 % n9 > n9 / 2 ? (n6 -= n9 - -n6 % n9) : (n6 += -n6 % n9));
                }
                n4 = ResizableMouseInputAdapter.\u0106.x - n6;
                n7 = ResizableMouseInputAdapter.\u0106.y;
                n3 = ResizableMouseInputAdapter.\u0106.width + n4;
                n2 = ResizableMouseInputAdapter.\u0106.height - n5;
                if (n9 <= 0 || n2 % n9 == 0) break;
                if (n2 > 0) {
                    if (n2 % n9 > n9 / 2) {
                        n2 += n9 - n2 % n9;
                        break;
                    }
                    n2 -= n2 % n9;
                    break;
                }
                if (-n2 % n9 > n9 / 2) {
                    n2 -= n9 - -n2 % n9;
                    break;
                }
                n2 += -n2 % n9;
                break;
            }
            case 128: {
                if (ResizableMouseInputAdapter.\u0106.width + n4 < dimension.width) {
                    n4 = -(ResizableMouseInputAdapter.\u0106.width - dimension.width);
                } else if (ResizableMouseInputAdapter.\u0106.width + n4 > dimension2.width) {
                    n4 = dimension2.width - ResizableMouseInputAdapter.\u0106.width;
                }
                n6 = ResizableMouseInputAdapter.\u0106.x - n4;
                if (n9 > 0 && n6 % n9 != 0) {
                    n6 = n6 > 0 ? (n6 % n9 > n9 / 2 ? (n6 += n9 - n6 % n9) : (n6 -= n6 % n9)) : (-n6 % n9 > n9 / 2 ? (n6 -= n9 - -n6 % n9) : (n6 += -n6 % n9));
                }
                n4 = ResizableMouseInputAdapter.\u0106.x - n6;
                n7 = ResizableMouseInputAdapter.\u0106.y;
                n3 = ResizableMouseInputAdapter.\u0106.width + n4;
                n2 = ResizableMouseInputAdapter.\u0106.height;
                break;
            }
            case 1: {
                if (ResizableMouseInputAdapter.\u0106.width + n4 < dimension.width) {
                    n4 = -(ResizableMouseInputAdapter.\u0106.width - dimension.width);
                } else if (ResizableMouseInputAdapter.\u0106.width + n4 > dimension2.width) {
                    n4 = dimension2.width - ResizableMouseInputAdapter.\u0106.width;
                }
                if (ResizableMouseInputAdapter.\u0106.height + n5 < dimension.height) {
                    n5 = -(ResizableMouseInputAdapter.\u0106.height - dimension.height);
                } else if (ResizableMouseInputAdapter.\u0106.height + n5 > dimension2.height) {
                    n5 = dimension2.height - ResizableMouseInputAdapter.\u0106.height;
                }
                n6 = ResizableMouseInputAdapter.\u0106.x - n4;
                if (n9 > 0 && n6 % n9 != 0) {
                    n6 = n6 > 0 ? (n6 % n9 > n9 / 2 ? (n6 += n9 - n6 % n9) : (n6 -= n6 % n9)) : (-n6 % n9 > n9 / 2 ? (n6 -= n9 - -n6 % n9) : (n6 += -n6 % n9));
                }
                n4 = ResizableMouseInputAdapter.\u0106.x - n6;
                n7 = ResizableMouseInputAdapter.\u0106.y - n5;
                if (n9 > 0 && n7 % n9 != 0) {
                    n7 = n7 > 0 ? (n7 % n9 > n9 / 2 ? (n7 += n9 - n7 % n9) : (n7 -= n7 % n9)) : (-n7 % n9 > n9 / 2 ? (n7 -= n9 - -n7 % n9) : (n7 += -n7 % n9));
                }
                n5 = ResizableMouseInputAdapter.\u0106.y - n7;
                n3 = ResizableMouseInputAdapter.\u0106.width + n4;
                n2 = ResizableMouseInputAdapter.\u0106.height + n5;
                break;
            }
            default: {
                return;
            }
        }
        Rectangle rectangle2 = PortingUtils.getScreenBounds(this.\u0104.getComponent());
        n6 = Math.max(n6, rectangle2.x);
        n7 = Math.max(n7, rectangle2.y);
        if (n6 + n3 > rectangle2.width) {
            n3 = rectangle2.width - n6;
        }
        if (n7 + n2 > rectangle2.height) {
            n2 = rectangle2.height - n7;
        }
        this.\u0104.resizing(this.\u0105, n6, n7, n3, n2);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        \u0106 = null;
        if (this.\u0101) {
            this.\u0101 = false;
            return;
        }
        if (this.\u0105 != 0) {
            Container container = this.\u0104.getComponent().getTopLevelAncestor();
            if (container instanceof JFrame) {
                ((JFrame)this.\u0104.getComponent().getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JFrame)this.\u0104.getComponent().getTopLevelAncestor()).getGlassPane().setVisible(false);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JApplet)container).getGlassPane().setVisible(false);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JWindow)container).getGlassPane().setVisible(false);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JDialog)container).getGlassPane().setVisible(false);
            }
            this.\u0104.endResizing(this.\u0105);
            this.\u0103 = 0;
            this.\u0102 = 0;
            \u0106 = null;
            this.\u0105 = 0;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof Resizable.ResizeCorner) {
            Resizable.ResizeCorner resizeCorner = (Resizable.ResizeCorner)mouseEvent.getSource();
            boolean bl = resizeCorner.getComponentOrientation().isLeftToRight();
            switch (resizeCorner.getCorner()) {
                case 16: {
                    resizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                    return;
                }
                case 4: {
                    resizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                    return;
                }
                case 64: {
                    resizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                    return;
                }
                case 1: {
                    resizeCorner.setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                    return;
                }
            }
        } else if (mouseEvent.getSource() == this.\u0104.getComponent()) {
            Insets insets = this.\u0104.getResizeInsets();
            boolean bl = this.\u0104.getComponent().getComponentOrientation().isLeftToRight();
            if (mouseEvent.getX() <= insets.left) {
                if (this.\u0101(1) && insets.top > 0 && mouseEvent.getY() < this.\u0104.getResizeCornerSize() + insets.top) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                } else if (this.\u0101(64) && insets.bottom > 0 && mouseEvent.getY() > this.\u0104.getComponent().getHeight() - this.\u0104.getResizeCornerSize() - insets.bottom) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                } else if (this.\u0101(128)) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 10 : 11));
                } else {
                    this.\u0104.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (mouseEvent.getX() >= this.\u0104.getComponent().getWidth() - insets.right) {
                if (this.\u0101(4) && insets.top > 0 && mouseEvent.getY() < this.\u0104.getResizeCornerSize() + insets.top) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                } else if (this.\u0101(64) && insets.bottom > 0 && mouseEvent.getY() > this.\u0104.getComponent().getHeight() - this.\u0104.getResizeCornerSize() - insets.bottom) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                } else if (this.\u0101(8)) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 11 : 10));
                } else {
                    this.\u0104.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (mouseEvent.getY() <= insets.top) {
                if (this.\u0101(1) && insets.left > 0 && mouseEvent.getX() < this.\u0104.getResizeCornerSize() + insets.left) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 6 : 7));
                } else if (this.\u0101(4) && insets.right > 0 && mouseEvent.getX() > this.\u0104.getComponent().getWidth() - this.\u0104.getResizeCornerSize() - insets.right) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 7 : 6));
                } else if (this.\u0101(2)) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(8));
                } else {
                    this.\u0104.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (mouseEvent.getY() >= this.\u0104.getComponent().getHeight() - insets.bottom) {
                if (this.\u0101(64) && insets.left > 0 && mouseEvent.getX() < this.\u0104.getResizeCornerSize() + insets.left) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 4 : 5));
                } else if (this.\u0101(16) && insets.right > 0 && mouseEvent.getX() > this.\u0104.getComponent().getWidth() - this.\u0104.getResizeCornerSize() - insets.right) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(bl ? 5 : 4));
                } else if (this.\u0101(32)) {
                    this.\u0104.getComponent().setCursor(Cursor.getPredefinedCursor(9));
                } else {
                    this.\u0104.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else {
                this.\u0104.getComponent().setCursor(Cursor.getDefaultCursor());
            }
            return;
        }
        this.\u0104.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof Resizable.ResizeCorner) {
            Resizable.ResizeCorner resizeCorner = (Resizable.ResizeCorner)mouseEvent.getSource();
            resizeCorner.setCursor(Cursor.getDefaultCursor());
        } else {
            this.\u0104.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

