/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MeterProgressBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class MeterProgressBarUI
extends BasicProgressBarUI {
    protected Color _cellBackground;
    protected Color _cellForeground;
    protected int _cellLength;
    protected int _cellSpacing;
    private PropertyChangeListener \u0101;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MeterProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.progressBar, "MeterProgressBar.border");
        LookAndFeel.installColors(this.progressBar, "MeterProgressBar.background", "MeterProgressBar.foreground");
        this._cellForeground = UIDefaultsLookup.getColor("MeterProgressBar.cellForeground");
        this._cellBackground = UIDefaultsLookup.getColor("MeterProgressBar.cellBackground");
        this._cellLength = UIDefaultsLookup.getInt("MeterProgressBar.cellLength");
        this._cellSpacing = UIDefaultsLookup.getInt("MeterProgressBar.cellSpacing");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this._cellBackground = null;
        this._cellForeground = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.\u0101 = new A();
        this.progressBar.addPropertyChangeListener(this.\u0101);
    }

    @Override
    protected void uninstallListeners() {
        this.progressBar.removePropertyChangeListener(this.\u0101);
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n4 = this.getAmountFull(insets, n2, n3);
        int n5 = this.progressBar.getOrientation();
        float f2 = n5 == 0 ? (float)n3 : (float)n2;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this._cellBackground);
        graphics2D.setStroke(new BasicStroke(f2, 0, 2));
        if (n5 == 0) {
            graphics2D.drawLine(insets.left, n3 / 2 + insets.top, insets.left + n2, n3 / 2 + insets.top);
        } else {
            graphics2D.drawLine(n2 / 2 + insets.left, insets.top + n3, n2 / 2 + insets.left, insets.top);
        }
        if (((MeterProgressBar)jComponent).getStyle() == 0) {
            graphics2D.setColor(this._cellForeground);
            if (n5 == 0) {
                if (jComponent.getComponentOrientation().isLeftToRight()) {
                    graphics2D.drawLine(insets.left, n3 / 2 + insets.top, n4 + insets.left, n3 / 2 + insets.top);
                } else {
                    graphics2D.drawLine(n2 + insets.left, n3 / 2 + insets.top, n2 + insets.left - n4, n3 / 2 + insets.top);
                }
            } else {
                graphics2D.drawLine(n2 / 2 + insets.left, insets.top + n3, n2 / 2 + insets.left, insets.top + n3 - n4);
            }
        } else {
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            if (n5 == 0) {
                Rectangle rectangle = new Rectangle(insets.left, insets.top, n4, n3 / 2);
                if (!jComponent.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += n2 - n4;
                }
                JideSwingUtilities.fillGradient(graphics2D, rectangle, this._cellForeground, this._cellBackground, true);
                rectangle.y += n3 / 2;
                JideSwingUtilities.fillGradient(graphics2D, rectangle, this._cellBackground, this._cellForeground, true);
            } else {
                Rectangle rectangle = new Rectangle(insets.left, insets.top + n3 - n4, n2 / 2, n4);
                JideSwingUtilities.fillGradient(graphics2D, rectangle, this._cellForeground, this._cellBackground, false);
                rectangle.x += n2 / 2;
                JideSwingUtilities.fillGradient(graphics2D, rectangle, this._cellBackground, this._cellForeground, false);
            }
        }
        graphics2D.setColor(this.progressBar.getBackground());
        graphics2D.setStroke(new BasicStroke(f2, 0, 2, 0.0f, new float[]{this._cellLength, this._cellSpacing}, 0.0f));
        if (n5 == 0) {
            graphics2D.drawLine(insets.left - this._cellSpacing, n3 / 2 + insets.top, insets.left + n2, n3 / 2 + insets.top);
        } else {
            graphics2D.drawLine(n2 / 2 + insets.left, insets.top + n3 + this._cellSpacing, n2 / 2 + insets.left, insets.top);
        }
        graphics2D.dispose();
    }

    private class A
    implements PropertyChangeListener {
        private A() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("style".equals(propertyChangeEvent.getPropertyName())) {
                MeterProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

