/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortListener;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import com.jidesoft.utils.SystemInfo;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class BasicSortableTableHeaderUIDelegate
extends BasicCellStyleTableHeaderUIDelegate
implements SortListener {
    public BasicSortableTableHeaderUIDelegate(JTableHeader jTableHeader, CellRendererPane cellRendererPane) {
        super(jTableHeader, cellRendererPane);
        this.\u016f();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("table".equals(propertyChangeEvent.getPropertyName()) || "model".equals(propertyChangeEvent.getPropertyName())) {
            TableModel tableModel = null;
            if (propertyChangeEvent.getOldValue() instanceof JTable) {
                tableModel = ((JTable)propertyChangeEvent.getOldValue()).getModel();
            } else if (propertyChangeEvent.getOldValue() instanceof TableModel) {
                tableModel = (TableModel)propertyChangeEvent.getOldValue();
            }
            this.\u0101(tableModel);
        }
        super.propertyChange(propertyChangeEvent);
        if ("table".equals(propertyChangeEvent.getPropertyName()) || "model".equals(propertyChangeEvent.getPropertyName())) {
            this.\u016f();
        }
    }

    @Override
    public void uninstallAllListeners() {
        super.uninstallAllListeners();
        if (this._header != null && this._header.getTable() != null) {
            this.\u0101(this._header.getTable().getModel());
        }
    }

    private void \u0101(TableModel tableModel) {
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, ISortableTableModel.class);
        if (tableModel2 instanceof ISortableTableModel) {
            ((ISortableTableModel)tableModel2).removeSortListener(this);
        }
    }

    private void \u016f() {
        TableModel tableModel;
        if (this._header.getTable() != null && (tableModel = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), ISortableTableModel.class)) instanceof ISortableTableModel) {
            ((ISortableTableModel)tableModel).addSortListener(this);
        }
    }

    @Override
    public void sortChanging(SortEvent sortEvent) {
    }

    @Override
    public void sortChanged(SortEvent sortEvent) {
        this.\u0101(true, false);
        if (this._header != null && this._header.getParent() != null) {
            this._header.getParent().invalidate();
            this._header.getParent().repaint();
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.\u016e();
        super.paint(graphics, jComponent);
    }

    private void \u016e() {
        JTable jTable = null;
        if (this._header.getTable() instanceof SortableTable) {
            jTable = (SortableTable)this._header.getTable();
        }
        if (jTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = SortableTableModel.getSortableModel(jTable.getModel());
        if (iSortableTableModel == null) {
            jTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            jTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        int[] nArray = new int[list.size()];
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ISortableTableModel.SortItem sortItem = list.get(i2);
            nArray[i2] = jTable.convertColumnIndexToView(sortItem.getColumn());
        }
        jTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", nArray);
        jTable.putClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND", true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._header.getTable() instanceof SortableTable && ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener() != null) {
            ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener().mouseClicked(mouseEvent);
        }
        super.mouseClicked(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SystemInfo.isJdk6Above() && this._header.getTable() instanceof SortableTable && ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener() != null) {
            ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener().mouseDragged(mouseEvent);
        }
        super.mouseDragged(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this._header.getTable() instanceof SortableTable && ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener() != null) {
            ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener().mousePressed(mouseEvent);
        }
        super.mousePressed(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (SystemInfo.isJdk6Above() && this._header.getTable() instanceof SortableTable && ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener() != null) {
            ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener().mouseMoved(mouseEvent);
        }
        super.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._header.getTable() instanceof SortableTable && ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener() != null) {
            ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener().mouseReleased(mouseEvent);
        }
        super.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._header.getTable() instanceof SortableTable && ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener() != null) {
            ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener().mouseEntered(mouseEvent);
        }
        super.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._header.getTable() instanceof SortableTable && ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener() != null) {
            ((SortableTable)this._header.getTable()).getSortableHeaderMouseListener().mouseExited(mouseEvent);
        }
        super.mouseExited(mouseEvent);
    }
}

