/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelation;
import com.jidesoft.gantt.GanttEntryRelationModel;
import com.jidesoft.gantt.GanttEntryRenderer;
import com.jidesoft.gantt.GanttLabelRenderer;
import com.jidesoft.gantt.GanttModel;
import com.jidesoft.gantt.MutableGanttEntry;
import com.jidesoft.gantt.PeriodBackgroundPainter;
import com.jidesoft.gantt.SubEntryGanttEntry;
import com.jidesoft.grid.Expandable;
import com.jidesoft.plaf.GanttChartUI;
import com.jidesoft.plaf.GanttEntryRelationPainter;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicGanttEntryRelationPainter;
import com.jidesoft.plaf.basic.BasicScaleAreaUI;
import com.jidesoft.plaf.basic.GanttChartBackgroundPainter;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.range.Range;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.ExpandVetoException;

public class BasicGanttChartUI
extends GanttChartUI {
    public static final String UI_GANTT_CHART_FONT = "GanttChart.font";
    public static final String UI_GANTT_CHART_FOREGROUND = "GanttChart.foreground";
    public static final String UI_GANTT_CHART_BACKGROUND = "GanttChart.background";
    public static final String UI_GANTT_CHART_BACKGROUND_PAINTER = "GanttChart.backgroundPainter";
    public static final String UI_VISIBLE_RELATIONS_THRESHOLD = "GanttChart.visibleRelationsThreshold";
    public static final int DEFAULT_VISIBLE_RELATIONS_THRESHOLD = 25;
    protected GanttChart<Object, GanttEntry<Object>> _chart;
    protected CellRendererPane _rendererPane;
    private A<Object> \u0103;
    private GanttChartBackgroundPainter \u010b;
    private Border \u0107;
    private Border \u0106;
    private int \u0108;
    private static final Insets \u0101 = UIDefaultsLookup.getInsets("TaskBar.padding");
    private static final int \u0109 = 2;
    private static final int \u0105 = 4;
    private static final int \u010a = 0;
    private static final int \u0102 = 1;
    private static final int \u0104 = 2;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGanttChartUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._chart = (GanttChart)jComponent;
        Object object = UIManager.get(UI_GANTT_CHART_BACKGROUND_PAINTER);
        this.\u010b = object instanceof GanttChartBackgroundPainter ? (GanttChartBackgroundPainter)object : new GanttChartBackgroundPainter();
        Object object2 = UIManager.get(UI_VISIBLE_RELATIONS_THRESHOLD);
        this.\u0108 = object2 instanceof Integer ? (Integer)object2 : 25;
        this.installDefaults(this._chart);
        this.installListeners(this._chart);
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        GanttChart ganttChart = (GanttChart)jComponent;
        this.\u010b = null;
        this.\u0108 = 25;
        this.uninstallDefaults(ganttChart);
        this.uninstallListeners(ganttChart);
        this.uninstallKeyboardActions();
    }

    protected void installDefaults(GanttChart<Object, GanttEntry<Object>> ganttChart) {
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(ganttChart, UI_GANTT_CHART_BACKGROUND, UI_GANTT_CHART_FOREGROUND, UI_GANTT_CHART_FONT);
        Color color3 = ganttChart.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            color3 = UIManager.getColor("GanttChart.selectionBackground");
            ganttChart.setSelectionBackground(color3 != null ? color3 : UIManager.getColor("textHighlight"));
        }
        if ((color2 = ganttChart.getSelectionForeground()) == null || color2 instanceof UIResource) {
            color2 = UIManager.getColor("GanttChart.selectionForeground");
            ganttChart.setSelectionForeground(color2 != null ? color2 : UIManager.getColor("textHighlightText"));
        }
        if ((color = ganttChart.getGridColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor("GanttChart.gridLine");
            ganttChart.setGridColor(color != null ? color : Color.GRAY);
        }
        ganttChart.setShowGrid(true);
        ganttChart.setRowMargin(1);
        this.\u0107 = UIDefaultsLookup.getBorder("GanttChart.focusCellHighlightBorder");
        this.\u0106 = UIDefaultsLookup.getBorder("GanttChart.focusSelectedCellHighlightBorder");
        this._rendererPane = new CellRendererPane();
        ganttChart.add(this._rendererPane);
        this.initializePainters(ganttChart);
    }

    protected void initializePainters(GanttChart<?, ?> ganttChart) {
        this.setPainterIfResource(ganttChart, 1, new BasicRelationPainter(10, null, BasicRelationPainter.ARROW, \u0101));
        this.setPainterIfResource(ganttChart, 4, new BasicRelationPainter(10, null, BasicRelationPainter.ARROW, \u0101));
        this.setPainterIfResource(ganttChart, 2, new BasicRelationPainter(10, null, BasicRelationPainter.ARROW, \u0101));
        this.setPainterIfResource(ganttChart, 3, new BasicRelationPainter(10, null, BasicRelationPainter.ARROW, \u0101));
    }

    protected void setPainterIfResource(GanttChart<?, ?> ganttChart, int n2, GanttEntryRelationPainter ganttEntryRelationPainter) {
        GanttEntryRelationPainter ganttEntryRelationPainter2 = ganttChart.getRelationPainter(n2);
        if (ganttEntryRelationPainter2 == null || ganttEntryRelationPainter2 instanceof UIResource) {
            ganttChart.setRelationPainter(n2, ganttEntryRelationPainter);
        }
    }

    protected void uninstallDefaults(GanttChart<Object, GanttEntry<Object>> ganttChart) {
        ganttChart.remove(this._rendererPane);
        this.\u0107 = null;
        this.\u0106 = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.\u0101(0);
        SwingUtilities.replaceUIInputMap(this._chart, 0, inputMap);
        LazyActionMap.installLazyActionMap(this._chart, BasicGanttChartUI.class, "GanttChart.actionMap");
    }

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new B("selectPreviousRow"));
        lazyActionMap.put(new B("selectPreviousRowExtendSelection"));
        lazyActionMap.put(new B("selectPreviousRowChangeLead"));
        lazyActionMap.put(new B("selectNextRow"));
        lazyActionMap.put(new B("selectNextRowExtendSelection"));
        lazyActionMap.put(new B("selectNextRowChangeLead"));
        lazyActionMap.put(new B("selectFirstRow"));
        lazyActionMap.put(new B("selectFirstRowExtendSelection"));
        lazyActionMap.put(new B("selectFirstRowChangeLead"));
        lazyActionMap.put(new B("selectLastRow"));
        lazyActionMap.put(new B("selectLastRowExtendSelection"));
        lazyActionMap.put(new B("selectLastRowChangeLead"));
        lazyActionMap.put(new B("scrollUp"));
        lazyActionMap.put(new B("scrollUpExtendSelection"));
        lazyActionMap.put(new B("scrollUpChangeLead"));
        lazyActionMap.put(new B("scrollDown"));
        lazyActionMap.put(new B("scrollDownExtendSelection"));
        lazyActionMap.put(new B("scrollDownChangeLead"));
        lazyActionMap.put(new B("selectAll"));
        lazyActionMap.put(new B("clearSelection"));
        lazyActionMap.put(new B("addToSelection"));
        lazyActionMap.put(new B("toggleAndAnchor"));
        lazyActionMap.put(new B("extendTo"));
        lazyActionMap.put(new B("moveSelectionTo"));
        lazyActionMap.put(new B("zoomInPeriods"));
        lazyActionMap.put(new B("zoomOutPeriods"));
    }

    InputMap \u0101(int n2) {
        if (n2 == 0) {
            return (InputMap)UIDefaultsLookup.get("GanttChart.focusInputMap");
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this._chart, null);
        SwingUtilities.replaceUIInputMap(this._chart, 0, null);
    }

    protected void installListeners(GanttChart<Object, GanttEntry<Object>> ganttChart) {
        this.\u0103 = new A(ganttChart);
        ganttChart.addKeyListener(this.\u0103);
        ganttChart.addFocusListener(this.\u0103);
        ganttChart.addMouseListener(this.\u0103);
        ganttChart.addMouseMotionListener(this.\u0103);
        ganttChart.addMouseWheelListener(this.\u0103);
        ganttChart.addPropertyChangeListener(this.\u0103);
        ganttChart.getSelectionModel().addListSelectionListener(this.\u0103);
        if (ganttChart.getScaleArea() != null && ganttChart.getScaleArea().getTreeTable() != null) {
            ganttChart.getScaleArea().getTreeTable().addTreeWillExpandListener(this.\u0103);
            ganttChart.getScaleArea().getTreeTable().addTreeExpansionListener(this.\u0103);
        }
    }

    protected void uninstallListeners(GanttChart<?, ?> ganttChart) {
        ganttChart.removeKeyListener(this.\u0103);
        ganttChart.removeFocusListener(this.\u0103);
        ganttChart.removeMouseListener(this.\u0103);
        ganttChart.removeMouseMotionListener(this.\u0103);
        ganttChart.removeMouseWheelListener(this.\u0103);
        ganttChart.removePropertyChangeListener(this.\u0103);
        ganttChart.getSelectionModel().removeListSelectionListener(this.\u0103);
        if (ganttChart.getScaleArea() != null && ganttChart.getScaleArea().getTreeTable() != null) {
            ganttChart.getScaleArea().getTreeTable().removeTreeWillExpandListener(this.\u0103);
            ganttChart.getScaleArea().getTreeTable().removeTreeExpansionListener(this.\u0103);
        }
        this.\u0103 = null;
    }

    protected void paintBackground(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(ganttChart.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void paintEntries(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, int n2, int n3) {
        Rectangle rectangle = graphics.getClipBounds();
        for (int i2 = n2; i2 <= n3; ++i2) {
            Rectangle rectangle2 = ganttChart.getEntryRect(i2);
            GanttEntry<Object> ganttEntry = ganttChart.getEntryAt(i2);
            List list = null;
            if (ganttEntry instanceof SubEntryGanttEntry) {
                list = ((SubEntryGanttEntry)ganttEntry).getSubEntries();
            }
            if (rectangle2 == null) continue;
            if (list == null || list.size() <= 0) {
                rectangle2.x -= BasicGanttChartUI.\u0101.left;
                rectangle2.y -= BasicGanttChartUI.\u0101.top;
                rectangle2.width += BasicGanttChartUI.\u0101.left + BasicGanttChartUI.\u0101.right;
                rectangle2.height += BasicGanttChartUI.\u0101.top + BasicGanttChartUI.\u0101.bottom;
                if (!rectangle.intersects(rectangle2)) continue;
                this.paintGanttEntry(graphics, ganttChart, i2, rectangle2, \u0101);
                this.paintGanttLabel(graphics, ganttChart, i2, rectangle2);
                continue;
            }
            for (int i3 = 0; i3 < list.size(); ++i3) {
                GanttEntry ganttEntry2 = list.get(i3);
                Rectangle rectangle3 = ganttChart.getEntryRect(ganttEntry2, i2);
                if (rectangle3 == null) continue;
                rectangle2 = (Rectangle)rectangle3.clone();
                rectangle2.x -= BasicGanttChartUI.\u0101.left;
                rectangle2.y -= BasicGanttChartUI.\u0101.top;
                rectangle2.width += BasicGanttChartUI.\u0101.left + BasicGanttChartUI.\u0101.right;
                rectangle2.height += BasicGanttChartUI.\u0101.top + BasicGanttChartUI.\u0101.bottom;
                if (!rectangle.intersects(rectangle2)) continue;
                this.paintGanttEntry(graphics, ganttChart, i2, i3, rectangle2, \u0101);
                this.paintGanttLabel(graphics, ganttChart, i2, i3, rectangle2);
            }
        }
    }

    protected void paintGanttEntry(Graphics graphics, GanttChart<?, ?> ganttChart, int n2, Rectangle rectangle, Insets insets) {
        this.paintGanttEntry(graphics, ganttChart, n2, -1, rectangle, insets);
    }

    protected void paintGanttEntry(Graphics graphics, GanttChart<?, ?> ganttChart, int n2, int n3, Rectangle rectangle, Insets insets) {
        GanttEntryRenderer ganttEntryRenderer = ganttChart.getEntryRenderer(n2, n3);
        Component component = ganttChart.prepareRenderer(ganttEntryRenderer, n2, n3, insets);
        this._rendererPane.paintComponent(graphics, component, ganttChart, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    protected void paintGanttLabel(Graphics graphics, GanttChart<?, ?> ganttChart, int n2, Rectangle rectangle) {
        this.paintGanttLabel(graphics, ganttChart, n2, -1, rectangle);
    }

    protected void paintGanttLabel(Graphics graphics, GanttChart<?, ?> ganttChart, int n2, int n3, Rectangle rectangle) {
        GanttLabelRenderer ganttLabelRenderer = ganttChart.getLabelRenderer(n2, n3);
        if (ganttLabelRenderer != null) {
            Component component = ganttChart.prepareLabelRenderer(ganttLabelRenderer, n2, n3);
            int n4 = ganttChart.getLabelPosition();
            int n5 = ganttChart.getLabelEntryGap();
            boolean bl = ganttChart.getComponentOrientation().isLeftToRight();
            if (n4 == 11) {
                n4 = bl ? 3 : 7;
            } else if (n4 == 10) {
                n4 = bl ? 7 : 3;
            }
            if (n4 == 3) {
                rectangle.x += rectangle.width + n5;
                rectangle.width = component.getPreferredSize().width;
            } else if (n4 == 7) {
                rectangle.width = component.getPreferredSize().width;
                rectangle.x -= rectangle.width + n5;
            }
            this._rendererPane.paintComponent(graphics, component, ganttChart, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        GanttChart ganttChart = (GanttChart)jComponent;
        this.paintBackground(graphics, ganttChart);
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = ganttChart.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (ganttChart.getEntryCount() <= 0 || !rectangle2.intersects(rectangle)) {
            // empty if block
        }
        boolean bl = ganttChart.getComponentOrientation().isLeftToRight();
        Point point = rectangle.getLocation();
        if (!bl) {
            ++point.x;
        }
        Point point2 = new Point(rectangle.x + rectangle.width - (bl ? 1 : 0), rectangle.y + rectangle.height);
        int n2 = ganttChart.rowAtPoint(point);
        int n3 = ganttChart.rowAtPoint(point2);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = ganttChart.getEntryCount() - 1;
        }
        this.paintGrid(graphics, ganttChart, n2, n3);
        if (ganttChart.getModel() != null) {
            this.paintPeriodBackgrounds(graphics, ganttChart);
            this.paintSelection(graphics, ganttChart, n2, n3);
            this.paintEntries(graphics, ganttChart, n2, n3);
            this._rendererPane.removeAll();
            Rectangle rectangle3 = ganttChart.getVisibleRect();
            Point point3 = rectangle3.getLocation();
            int n4 = ganttChart.rowAtPoint(point3);
            point3.x += rectangle3.width;
            point3.y += rectangle3.height;
            int n5 = ganttChart.rowAtPoint(rectangle3.getLocation());
            this.paintGanttEntryRelations(graphics, ganttChart, Math.min(n4, n2), Math.max(n5, n3));
        }
    }

    protected void paintPeriodBackgrounds(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart) {
        List<PeriodBackgroundPainter<Object>> list = ganttChart.getPeriodBackgroundPainters();
        this.\u010b.paintPeriodBackgrounds(ganttChart, graphics, list);
    }

    protected void paintGrid(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, int n2, int n3) {
        if (ganttChart.isShowGrid()) {
            graphics.setColor(ganttChart.getGridColor());
            Rectangle rectangle = ganttChart.getRowRect(n2, true);
            Rectangle rectangle2 = ganttChart.getRowRect(n3, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            int n4 = rectangle3.x + rectangle3.width;
            int n5 = rectangle3.y;
            for (int i2 = n2; i2 <= n3; ++i2) {
                graphics.drawLine(rectangle3.x, (n5 += ganttChart.getRowHeight(i2)) - 1, n4 - 1, n5 - 1);
            }
        }
    }

    protected void paintSelection(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, int n2, int n3) {
        if (ganttChart.getSelectedRow() == -1) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n4 = ganttChart.getSelectionModel().getLeadSelectionIndex();
        for (int i2 = n2; i2 <= n3; ++i2) {
            Border border;
            Rectangle rectangle;
            boolean bl = ganttChart.isRowSelected(i2);
            boolean bl2 = ganttChart.isFocusOwner();
            if (bl) {
                rectangle = ganttChart.getRowRect(i2, !ganttChart.isShowGrid());
                graphics2D.setColor(ganttChart.getSelectionBackground());
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (n4 != i2 || !bl2) continue;
            rectangle = ganttChart.getRowRect(i2, !ganttChart.isShowGrid());
            Border border2 = border = bl && this.\u0106 != null ? this.\u0106 : this.\u0107;
            if (border == null) continue;
            Rectangle rectangle2 = graphics.getClipBounds();
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            border.paintBorder(ganttChart, graphics2D, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
        graphics2D.dispose();
    }

    protected void paintGanttEntryRelations(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, int n2, int n3) {
        int n4;
        HashSet<GanttEntryRelation<GanttEntry<Object>>> hashSet = new HashSet<GanttEntryRelation<GanttEntry<Object>>>();
        GanttModel<Object, GanttEntry<Object>> ganttModel = ganttChart.getModel();
        HashSet<GanttEntry<Object>> hashSet2 = new HashSet<GanttEntry<Object>>();
        GanttEntryRelationModel<GanttEntry<Object>> ganttEntryRelationModel = ganttModel.getGanttEntryRelationModel();
        if (ganttEntryRelationModel != null) {
            for (n4 = n2; n4 <= n3; ++n4) {
                GanttEntry<Object> ganttEntry = ganttChart.getEntryAt(n4);
                if (!hashSet2.add(ganttEntry)) continue;
                hashSet.addAll(ganttEntryRelationModel.getEntryRelations(ganttEntry));
            }
        }
        if (this.\u0108 != 0) {
            GanttEntry<Object> ganttEntry;
            int n5;
            int ganttEntryRelation;
            n4 = 0;
            int n6 = ganttModel.getEntryCount();
            if (this.\u0108 > 0) {
                n4 = Math.max(n4, n2 - this.\u0108);
                ganttEntryRelation = Math.min(n6, n3 + this.\u0108);
            }
            for (n5 = n4; n5 < n2; ++n5) {
                ganttEntry = ganttChart.getEntryAt(n5);
                if (!hashSet2.add(ganttEntry)) continue;
                hashSet.addAll(this.\u0101(ganttModel, ganttEntry, n2, n3));
            }
            for (n5 = n3 + 1; n5 < ganttEntryRelation; ++n5) {
                ganttEntry = ganttChart.getEntryAt(n5);
                if (!hashSet2.add(ganttEntry)) continue;
                hashSet.addAll(this.\u0101(ganttModel, ganttEntry, n2, n3));
            }
        }
        for (GanttEntryRelation ganttEntryRelation : hashSet) {
            this.paintGanttEntryRelation(graphics, ganttChart, ganttEntryRelation);
        }
    }

    private Set<GanttEntryRelation<GanttEntry<Object>>> \u0101(GanttModel<Object, GanttEntry<Object>> ganttModel, GanttEntry<Object> ganttEntry, int n2, int n3) {
        HashSet<GanttEntryRelation<GanttEntry<Object>>> hashSet = new HashSet<GanttEntryRelation<GanttEntry<Object>>>();
        GanttEntryRelationModel<GanttEntry<Object>> ganttEntryRelationModel = ganttModel.getGanttEntryRelationModel();
        if (ganttEntryRelationModel != null) {
            for (GanttEntryRelation<GanttEntry<Object>> ganttEntryRelation : ganttEntryRelationModel.getEntryRelations(ganttEntry)) {
                int n4;
                GanttEntry ganttEntry2;
                GanttEntry<Object> ganttEntry3 = ganttEntryRelation.getPredecessorEntry();
                int n5 = ganttModel.getIndexOf(ganttEntry3);
                if (n5 == -1) {
                    while ((ganttEntry2 = ganttEntry3.getParent()) != null && ganttEntry2 instanceof GanttEntry && (n5 = ganttModel.getIndexOf(ganttEntry3 = ganttEntry2)) == -1) {
                    }
                }
                if ((n4 = ganttModel.getIndexOf(ganttEntry2 = ganttEntryRelation.getSuccessorEntry())) == -1) {
                    Expandable expandable;
                    while ((expandable = ganttEntry2.getParent()) != null && expandable instanceof GanttEntry && (n4 = ganttModel.getIndexOf(ganttEntry2 = (GanttEntry)expandable)) == -1) {
                    }
                }
                if ((n5 > n3 || n4 < n2) && (n5 < n2 || n4 > n3)) continue;
                hashSet.add(ganttEntryRelation);
            }
        }
        return hashSet;
    }

    protected void paintGanttEntryRelation(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, GanttEntryRelation<GanttEntry<Object>> ganttEntryRelation) {
        GanttEntryRelationPainter ganttEntryRelationPainter = ganttChart.getRelationPainter(ganttEntryRelation.getRelationType());
        if (ganttEntryRelationPainter != null) {
            ganttEntryRelationPainter.paintRelation(graphics, ganttChart, ganttEntryRelation, false, false);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        GanttChart ganttChart = (GanttChart)jComponent;
        ScaleArea scaleArea = ganttChart.getScaleArea();
        Dimension dimension = scaleArea.getPreferredSize();
        dimension.height = scaleArea.getTreeTable() != null ? scaleArea.getTreeTable().getPreferredSize().height : ganttChart.getTotalRowHeight();
        return dimension;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize(GanttChart<?, ?> ganttChart) {
        ScaleArea<?> scaleArea = ganttChart.getScaleArea();
        int n2 = 400;
        int n3 = 400;
        if (scaleArea != null) {
            n2 = scaleArea.getPreferredPeriodSize().width * scaleArea.getVisiblePeriodCount();
            n3 = scaleArea.getTreeTable() != null ? scaleArea.getTreeTable().getPreferredScrollableViewportSize().height : Math.min(400, this.getPreferredSize(ganttChart).height);
        }
        return new Dimension(n2, n3);
    }

    public int getSubEntryIndex(int n2, Point point) {
        List list;
        GanttEntry<Object> ganttEntry;
        GanttModel<Object, GanttEntry<Object>> ganttModel = this._chart.getModel();
        if (ganttModel != null && (ganttEntry = ganttModel.getEntryAt(n2)) instanceof SubEntryGanttEntry && (list = ((SubEntryGanttEntry)ganttEntry).getSubEntries()) != null) {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                Rectangle rectangle;
                GanttEntry ganttEntry2 = list.get(i2);
                if (!(ganttEntry2 instanceof GanttEntry) || (rectangle = this._chart.getEntryRect(ganttEntry2, n2)) == null) continue;
                Rectangle rectangle2 = (Rectangle)rectangle.clone();
                rectangle2.x -= this._chart.getResizeAreaWidth() / 2;
                rectangle2.width += this._chart.getResizeAreaWidth();
                rectangle2.y -= 2;
                rectangle2.height += 4;
                if (!rectangle2.contains(point)) continue;
                return i2;
            }
        }
        return -1;
    }

    public GanttEntry getEntryAt(int n2, Point point) {
        GanttModel<Object, GanttEntry<Object>> ganttModel = this._chart.getModel();
        if (ganttModel != null) {
            List list;
            GanttEntry<Object> ganttEntry = ganttModel.getEntryAt(n2);
            if (ganttEntry instanceof SubEntryGanttEntry && (list = ((SubEntryGanttEntry)ganttEntry).getSubEntries()) != null) {
                GanttEntry ganttEntry2 = null;
                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    Rectangle rectangle;
                    GanttEntry ganttEntry3 = list.get(i2);
                    if (!(ganttEntry3 instanceof GanttEntry) || (rectangle = this._chart.getEntryRect(ganttEntry3, n2)) == null) continue;
                    if (rectangle.contains(point)) {
                        return ganttEntry3;
                    }
                    if (ganttEntry2 != null) continue;
                    Rectangle rectangle2 = (Rectangle)rectangle.clone();
                    rectangle2.x -= this._chart.getResizeAreaWidth() / 2;
                    rectangle2.width += this._chart.getResizeAreaWidth();
                    rectangle2.y -= 2;
                    rectangle2.height += 4;
                    if (!rectangle2.contains(point)) continue;
                    ganttEntry2 = ganttEntry3;
                }
                return ganttEntry2;
            }
            return ganttEntry;
        }
        return null;
    }

    private static int \u0101(GanttChart<?, ?> ganttChart, boolean bl, ListSelectionModel listSelectionModel) {
        int n2;
        int n3 = listSelectionModel.getLeadSelectionIndex();
        return n3 < (n2 = ganttChart.getEntryCount()) ? n3 : -1;
    }

    private static int \u0102(int n2, GanttChart<?, ?> ganttChart) {
        return n2 < ganttChart.getEntryCount() ? n2 : -1;
    }

    private static class B
    extends UIAction {
        private static final String \u0134 = "selectPreviousRow";
        private static final String \u0136 = "selectPreviousRowExtendSelection";
        private static final String \u012b = "selectPreviousRowChangeLead";
        private static final String \u013d = "selectNextRow";
        private static final String \u0139 = "selectNextRowExtendSelection";
        private static final String \u0131 = "selectNextRowChangeLead";
        private static final String \u013e = "selectFirstRow";
        private static final String \u0127 = "selectFirstRowExtendSelection";
        private static final String \u013b = "selectFirstRowChangeLead";
        private static final String \u0135 = "selectLastRow";
        private static final String \u0137 = "selectLastRowExtendSelection";
        private static final String \u012d = "selectLastRowChangeLead";
        private static final String \u0138 = "scrollUp";
        private static final String \u0133 = "scrollUpExtendSelection";
        private static final String \u012f = "scrollUpChangeLead";
        private static final String \u012c = "scrollDown";
        private static final String \u0129 = "scrollDownExtendSelection";
        private static final String \u0140 = "scrollDownChangeLead";
        private static final String \u0132 = "selectAll";
        private static final String \u0130 = "clearSelection";
        private static final String \u013c = "addToSelection";
        private static final String \u0128 = "toggleAndAnchor";
        private static final String \u012e = "extendTo";
        private static final String \u012a = "moveSelectionTo";
        private static final String \u013a = "zoomInPeriods";
        private static final String \u013f = "zoomOutPeriods";

        B(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            GanttChart ganttChart = (GanttChart)actionEvent.getSource();
            BasicGanttChartUI basicGanttChartUI = (BasicGanttChartUI)ganttChart.getUI();
            if (\u0134.equals(string)) {
                this.\u0101(ganttChart, 1, this.\u0101(ganttChart, basicGanttChartUI, -1), -1);
            } else if (\u0136.equals(string)) {
                this.\u0101(ganttChart, 2, this.\u0101(ganttChart, basicGanttChartUI, -1), -1);
            } else if (\u012b.equals(string)) {
                this.\u0101(ganttChart, 0, this.\u0101(ganttChart, basicGanttChartUI, -1), -1);
            } else if (\u013d.equals(string)) {
                this.\u0101(ganttChart, 1, this.\u0101(ganttChart, basicGanttChartUI, 1), 1);
            } else if (\u0139.equals(string)) {
                this.\u0101(ganttChart, 2, this.\u0101(ganttChart, basicGanttChartUI, 1), 1);
            } else if (\u0131.equals(string)) {
                this.\u0101(ganttChart, 0, this.\u0101(ganttChart, basicGanttChartUI, 1), 1);
            } else if (\u013e.equals(string)) {
                this.\u0101(ganttChart, 1, 0, -1);
            } else if (\u0127.equals(string)) {
                this.\u0101(ganttChart, 2, 0, -1);
            } else if (\u013b.equals(string)) {
                this.\u0101(ganttChart, 0, 0, -1);
            } else if (\u0135.equals(string)) {
                this.\u0101(ganttChart, 1, ganttChart.getEntryCount() - 1, 1);
            } else if (\u0137.equals(string)) {
                this.\u0101(ganttChart, 2, ganttChart.getEntryCount() - 1, 1);
            } else if (\u012d.equals(string)) {
                this.\u0101(ganttChart, 0, ganttChart.getEntryCount() - 1, 1);
            } else if (\u0138.equals(string)) {
                this.\u0101(ganttChart, 1, this.\u0101(ganttChart, -1), -1);
            } else if (\u0133.equals(string)) {
                this.\u0101(ganttChart, 2, this.\u0101(ganttChart, -1), -1);
            } else if (\u012f.equals(string)) {
                this.\u0101(ganttChart, 0, this.\u0101(ganttChart, -1), -1);
            } else if (\u012c.equals(string)) {
                this.\u0101(ganttChart, 1, this.\u0101(ganttChart, 1), 1);
            } else if (\u0129.equals(string)) {
                this.\u0101(ganttChart, 2, this.\u0101(ganttChart, 1), 1);
            } else if (\u0140.equals(string)) {
                this.\u0101(ganttChart, 0, this.\u0101(ganttChart, 1), 1);
            } else if (\u0132.equals(string)) {
                this.\u0101(ganttChart);
            } else if (\u0130.equals(string)) {
                this.\u0102(ganttChart);
            } else if (\u013c.equals(string)) {
                int n2 = BasicGanttChartUI.\u0102(ganttChart.getSelectionModel().getLeadSelectionIndex(), ganttChart);
                if (n2 >= 0 && !ganttChart.isRowSelected(n2)) {
                    int n3 = ganttChart.getSelectionModel().getAnchorSelectionIndex();
                    ganttChart.setValueIsAdjusting(true);
                    ganttChart.addSelectionInterval(n2, n2);
                    ganttChart.getSelectionModel().setAnchorSelectionIndex(n3);
                    ganttChart.setValueIsAdjusting(false);
                }
            } else if (\u0128.equals(string)) {
                int n4 = BasicGanttChartUI.\u0102(ganttChart.getSelectionModel().getLeadSelectionIndex(), ganttChart);
                if (ganttChart.isRowSelected(n4)) {
                    ganttChart.removeSelectionInterval(n4, n4);
                } else {
                    ganttChart.addSelectionInterval(n4, n4);
                }
            } else if (\u012e.equals(string)) {
                this.\u0101(ganttChart, 2, BasicGanttChartUI.\u0102(ganttChart.getSelectionModel().getLeadSelectionIndex(), ganttChart), 0);
            } else if (\u012a.equals(string)) {
                this.\u0101(ganttChart, 1, BasicGanttChartUI.\u0102(ganttChart.getSelectionModel().getLeadSelectionIndex(), ganttChart), 0);
            } else if (\u013a.equals(string)) {
                ganttChart.zoomInPeriods();
            } else if (\u013f.equals(string)) {
                ganttChart.zoomOutPeriods();
            }
        }

        @Override
        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (string == \u012b || string == \u0131 || string == \u013b || string == \u012d || string == \u012f || string == \u0140) {
                return object != null && ((GanttChart)object).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            return true;
        }

        private void \u0102(GanttChart<?, ?> ganttChart) {
            ganttChart.clearSelection();
        }

        private void \u0101(GanttChart<?, ?> ganttChart) {
            int n2 = ganttChart.getEntryCount();
            if (n2 > 0) {
                ListSelectionModel listSelectionModel = ganttChart.getSelectionModel();
                int n3 = BasicGanttChartUI.\u0102(listSelectionModel.getLeadSelectionIndex(), ganttChart);
                if (listSelectionModel.getSelectionMode() == 0) {
                    if (n3 == -1) {
                        int n4 = BasicGanttChartUI.\u0102(ganttChart.getMinSelectionIndex(), ganttChart);
                        n3 = n4 == -1 ? 0 : n4;
                    }
                    ganttChart.setSelectionInterval(n3, n3);
                    ganttChart.ensureRowIsVisible(n3);
                } else {
                    ganttChart.setValueIsAdjusting(true);
                    ganttChart.setSelectionInterval(0, n2 - 1);
                    ganttChart.setValueIsAdjusting(false);
                }
            }
        }

        private int \u0101(GanttChart<?, ?> ganttChart, int n2) {
            int n3;
            Rectangle rectangle;
            if (ganttChart.getEntryCount() == 0) {
                return -1;
            }
            Rectangle rectangle2 = ganttChart.getVisibleRect();
            ListSelectionModel listSelectionModel = ganttChart.getSelectionModel();
            int n4 = BasicGanttChartUI.\u0102(listSelectionModel.getLeadSelectionIndex(), ganttChart);
            Rectangle rectangle3 = rectangle = n4 == -1 ? new Rectangle() : ganttChart.getRowRect(n4, true);
            if (n2 < 0) {
                Point point = new Point(rectangle.x, rectangle2.y);
                n3 = ganttChart.rowAtPoint(point);
                if (n4 <= n3) {
                    point.y = rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
                    n3 = ganttChart.rowAtPoint(point);
                    Rectangle rectangle4 = ganttChart.getRowRect(n3, true);
                    if (rectangle4.y < rectangle2.y) {
                        point.y = rectangle4.y + rectangle4.height;
                        n3 = ganttChart.rowAtPoint(point);
                        rectangle4 = ganttChart.getRowRect(n3, true);
                    }
                    if (rectangle4.y >= rectangle.y) {
                        point.y = rectangle.y - 1;
                        n3 = ganttChart.rowAtPoint(point);
                    }
                }
            } else {
                Point point = new Point(rectangle.x, rectangle2.y + rectangle2.height - 1);
                n3 = ganttChart.rowAtPoint(point);
                Rectangle rectangle5 = ganttChart.getRowRect(n3, true);
                if (rectangle5.y + rectangle5.height > rectangle2.y + rectangle2.height) {
                    point.y = rectangle5.y - 1;
                    n3 = ganttChart.rowAtPoint(point);
                    n3 = Math.max(n3, n4);
                }
                if (n4 >= n3) {
                    rectangle2.y = rectangle.y;
                    point.y = rectangle2.y + rectangle2.height - 1;
                    n3 = ganttChart.rowAtPoint(point);
                    rectangle5 = ganttChart.getRowRect(n3, true);
                    if (rectangle5.y + rectangle5.height > rectangle2.y + rectangle2.height) {
                        point.y = rectangle5.y - 1;
                        n3 = ganttChart.rowAtPoint(point);
                        rectangle5 = ganttChart.getRowRect(n3, true);
                    }
                    if (rectangle5.y <= rectangle.y) {
                        point.y = rectangle.y + rectangle.height;
                        n3 = ganttChart.rowAtPoint(point);
                    }
                }
            }
            return n3;
        }

        private void \u0101(GanttChart<?, ?> ganttChart, int n2, int n3, int n4) {
            if (n3 >= 0 && n3 < ganttChart.getEntryCount()) {
                ListSelectionModel listSelectionModel = ganttChart.getSelectionModel();
                if (n2 == 0 && ganttChart.getSelectionMode() != 2) {
                    n2 = 1;
                }
                this.\u0101(ganttChart, n3, n4);
                if (n2 == 2) {
                    int n5 = BasicGanttChartUI.\u0102(listSelectionModel.getAnchorSelectionIndex(), ganttChart);
                    if (n5 == -1) {
                        n5 = 0;
                    }
                    ganttChart.setSelectionInterval(n5, n3);
                } else if (n2 == 1) {
                    ganttChart.setSelectedIndex(n3);
                } else {
                    ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(n3);
                }
            }
        }

        private void \u0101(GanttChart<?, ?> ganttChart, int n2, int n3) {
            if (n3 == 0) {
                return;
            }
            Rectangle rectangle = ganttChart.getRowRect(n2, true);
            Rectangle rectangle2 = ganttChart.getVisibleRect();
            if (rectangle != null && !rectangle2.contains(rectangle)) {
                if (n3 > 0 && (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height)) {
                    int n4 = Math.max(0, rectangle.y + rectangle.height - rectangle2.height);
                    int n5 = ganttChart.rowAtPoint(new Point(rectangle.x, n4));
                    Rectangle rectangle3 = ganttChart.getRowRect(n5, true);
                    if (rectangle3.y < n4 && rectangle3.y < rectangle.y) {
                        rectangle3.y += rectangle3.height;
                        n5 = ganttChart.rowAtPoint(rectangle3.getLocation());
                        rectangle3 = ganttChart.getRowRect(n5, true);
                    }
                    rectangle = rectangle3;
                    rectangle.height = rectangle2.height;
                } else {
                    rectangle.height = Math.min(rectangle.height, rectangle2.height);
                }
                ganttChart.scrollRectToVisible(rectangle);
            }
        }

        private int \u0101(GanttChart<?, ?> ganttChart, BasicGanttChartUI basicGanttChartUI, int n2) {
            int n3 = BasicGanttChartUI.\u0102(ganttChart.getLeadSelectionIndex(), ganttChart);
            int n4 = ganttChart.getEntryCount();
            if (n3 == -1) {
                if (n4 > 0) {
                    n3 = n2 > 0 ? 0 : n4 - 1;
                }
            } else {
                n3 = n4 == 1 ? 0 : (n3 += n2);
            }
            return n3;
        }
    }

    public static class BasicRelationPainter
    extends BasicGanttEntryRelationPainter
    implements UIResource {
        public static final Shape BLOCK = new Rectangle2D.Double(0.0, -2.0, 3.0, 4.0);
        public static final Shape ARROW = new Polygon(new int[]{0, 4, 4}, new int[]{0, -4, 4}, 3);
        public static final int DEFAULT_EXTEND_WIDTH = 10;

        public BasicRelationPainter(int n2, Shape shape, Shape shape2, Insets insets) {
            super(n2, shape, shape2, insets);
        }
    }

    private class A<T>
    implements MouseInputListener,
    MouseWheelListener,
    KeyListener,
    FocusListener,
    ListSelectionListener,
    PropertyChangeListener,
    TreeWillExpandListener,
    TreeExpansionListener,
    UIResource {
        private static final int \u0106 = 0;
        private static final int \u0112 = 1;
        private static final int \u010c = 2;
        private static final int \u010e = 3;
        private static final int \u0103 = 4;
        private static final int \u010b = 5;
        private final GanttChart<T, GanttEntry<T>> \u0102;
        private Point \u0109;
        private Point \u0105;
        private Rectangle \u0108;
        private int \u0111;
        private int \u0101;
        private MutableGanttEntry<T> \u010a;
        private int \u0107;
        private int \u0104;
        private boolean \u0110;

        private A(GanttChart<T, GanttEntry<T>> ganttChart) {
            this.\u0102 = ganttChart;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.\u0110 = false;
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            this.\u0110 = true;
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.\u0110 = false;
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            this.\u0110 = true;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                if (listSelectionModel != null) {
                    listSelectionModel.removeListSelectionListener(this);
                }
                if ((listSelectionModel = (ListSelectionModel)propertyChangeEvent.getNewValue()) != null) {
                    listSelectionModel.addListSelectionListener(this);
                }
            } else if (BasicScaleAreaUI.Handler.SCALE_PROPERTIES.contains(propertyChangeEvent.getPropertyName())) {
                this.\u0102.revalidate();
                this.\u0102.repaint();
            }
        }

        protected void \u0103() {
            Rectangle rectangle;
            int n2 = BasicGanttChartUI.\u0102(this.\u0102.getLeadSelectionIndex(), this.\u0102);
            if (n2 != -1 && (rectangle = this.\u0102.getRowRect(n2, true)) != null) {
                rectangle.grow(2, 2);
                this.\u0102.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.\u0103();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.\u0103();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (this.\u0102.getViewMode() == 1) {
                    Rectangle rectangle = new Rectangle(mouseEvent.getPoint());
                    Rectangle rectangle2 = this.\u0102.getVisibleRect();
                    rectangle.grow((rectangle2.width - rectangle.width) / 2, (rectangle2.height - rectangle.height) / 2);
                    this.\u0102.scrollRectToVisible(rectangle);
                } else if (this.\u010a != null) {
                    this.\u0102.scrollRowToVisible(this.\u0102.getIndexOf(this.\u010a));
                }
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.\u0101(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Object object;
                GanttEntry ganttEntry;
                this.\u0109 = mouseEvent.getPoint();
                this.\u0105 = SwingUtilities.convertPoint(this.\u0102, this.\u0109, this.\u0102.getParent());
                this.\u0108 = this.\u0102.getVisibleRect();
                int n2 = this.\u0102.rowAtPoint(this.\u0109);
                if (n2 >= 0 && (ganttEntry = BasicGanttChartUI.this.getEntryAt(n2, this.\u0109)) != null && (object = ganttEntry.getRange()) != null) {
                    ScaleArea scaleArea = this.\u0102.getScaleArea();
                    this.\u0107 = scaleArea.getX(object.lower());
                    this.\u0104 = scaleArea.getX(object.upper());
                }
                this.\u0111 = this.\u0102.rowAtPoint(this.\u0109);
                this.\u0102.requestFocusInWindow();
                ganttEntry = BasicGanttChartUI.this.getEntryAt(this.\u0111, mouseEvent.getPoint());
                if (this.\u0101 == 4 && ganttEntry instanceof MutableGanttEntry) {
                    object = this.\u0102.getEntryRect(ganttEntry, this.\u0111);
                    if (object == null) {
                        return;
                    }
                    double d2 = Math.max(0.0, Math.min(1.0, (double)(this.\u0109.x - ((Rectangle)object).x) / (double)((Rectangle)object).width));
                    ((MutableGanttEntry)ganttEntry).setCompletion(d2);
                    return;
                }
                if (this.\u0102.getViewMode() == 1 && !JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent) && !mouseEvent.isShiftDown()) {
                    object = this.\u0102.getEntryRect(ganttEntry, this.\u0111);
                    if (object == null) {
                        return;
                    }
                    ((Rectangle)object).grow(this.\u0102.getResizeAreaWidth(), this.\u0102.getResizeAreaWidth());
                    if (!((Rectangle)object).contains(this.\u0109)) {
                        return;
                    }
                }
            }
        }

        private void \u0101(MouseEvent mouseEvent) {
            if (this.\u0111 == -1) {
                return;
            }
            this.\u0102.changeSelection(this.\u0111, JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent), mouseEvent.isShiftDown());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.\u010a != null) {
                    this.\u010a.setAdjusting(false);
                    Expandable expandable = this.\u010a.getParent();
                    while (expandable instanceof MutableGanttEntry) {
                        ((MutableGanttEntry)expandable).setAdjusting(false);
                        expandable = expandable.getParent();
                    }
                    expandable = this.\u010a.getParent();
                    if (expandable != null) {
                        expandable.notifyChildUpdated(this.\u010a);
                    }
                    this.\u010a = null;
                }
                this.\u0108 = null;
                this.\u0105 = null;
                this.\u0109 = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            block24: {
                Point point;
                block25: {
                    block23: {
                        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                            return;
                        }
                        point = mouseEvent.getPoint();
                        if (this.\u0101 != 5) break block23;
                        int n2 = this.\u0102.rowAtPoint(point);
                        if (n2 == -1) {
                            return;
                        }
                        this.\u0102.changeSelection(n2, JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent), true);
                        break block24;
                    }
                    if (this.\u0101 != 0) break block25;
                    if (this.\u0108 == null || !this.\u0101()) break block24;
                    Point point2 = SwingUtilities.convertPoint(this.\u0102, point, this.\u0102.getParent());
                    Rectangle rectangle = new Rectangle(this.\u0108);
                    rectangle.x = (int)((double)rectangle.x + (this.\u0105.getX() - point2.getX()));
                    rectangle.y = (int)((double)rectangle.y + (this.\u0105.getY() - point2.getY()));
                    this.\u0102.scrollRectToVisible(rectangle);
                    break block24;
                }
                if (this.\u0109 != null) {
                    boolean bl = mouseEvent.isShiftDown();
                    boolean bl2 = this.\u0102.getComponentOrientation().isLeftToRight();
                    ScaleArea<T> scaleArea = this.\u0102.getScaleArea();
                    switch (this.\u0101) {
                        case 1: {
                            Rectangle rectangle;
                            Object object;
                            if (this.\u010a == null) {
                                return;
                            }
                            int n3 = point.x - this.\u0109.x;
                            T t2 = scaleArea.getInstantAt(this.\u0107 + n3);
                            if (bl) {
                                object = scaleArea.getSmallestVisiblePeriod();
                                t2 = scaleArea.getScaleModel().getPeriodStart((Period)object, t2);
                            }
                            this.\u010a.setAdjusting(true);
                            object = this.\u010a.getParent();
                            while (object instanceof MutableGanttEntry) {
                                ((MutableGanttEntry)object).setAdjusting(true);
                                object = object.getParent();
                            }
                            Range<Object> range = this.\u010a.setRange(t2, null);
                            Object t3 = range.upper();
                            if (t3 instanceof Comparable && ((Comparable)t3).compareTo(scaleArea.getEnd()) > 0) {
                                scaleArea.setEnd(t3);
                            }
                            if (t2 instanceof Comparable && ((Comparable)t2).compareTo(scaleArea.getStart()) < 0) {
                                scaleArea.setStart(t2);
                            }
                            this.\u0102();
                            int n4 = this.\u0102.rowAtPoint(point);
                            if (n4 < 0 || (rectangle = this.\u0102.getEntryRect(this.\u010a, n4)) == null) break;
                            Rectangle rectangle2 = (Rectangle)rectangle.clone();
                            rectangle2.x = mouseEvent.getX();
                            rectangle2.width = 1;
                            this.\u0102.scrollRectToVisible(rectangle2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            Rectangle rectangle;
                            Object t4;
                            Period period;
                            if (this.\u010a == null) {
                                return;
                            }
                            boolean bl3 = bl2 && this.\u0101 == 2 || !bl2 && this.\u0101 == 3;
                            Range range = this.\u010a.getRange();
                            if (range == null) {
                                return;
                            }
                            T t5 = scaleArea.getInstantAt(point.x);
                            if (bl) {
                                period = scaleArea.getSmallestVisiblePeriod();
                                t5 = scaleArea.getScaleModel().getPeriodStart(period, t5);
                            }
                            if (bl3) {
                                if (bl2 && point.x > this.\u0104 || !bl2 && point.x < this.\u0104) {
                                    period = range.lower();
                                    t4 = t5;
                                } else {
                                    period = t5;
                                    t4 = range.upper();
                                }
                            } else if (bl2 && point.x < this.\u0107 || !bl2 && point.x > this.\u0107) {
                                period = t5;
                                t4 = range.upper();
                            } else {
                                period = range.lower();
                                t4 = t5;
                            }
                            this.\u0102();
                            if (!this.\u0102.isAllowResizeEntry((GanttEntry<Period>)this.\u010a, period, (Period)t4)) break;
                            this.\u010a.setAdjusting(true);
                            this.\u010a.setRange(period, (Period)t4);
                            int n5 = this.\u0102.rowAtPoint(point);
                            if (n5 < 0 || (rectangle = this.\u0102.getEntryRect(this.\u010a, n5)) == null) break;
                            this.\u0102.scrollRectToVisible(rectangle);
                            break;
                        }
                        case 4: {
                            Rectangle rectangle;
                            GanttEntry ganttEntry = BasicGanttChartUI.this.getEntryAt(this.\u0111, mouseEvent.getPoint());
                            if (!(ganttEntry instanceof MutableGanttEntry) || (rectangle = this.\u0102.getEntryRect(ganttEntry, this.\u0111)) == null) break;
                            double d2 = (double)(point.x - rectangle.x) / (double)rectangle.width;
                            ((MutableGanttEntry)ganttEntry).setAdjusting(true);
                            ((MutableGanttEntry)ganttEntry).setCompletion(d2);
                            break;
                        }
                        default: {
                            assert (false) : "Unknown drag action: " + this.\u0101;
                            break;
                        }
                    }
                }
            }
        }

        protected void \u0102() {
            Container container;
            for (container = this.\u0102.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container != null) {
                container = container.getParent();
            }
            if (container != null) {
                container.invalidate();
                container.repaint();
                container.doLayout();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Point point = mouseEvent.getPoint();
            int n2 = this.\u0102.rowAtPoint(point);
            if (n2 == -1) {
                this.\u0102.setCursor(Cursor.getDefaultCursor());
                this.\u0101 = 0;
                this.\u010a = null;
                this.\u0107 = 0;
                this.\u0104 = 0;
                return;
            }
            GanttEntry ganttEntry = BasicGanttChartUI.this.getEntryAt(n2, mouseEvent.getPoint());
            if (ganttEntry != null && (rectangle = this.\u0102.getEntryRect(ganttEntry, n2)) != null) {
                boolean bl;
                Rectangle rectangle2 = (Rectangle)rectangle.clone();
                rectangle2.x -= this.\u0102.getResizeAreaWidth() / 2;
                rectangle2.width += this.\u0102.getResizeAreaWidth();
                rectangle2.y -= 2;
                rectangle2.height += 4;
                Range range = ganttEntry.getRange();
                if (range == null) {
                    return;
                }
                boolean bl2 = bl = range.maximum() == range.minimum();
                if (bl) {
                    rectangle2.x -= this.\u0102.getResizeAreaWidth() / 2;
                    rectangle2.width += this.\u0102.getResizeAreaWidth();
                }
                if (rectangle2.contains(point) && this.\u0102.isEditable() && this.\u0102.getViewMode() != 1 && ganttEntry instanceof MutableGanttEntry) {
                    this.\u010a = (MutableGanttEntry)ganttEntry;
                    boolean bl3 = this.\u010a.isRangeEditable();
                    boolean bl4 = this.\u010a.isCompletionEditable();
                    if (bl3 && this.\u0102.isResizeWestArea(point, rectangle)) {
                        this.\u0102.setCursor(JideCursors.getPredefinedCursor(37));
                        this.\u0101 = 2;
                    } else if (bl3 && this.\u0102.isResizeEastArea(point, rectangle)) {
                        this.\u0102.setCursor(JideCursors.getPredefinedCursor(36));
                        this.\u0101 = 3;
                    } else if (bl4 && !bl && point.y >= rectangle2.y + rectangle2.height / 2 - 2 && point.y <= rectangle2.y + rectangle2.height / 2 + 2) {
                        this.\u0102.setCursor(JideCursors.getPredefinedCursor(35));
                        this.\u0101 = 4;
                    } else if (bl3 && this.\u0102.isAllowMoveEntry() && (rectangle.contains(point) || rectangle.isEmpty() && new Rectangle(rectangle.x - this.\u0102.getResizeAreaWidth() / 2, rectangle.y, rectangle.width + this.\u0102.getResizeAreaWidth(), rectangle.height).contains(point))) {
                        this.\u0102.setCursor(Cursor.getPredefinedCursor(13));
                        this.\u0101 = 1;
                    } else {
                        this.\u0102.setCursor(Cursor.getDefaultCursor());
                        this.\u0101 = 0;
                        this.\u010a = null;
                        this.\u0107 = 0;
                        this.\u0104 = 0;
                        return;
                    }
                    ScaleArea scaleArea = this.\u0102.getScaleArea();
                    this.\u0107 = scaleArea.getX(range.lower());
                    this.\u0104 = scaleArea.getX(range.upper());
                    return;
                }
            }
            if (this.\u0102.getViewMode() == 1 && !JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent) && !mouseEvent.isShiftDown()) {
                if (this.\u0101()) {
                    this.\u0102.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    this.\u0102.setCursor(Cursor.getDefaultCursor());
                }
                this.\u0101 = 0;
            } else {
                this.\u0102.setCursor(Cursor.getDefaultCursor());
                this.\u0101 = 5;
            }
            this.\u010a = null;
            this.\u0107 = 0;
            this.\u0104 = 0;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this.\u0102.getViewMode() == 1 && (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16)) {
                this.\u0102.setCursor(Cursor.getDefaultCursor());
                this.\u0101 = 5;
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.\u0102.getViewMode() == 1 && (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16)) {
                if (this.\u0101()) {
                    this.\u0102.setCursor(Cursor.getPredefinedCursor(13));
                }
                this.\u0101 = 0;
            }
        }

        private boolean \u0101() {
            return !this.\u0102.getVisibleRect().contains(this.\u0102.getBounds());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (JideSwingUtilities.isMenuShortcutKeyDown(mouseWheelEvent) && this.\u0102.isAllowMouseWheelZoom()) {
                if (mouseWheelEvent.getWheelRotation() > 0) {
                    this.\u0102.zoomOutPeriods();
                } else {
                    this.\u0102.zoomInPeriods();
                }
                mouseWheelEvent.consume();
            } else if (this.\u0102.getParent() != null) {
                this.\u0102.getParent().dispatchEvent(SwingUtilities.convertMouseEvent(this.\u0102, mouseWheelEvent, this.\u0102.getParent()));
            }
        }
    }
}

