/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextAreaRowMarginSupport
extends AbstractRowMarginSupport {
    protected JTextArea _textArea;
    private DocumentListener \u0105;
    private PropertyChangeListener \u0106;

    public TextAreaRowMarginSupport(JTextArea jTextArea, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._textArea = jTextArea;
    }

    @Override
    public int getRowCount() {
        return this._textArea.getLineCount();
    }

    @Override
    public void scrollTo(int n2, int n3, boolean bl) {
        try {
            if (n2 <= n3) {
                if (n3 >= this._textArea.getLineCount()) {
                    n3 = this._textArea.getLineCount() - 1;
                }
                if (bl) {
                    this._textArea.setCaretPosition(this._textArea.getLineStartOffset(n2));
                    this._textArea.moveCaretPosition(this._textArea.getLineEndOffset(n3));
                } else {
                    this._textArea.setCaretPosition(this._textArea.getLineEndOffset(n3));
                }
            } else {
                if (n2 >= this._textArea.getLineCount()) {
                    n2 = this._textArea.getLineCount() - 1;
                }
                if (bl) {
                    this._textArea.setCaretPosition(this._textArea.getLineEndOffset(n2));
                    this._textArea.moveCaretPosition(this._textArea.getLineStartOffset(n3));
                } else {
                    this._textArea.setCaretPosition(this._textArea.getLineStartOffset(n3));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this._textArea.requestFocus();
    }

    @Override
    public int getRowHeight(int n2) {
        return this._textArea.getFontMetrics(this._textArea.getFont()).getHeight();
    }

    @Override
    public int positionToRow(int n2) {
        int n3 = this.getViewPosition();
        int n4 = this.getRowHeight(0);
        return (n3 + n2) / n4;
    }

    @Override
    public int rowToPosition(int n2) {
        int n3 = this.getRowHeight(0);
        int n4 = this.getViewPosition();
        return n3 * n2 - n4;
    }

    @Override
    public int getBaselineAdjustment() {
        return 2;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        super.installListeners(repaintCallback, modelChangedCallback);
        if (modelChangedCallback != null) {
            if (this.\u0105 == null) {
                this.\u0105 = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }
                };
            }
            if (this.\u0106 == null) {
                this.\u0106 = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof Document) {
                            ((Document)object2).removeDocumentListener(TextAreaRowMarginSupport.this.\u0105);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof Document) {
                            ((Document)object).addDocumentListener(TextAreaRowMarginSupport.this.\u0105);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._textArea.addPropertyChangeListener("document", this.\u0106);
            Document document = this._textArea.getDocument();
            if (document != null) {
                document.addDocumentListener(this.\u0105);
            }
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        if (this.\u0106 != null) {
            this._textArea.removePropertyChangeListener("document", this.\u0106);
        }
        if (this.\u0105 != null && this._textArea.getDocument() != null) {
            this._textArea.getDocument().removeDocumentListener(this.\u0105);
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

