/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractRowMargin;
import com.jidesoft.margin.MarginSupport;
import com.jidesoft.margin.RowMarginSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;

public class RowNumberMargin
extends AbstractRowMargin {
    private static Color \u010c = new Color(128, 0, 0);
    private boolean \u010e = false;
    private transient int \u010d = -1;

    public RowNumberMargin(RowMarginSupport rowMarginSupport) {
        super(rowMarginSupport);
        this.setForeground(\u010c);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.\u010d = rowMarginSupport.getRowCount();
    }

    @Override
    public void paintRowMargin(Graphics graphics, Rectangle rectangle, int n2) {
        int n3 = ((RowMarginSupport)this._marginSupport).visualRowToActualRow(n2);
        if (n3 != -1) {
            int n4 = n3 + 1;
            String string = "" + n4;
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            graphics.drawString(string, rectangle.x + rectangle.width - this.getFontMetrics(this.getFont()).stringWidth(string), rectangle.y + (rectangle.height + this.getFontMetrics(this.getFont()).getAscent() - this.getFontMetrics(this.getFont()).getDescent()) / 2 + ((RowMarginSupport)this._marginSupport).getBaselineAdjustment() - 1);
        }
    }

    @Override
    public String getToolTipText(int n2) {
        int n3;
        if (this.isShowTooltip() && (n3 = ((RowMarginSupport)this._marginSupport).visualRowToActualRow(n2)) >= 0) {
            return "" + (n3 + 1);
        }
        return null;
    }

    @Override
    public int getPreferredWidth() {
        int n2 = ((RowMarginSupport)this._marginSupport).getRowCount() - 1;
        String string = String.valueOf(((RowMarginSupport)this._marginSupport).visualRowToActualRow(n2) + 1);
        Insets insets = this.getInsets();
        return insets.left + insets.right + this.getFontMetrics(this.getFont()).stringWidth(string);
    }

    public boolean isShowTooltip() {
        return this.\u010e;
    }

    public void setShowTooltip(boolean bl) {
        this.\u010e = bl;
    }

    @Override
    protected MarginSupport.ModelChangedCallback createModelChangedCallback() {
        return new MarginSupport.ModelChangedCallback(){

            @Override
            public void modelChanged(Object object) {
                int n2 = ((RowMarginSupport)RowNumberMargin.this._marginSupport).getRowCount();
                if (RowNumberMargin.this.\u010d == -1 || n2 != RowNumberMargin.this.\u010d && (int)Math.log10(n2) != (int)Math.log10(RowNumberMargin.this.\u010d)) {
                    RowNumberMargin.this.revalidate();
                    RowNumberMargin.this.repaint();
                }
                RowNumberMargin.this.\u010d = n2;
            }
        };
    }
}

