/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.introspector;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.BeanTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.introspector.BeanProperty;
import com.jidesoft.introspector.Introspector;
import com.jidesoft.introspector.IntrospectorManager;
import com.jidesoft.utils.TypeUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BeanIntrospector
implements Introspector<BeanProperty> {
    public static final String PROPERTIES = "Properties";
    public static final String PROPERTY = "Property";
    private static final Pattern \u0103 = Pattern.compile("^get([A-Z0-9_][A-Za-z0-9_]*)$");
    private static final Pattern \u0104 = Pattern.compile("^is([A-Z0-9_][A-Za-z0-9_]*)$");
    private static final Pattern \u0102 = Pattern.compile("^set([A-Z0-9_][A-Za-z0-9_]*)$");
    private Class<?> \u0107;
    private LinkedHashMap<String, BeanProperty> \u0108 = new LinkedHashMap();
    private static final int \u0105 = 1;
    private static final int \u0106 = 2;
    private static final int \u0101 = 0;

    public BeanIntrospector(Class<?> clazz) throws IntrospectionException {
        this.\u0101(clazz, false);
    }

    public BeanIntrospector(Class<?> clazz, String[] stringArray) throws IntrospectionException {
        this.\u0101(clazz, stringArray, 3, true);
    }

    public BeanIntrospector(Class<?> clazz, String[] stringArray, int n2) throws IntrospectionException {
        this.\u0101(clazz, stringArray, n2, true);
    }

    public BeanIntrospector(Class<?> clazz, String[] stringArray, boolean bl) throws IntrospectionException {
        this.\u0101(clazz, stringArray, 3, bl);
    }

    private void \u0101(Class<?> clazz, String[] stringArray, int n2, boolean bl) throws IntrospectionException {
        for (int i2 = 0; i2 < stringArray.length; i2 += n2) {
            String string = stringArray[i2];
            string = java.beans.Introspector.decapitalize(string);
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (n2 == 2) {
                string4 = stringArray[i2 + 1];
            } else if (n2 == 3) {
                string2 = stringArray[i2 + 1];
                string3 = stringArray[i2 + 2];
            } else if (n2 == 4) {
                string4 = stringArray[i2 + 1];
                string2 = stringArray[i2 + 2];
                string3 = stringArray[i2 + 3];
            }
            BeanProperty beanProperty = this.\u0108.get(string);
            if (beanProperty != null) continue;
            BeanProperty beanProperty2 = this.createBeanProperty(string, clazz);
            beanProperty2.setDescription(string2);
            beanProperty2.setType(null);
            beanProperty2.setCategory(string3);
            if (string4 != null) {
                beanProperty2.setDisplayName(string4);
            }
            this.\u0108.put(string, beanProperty2);
        }
        this.\u0101(clazz, bl);
    }

    public BeanIntrospector(Class<?> clazz, String string) throws IntrospectionException {
        this.introspectProperties(clazz, string, true);
    }

    public BeanIntrospector(Class<?> clazz, InputStream inputStream) throws IntrospectionException {
        this.introspectProperties(clazz, inputStream, true);
    }

    public void introspectProperties(Class<?> clazz, String string, boolean bl) throws IntrospectionException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(string));
            NodeList nodeList = document.getElementsByTagName(PROPERTIES).item(0).getChildNodes();
            this.\u0101(clazz, nodeList, bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void introspectProperties(Class<?> clazz, InputStream inputStream, boolean bl) throws IntrospectionException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            NodeList nodeList = document.getElementsByTagName(PROPERTIES).item(0).getChildNodes();
            this.\u0101(clazz, nodeList, bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void \u0101(Class<?> clazz, NodeList nodeList, boolean bl) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException("Class<?> shouldn't be null.");
        }
        this.\u0107 = clazz;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Object object;
            Node node = nodeList.item(i2);
            if (!PROPERTY.equals(node.getNodeName())) continue;
            Element element = (Element)node;
            NamedNodeMap namedNodeMap = element.getAttributes();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            for (int i3 = 0; i3 < namedNodeMap.getLength(); ++i3) {
                object = namedNodeMap.item(i3);
                String string14 = object.getNodeName();
                if ("name".equals(string14)) {
                    string = object.getNodeValue();
                    continue;
                }
                if ("displayName".equals(string14)) {
                    string2 = object.getNodeValue();
                    continue;
                }
                if ("description".equals(string14)) {
                    string3 = object.getNodeValue();
                    continue;
                }
                if ("category".equals(string14)) {
                    string4 = object.getNodeValue();
                    continue;
                }
                if ("editorContext".equals(string14)) {
                    string7 = object.getNodeValue();
                    continue;
                }
                if ("converterContext".equals(string14)) {
                    string6 = object.getNodeValue();
                    continue;
                }
                if ("dependingProperties".equals(string14)) {
                    string5 = object.getNodeValue();
                    continue;
                }
                if ("autoIntrospect".equals(string14)) {
                    string8 = object.getNodeValue();
                    continue;
                }
                if ("editable".equals(string14)) {
                    string9 = object.getNodeValue();
                    continue;
                }
                if ("expert".equals(string14)) {
                    string10 = object.getNodeValue();
                    continue;
                }
                if ("hidden".equals(string14)) {
                    string11 = object.getNodeValue();
                    continue;
                }
                if ("preferred".equals(string14)) {
                    string12 = object.getNodeValue();
                    continue;
                }
                if (!"required".equals(string14)) continue;
                string13 = object.getNodeValue();
            }
            if (string == null) {
                throw new IllegalArgumentException("name attribute in Bean XML definition cannot be empty");
            }
            BeanProperty beanProperty = this.\u0108.get(string);
            if (beanProperty != null) continue;
            beanProperty = new BeanProperty(string, this.\u0107, string3, null, string4);
            if (string2 != null) {
                beanProperty.setDisplayName(string2);
            }
            if (string5 != null) {
                object = new StringTokenizer(string5, ",;");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    beanProperty.addDependingProperty(((StringTokenizer)object).nextToken());
                }
            }
            if (string6 != null) {
                beanProperty.setConverterContext(new ConverterContext(string6));
            }
            if (string7 != null) {
                beanProperty.setEditorContext(new EditorContext(string7));
            }
            if (string8 != null) {
                beanProperty.setAutoIntrospect(string8.equalsIgnoreCase("true"));
            }
            if (string9 != null) {
                beanProperty.setEditable(string9.equalsIgnoreCase("true"));
            }
            if (string10 != null) {
                beanProperty.setExpert(string10.equalsIgnoreCase("true"));
            }
            if (string11 != null) {
                beanProperty.setHidden(string11.equalsIgnoreCase("true"));
            }
            if (string12 != null) {
                beanProperty.setPreferred(string12.equalsIgnoreCase("true"));
            }
            if (string13 != null) {
                beanProperty.setRequired(string13.equalsIgnoreCase("true"));
            }
            this.\u0108.put(string, beanProperty);
        }
        this.\u0101(clazz, bl);
    }

    public BeanIntrospector(Class<?> clazz, BeanInfo beanInfo) {
        PropertyDescriptor[] propertyDescriptorArray;
        if (clazz == null) {
            throw new IllegalArgumentException("Class<?> shouldn't be null.");
        }
        this.\u0107 = clazz;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
            if (propertyDescriptor.getPropertyType() == null) continue;
            BeanProperty beanProperty = this.createBeanProperty(propertyDescriptor);
            this.\u0108.put(beanProperty.getName(), beanProperty);
        }
    }

    protected BeanProperty createBeanProperty(PropertyDescriptor propertyDescriptor) {
        return new BeanProperty(propertyDescriptor);
    }

    protected BeanProperty createBeanProperty(String string, Class<?> clazz) {
        return new BeanProperty(string, clazz);
    }

    /*
     * WARNING - void declaration
     */
    private void \u0101(Class<?> clazz, boolean bl) throws IntrospectionException {
        Object object;
        if (clazz == null) {
            throw new IllegalArgumentException("Class shouldn't be null.");
        }
        this.\u0107 = clazz;
        Field[] fieldArray = this.\u0107.getFields();
        AccessibleObject[] accessibleObjectArray = fieldArray;
        int n2 = accessibleObjectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void object2;
            Field field = accessibleObjectArray[i2];
            if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            object = field.getName();
            BeanProperty beanProperty = this.\u0108.get(object);
            if (beanProperty == null && !bl) {
                BeanProperty beanProperty2 = this.createBeanProperty((String)object, this.\u0107);
                this.\u0108.put((String)object, beanProperty2);
            }
            if (object2 == null) continue;
            object2.setField(field);
            object2.setType(TypeUtils.convertPrimitiveToWrapperType(field.getType()));
        }
        for (AccessibleObject accessibleObject : accessibleObjectArray = this.\u0107.getMethods()) {
            String string;
            int n3 = 0;
            Class<?> clazz2 = null;
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            object = \u0103.matcher(((Method)accessibleObject).getName());
            if (((Matcher)object).matches()) {
                if (((Method)accessibleObject).getReturnType() != null && ((Method)accessibleObject).getParameterTypes().length == 0) {
                    n3 = 1;
                    clazz2 = ((Method)accessibleObject).getReturnType();
                }
            } else {
                object = \u0104.matcher(((Method)accessibleObject).getName());
                if (((Matcher)object).matches()) {
                    if (((Method)accessibleObject).getReturnType() != null && ((Method)accessibleObject).getParameterTypes().length == 0) {
                        n3 = 1;
                        clazz2 = ((Method)accessibleObject).getReturnType();
                    }
                } else {
                    object = \u0102.matcher(((Method)accessibleObject).getName());
                    if (((Matcher)object).matches() && ((Method)accessibleObject).getReturnType() == Void.TYPE && ((Method)accessibleObject).getParameterTypes().length == 1) {
                        n3 = 2;
                        clazz2 = ((Method)accessibleObject).getParameterTypes()[0];
                    }
                }
            }
            if (n3 == 0 || (string = ((Matcher)object).group(1)).equals("Class")) continue;
            BeanProperty beanProperty = this.\u0108.get(string = java.beans.Introspector.decapitalize(string));
            if (beanProperty == null && !bl) {
                beanProperty = this.createBeanProperty(string, this.\u0107);
                this.\u0108.put(string, beanProperty);
            }
            if (beanProperty == null) continue;
            if (beanProperty.getType() == null) {
                beanProperty.setType(TypeUtils.convertPrimitiveToWrapperType(clazz2));
            }
            if (beanProperty.getWriteMethod() == null && n3 == 2 && TypeUtils.convertPrimitiveToWrapperType(clazz2) == beanProperty.getType()) {
                beanProperty.setWriteMethod((Method)accessibleObject);
                continue;
            }
            if (beanProperty.getReadMethod() != null || n3 != 1 || TypeUtils.convertPrimitiveToWrapperType(((Method)accessibleObject).getReturnType()) != beanProperty.getType()) continue;
            beanProperty.setReadMethod((Method)accessibleObject);
        }
    }

    public PropertyTableModel<Property> createPropertyTableModel(Object object) {
        return new PropertyTableModel<Property>(this.createPropertyList(object));
    }

    public <T> BeanTableModel createBeanTableModel(List<T> list) {
        return new BeanTableModel<T>(list, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Property> createPropertyList(Object object) {
        Class<?> clazz;
        Iterator<BeanProperty> iterator;
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (object == null) {
            return arrayList;
        }
        if (object instanceof LazyValue) {
            iterator = ((LazyValue)object).getValue();
            if (iterator == null) return arrayList;
            clazz = iterator.getClass();
        } else {
            clazz = object.getClass();
        }
        if (!this.\u0107.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Object class mismatch. Expected type is " + this.\u0107 + " but input type is " + object.getClass().getName());
        }
        iterator = this.\u0108.values().iterator();
        while (iterator.hasNext()) {
            Introspector introspector;
            BeanProperty beanProperty;
            final BeanProperty beanProperty2 = beanProperty = iterator.next();
            beanProperty2.setInstance(object);
            if (beanProperty2.getWriteMethod() == null && beanProperty2.getField() == null) {
                beanProperty2.setEditable(false);
            }
            arrayList.add(beanProperty2);
            if (beanProperty2.getType().isAssignableFrom(object.getClass()) || !beanProperty2.isAutoIntrospect() || !((introspector = IntrospectorManager.getIntrospector(beanProperty2.getType())) instanceof BeanIntrospector)) continue;
            beanProperty2.setChildren(((BeanIntrospector)introspector).createPropertyList(new LazyValue(){

                @Override
                public Object getValue() {
                    return beanProperty2.getValue();
                }
            }));
        }
        return arrayList;
    }

    @Override
    public int getPropertyCount() {
        return this.\u0108.size();
    }

    @Override
    public BeanProperty getProperty(String string) {
        BeanProperty beanProperty = this.\u0108.get(java.beans.Introspector.decapitalize(string));
        if (beanProperty.getWriteMethod() == null && beanProperty.getField() == null) {
            beanProperty.setEditable(false);
        }
        return beanProperty;
    }

    @Override
    public void removeProperty(String string) {
        this.\u0108.remove(java.beans.Introspector.decapitalize(string));
    }

    @Override
    public void addProperty(BeanProperty beanProperty) {
        this.\u0108.put(beanProperty.getName(), beanProperty);
    }

    @Override
    public String[] getPropertyNames() {
        String[] stringArray = new String[this.\u0108.size()];
        int n2 = 0;
        for (Property property : this.\u0108.values()) {
            stringArray[n2++] = property.getName();
        }
        return stringArray;
    }

    public static interface LazyValue {
        public Object getValue();
    }
}

