/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.AbstractExpandable;
import com.jidesoft.grid.AbstractNode;
import com.jidesoft.grid.CategorizedTableModel;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorStyleTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.O;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PropertyTableModel<T extends Property>
extends TreeTableModel<T>
implements SpanModel,
CategorizedTableModel,
PropertyChangeListener,
EditorStyleTableModel {
    public static final int CATEGORIZED = 0;
    public static final int SORTED = 1;
    public static final int UNSORTED = 2;
    private int \u0e09 = 0;
    private boolean \u0e0b = true;
    private Comparator<? super T> \u0e07;
    private List<T> \u0e08;
    private HashMap<String, Property> \u0e0c;
    protected boolean _indentNonCategoryRow = false;
    private PropertyChangeSupport \u0e0a;
    private String \u0e05;
    private int \u0e0e = 0;
    private List<T> \u0e0d;
    private static final long \u0e06 = -5965454576700448089L;

    public PropertyTableModel() {
    }

    public PropertyTableModel(List<T> list) {
        this.setOriginalProperties(list);
    }

    public PropertyTableModel(List<T> list, String[] stringArray) {
        this.setCategories(stringArray);
        this.setOriginalProperties(list);
    }

    public PropertyTableModel(List<T> list, int n2) {
        this.setCategoryOrder(n2);
        this.setOriginalProperties(list);
    }

    public void setOriginalProperties(List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        this.\u0e0d = list;
        this.\u0109(list);
        this.reloadProperties();
    }

    private void \u0109(List list) {
        for (Object e2 : list) {
            if (!(e2 instanceof Property)) continue;
            ((Property)e2).removePropertyChangeListener(this);
            ((Property)e2).addPropertyChangeListener(this);
            if (!((Property)e2).hasChildren()) continue;
            this.\u0109(((Property)e2).getChildren());
        }
    }

    public void releaseProperties() {
        this.\u010a(this.\u0e0d);
    }

    private void \u010a(List list) {
        for (Object e2 : list) {
            if (!(e2 instanceof Property)) continue;
            ((Property)e2).removePropertyChangeListener(this);
            if (!((Property)e2).hasChildren()) continue;
            this.\u010a(((Property)e2).getChildren());
        }
    }

    public Comparator<? super T> getComparator() {
        return this.\u0e07;
    }

    public void setComparator(Comparator<? super T> comparator) {
        this.\u0e07 = comparator;
    }

    protected List<T> buildProperties(List<T> list) {
        Property property;
        String string;
        if (this.getOrder() == 1) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            for (Object object : list) {
                arrayList.add((Property)object);
            }
            if (this.getComparator() != null) {
                Collections.sort(arrayList, this.getComparator());
            } else {
                Collections.sort(arrayList, new Comparator<T>(){

                    public int \u0101(T t2, T t3) {
                        if (t2 != null && t3 != null) {
                            return ((Property)t2).getDisplayName().compareTo(((Property)t3).getDisplayName());
                        }
                        return 0;
                    }
                });
            }
            ArrayList arrayList2 = new ArrayList();
            for (Property property2 : arrayList) {
                property2.setParent((Expandable)this.getRoot());
                if (this.shouldBeFiltered((T)property2)) continue;
                arrayList2.add(property2);
            }
            return arrayList2;
        }
        if (this.getOrder() == 2) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            for (Object object : list) {
                arrayList.add((Property)object);
            }
            ArrayList arrayList3 = new ArrayList();
            for (Property property3 : arrayList) {
                property3.setParent((Expandable)this.getRoot());
                if (this.filterProperty(property3)) continue;
                arrayList3.add(property3);
            }
            return arrayList3;
        }
        if (this.\u0e08 == null) {
            this.\u0e08 = new ArrayList<T>();
        }
        if (this.\u0e0c == null) {
            this.\u0e0c = new HashMap();
        }
        String string2 = "Misc";
        try {
            string2 = this.getMiscCategoryName();
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage() + " " + throwable.getCause());
        }
        for (Property property4 : list) {
            string = property4.getCategory();
            if (string != null && string.length() != 0) {
                if (this.\u0e0c.get(property4.getCategory()) != null) continue;
                property = this.createCategory(string);
                this.\u0e0c.put(string, property);
                if (this.\u0e08.contains(property)) continue;
                this.\u0e08.add(property);
                continue;
            }
            if (this.\u0e0c.get(string2) != null) continue;
            property = this.createCategory(string2);
            property.setCategoryRow(true);
            this.\u0e0c.put(string2, property);
            if (this.\u0e08.contains(property)) continue;
            this.\u0e08.add(property);
        }
        for (Property property4 : this.\u0e08) {
            if (!property4.hasChildren()) continue;
            property4.getChildren().clear();
        }
        for (Property property4 : list) {
            if (this.filterProperty(property4)) continue;
            string = property4.getCategory();
            if (string == null || string.length() == 0) {
                string = string2;
            }
            if ((property = this.\u0e0c.get(string)) == null) continue;
            property.setParent(null);
            property.addChild(property4);
        }
        for (int i2 = this.\u0e08.size() - 1; i2 >= 0; --i2) {
            Property property4;
            property4 = (Property)this.\u0e08.get(i2);
            if (property4.hasChildren()) continue;
            this.\u0e08.remove(property4);
            this.\u0e0c.remove(property4.getName());
        }
        if (this.getCategoryOrder() > 0) {
            Collections.sort(this.\u0e08);
        } else if (this.getCategoryOrder() < 0) {
            Collections.sort(this.\u0e08);
            Collections.reverse(this.\u0e08);
        }
        return this.\u0e08;
    }

    protected Property createCategory(String string) {
        return new O(string);
    }

    protected boolean filterProperty(T t2) {
        return ((Property)t2).isHidden() || ((Property)t2).isExpert() && !this.isShowExpert();
    }

    @Override
    protected boolean shouldBeFiltered(T t2) {
        return this.filterProperty(t2);
    }

    public int getOrder() {
        return this.\u0e09;
    }

    public void setOrder(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("The order must be one of the following values - CATEGORIZED, SORTED or UNSORTED");
        }
        this.\u0e09 = n2;
        this.reloadProperties();
    }

    public List<T> getProperties() {
        return this.getRows();
    }

    public List<T> getProperties(boolean bl) {
        if (!bl) {
            return this.getProperties();
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        List<T> list = this.getProperties();
        for (Property property : list) {
            if (property.hasChildren() && !property.isExpanded()) {
                this.\u0101(arrayList, property);
                continue;
            }
            arrayList.add(property);
        }
        return arrayList;
    }

    private void \u0101(List<T> list, T t2) {
        list.add(t2);
        if (((AbstractExpandable)t2).hasChildren()) {
            for (int i2 = 0; i2 < ((AbstractExpandable)t2).getChildrenCount(); ++i2) {
                Property property = (Property)((AbstractExpandable)t2).getChildAt(i2);
                if (this.filterProperty(property)) continue;
                this.\u0101(list, property);
            }
        }
    }

    public List<T> getOriginalProperties() {
        return this.\u0e0d;
    }

    public List<T> getOriginalProperties(boolean bl) {
        if (!bl) {
            return this.getOriginalProperties();
        }
        ArrayList arrayList = new ArrayList();
        for (Property property : this.getOriginalProperties()) {
            this.\u0101(arrayList, property);
        }
        return arrayList;
    }

    public void reloadProperties() {
        this.refresh();
    }

    @Override
    public void setOriginalRows(List<? extends T> list) {
        this.\u0e0d = new ArrayList<T>();
        for (T t2 : list) {
            this.\u0e0d.add((Property)t2);
        }
        this.reloadProperties();
    }

    @Override
    public void refresh() {
        List<T> list = this.getOriginalProperties();
        if (list != null) {
            super.setOriginalRows(this.buildProperties(list));
        }
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        T t2 = this.getPropertyAt(n2);
        if (t2 == null) {
            return;
        }
        if (n3 == 1) {
            if (!((Property)t2).isEditable()) {
                return;
            }
            Object object2 = ((Property)t2).getValue();
            if (!this.compares(object, object2)) {
                ((Property)t2).setValue(object);
                this.firePropertyChange(((Property)t2).getFullName(), object2, object);
                this.fireTableCellUpdated(n2, n3);
                for (Expandable expandable = ((AbstractNode)t2).getParent(); expandable != null; expandable = expandable.getParent()) {
                    int n4;
                    if (!(expandable instanceof Property) || (n4 = this.getPropertyIndex((Property)expandable)) == -1) continue;
                    this.fireTableCellUpdated(n4, n3);
                }
                if (((Property)t2).getDependingProperties() != null) {
                    List<String> list = ((Property)t2).getDependingProperties();
                    for (String string : list) {
                        int n5;
                        T t3 = this.getVisibleProperty(string);
                        if (t3 == null || (n5 = this.getPropertyIndex(t3)) == -1) continue;
                        this.fireTableCellUpdated(n5, n3);
                    }
                }
            }
        }
    }

    protected boolean compares(Object object, Object object2) {
        return JideSwingUtilities.equals(object2, object);
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        if (n3 == 0) {
            return false;
        }
        T t2 = this.getPropertyAt(n2);
        return t2 != null && ((Property)t2).isEditable();
    }

    @Override
    public String getColumnName(int n2) {
        if (n2 == 0) {
            return GridResource.getResourceBundle(Locale.getDefault()).getString("Table.name");
        }
        return GridResource.getResourceBundle(Locale.getDefault()).getString("Table.value");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public T getPropertyAt(int n2) {
        return (T)((Property)this.getRowAt(n2));
    }

    public int getPropertyIndex(T t2) {
        return this.getRowIndex(t2);
    }

    @Deprecated
    public T findProperty(String string) {
        return this.getVisibleProperty(string);
    }

    public T getVisibleProperty(String string) {
        if (this.getRows() == null || string == null || string.trim().length() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < this.getRows().size(); ++i2) {
            Property property = (Property)this.getRows().get(i2);
            if (property instanceof O || !string.equals(property.getFullName())) continue;
            return (T)property;
        }
        return null;
    }

    public T getProperty(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        List<T> list = this.getOriginalProperties(true);
        for (Property property : list) {
            if (!string.equals(property.getFullName())) continue;
            return (T)property;
        }
        return null;
    }

    @Override
    public ConverterContext getConverterContextAt(int n2, int n3) {
        if (n3 == 1) {
            T t2 = this.getPropertyAt(n2);
            if (t2 != null) {
                return ((Property)t2).getConverterContext();
            }
            return null;
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n2, int n3) {
        if (n3 == 1) {
            T t2 = this.getPropertyAt(n2);
            if (t2 != null) {
                return ((Property)t2).getEditorContext();
            }
            return null;
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n2, int n3) {
        if (n3 == 1) {
            T t2 = this.getPropertyAt(n2);
            if (t2 != null) {
                return ((Property)t2).getType();
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isCategoryRow(int n2) {
        T t2 = this.getPropertyAt(n2);
        return t2 != null && ((Property)t2).isCategoryRow();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.\u0e0a == null) {
            this.\u0e0a = new PropertyChangeSupport(this);
        }
        this.\u0e0a.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.\u0e0a == null) {
            return;
        }
        this.\u0e0a.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.\u0e0a == null) {
            return new PropertyChangeListener[0];
        }
        return this.\u0e0a.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.\u0e0a == null) {
            this.\u0e0a = new PropertyChangeSupport(this);
        }
        this.\u0e0a.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.\u0e0a == null) {
            return;
        }
        this.\u0e0a.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.\u0e0a == null) {
            return new PropertyChangeListener[0];
        }
        return this.\u0e0a.getPropertyChangeListeners(string);
    }

    protected synchronized void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.\u0e0a;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.\u0e0a;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n2, int n3) {
        PropertyChangeSupport propertyChangeSupport = this.\u0e0a;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n2, n3);
    }

    public boolean isIndentNonCategoryRow() {
        return this._indentNonCategoryRow;
    }

    @Deprecated
    public void setIndentNonCategoryRow(boolean bl) {
        this._indentNonCategoryRow = bl;
    }

    public String getMiscCategoryName() {
        if (this.\u0e05 == null) {
            return GridResource.getResourceBundle(Locale.getDefault()).getString("Table.misc");
        }
        return this.\u0e05;
    }

    public void setMiscCategoryName(String string) {
        this.\u0e05 = string;
    }

    public void renameCategory(String string, String string2) {
        for (int i2 = 0; i2 < this.getOriginalProperties().size(); ++i2) {
            Property property = (Property)this.getOriginalProperties().get(i2);
            if (!string.equals(property.getCategory())) continue;
            property.setCategory(string2);
        }
        Property property = this.\u0e0c.get(string);
        if (property instanceof O) {
            property.setName(string2);
            this.\u0e0c.remove(string);
            this.\u0e0c.put(string2, property);
        }
        this.reloadProperties();
    }

    public void setCategories(String[] stringArray) {
        this.\u0e08 = new ArrayList<T>();
        this.\u0e0c = new HashMap();
        for (String string : stringArray) {
            Property property = this.createCategory(string);
            this.\u0e08.add(property);
            this.\u0e0c.put(string, property);
        }
    }

    public Property[] getCategories() {
        if (this.\u0e08 == null) {
            return new Property[0];
        }
        return this.\u0e08.toArray(new Property[this.\u0e08.size()]);
    }

    public int getCategoryOrder() {
        return this.\u0e0e;
    }

    public void setCategoryOrder(int n2) {
        if (n2 > 1) {
            n2 = 1;
        } else if (n2 < -1) {
            n2 = -1;
        }
        if (this.\u0e0e != n2) {
            this.\u0e0e = n2;
            if (this.\u0e09 == 0) {
                this.reloadProperties();
            }
        }
    }

    public boolean isShowExpert() {
        return this.\u0e0b;
    }

    public void setShowExpert(boolean bl) {
        this.\u0e0b = bl;
        this.reloadProperties();
    }

    @Override
    public CellSpan getCellSpanAt(int n2, int n3) {
        T t2 = this.getPropertyAt(n2);
        if (t2 != null && ((Property)t2).isCategoryRow()) {
            return new CellSpan(n2, 0, 1, this.getColumnCount());
        }
        return null;
    }

    @Override
    public boolean isCellSpanOn() {
        return true;
    }

    @Override
    public void addRow(int n2, T t2, boolean bl) {
        throw new IllegalStateException("Do not call addRow method on PropertyTableModel because PropertyTableModel having its own way to manage the data. You can call getOriginalProperties to get original property list and add a new property to it, then call refresh() method to reload the table model.");
    }

    @Override
    public void addRows(T t2, int n2, List<? extends T> list) {
        throw new IllegalStateException("Do not call addRows method on PropertyTableModel because PropertyTableModel having its own way to manage the data. You can call getOriginalProperties to get original property list and add new properties to it, then call refresh() method to reload the table model.");
    }

    @Override
    public void addRows(int n2, List<? extends T> list, boolean bl) {
        throw new IllegalStateException("Do not call addRows method on PropertyTableModel because PropertyTableModel having its own way to manage the data. You can call getOriginalProperties to get original property list and add new properties to it, then call refresh() method to reload the table model.");
    }

    @Override
    public void removeRow(int n2) {
        throw new IllegalStateException("Do not call removeRow method on PropertyTableModel because PropertyTableModel having its own way to manage the data. You can call getOriginalProperties to get original property list and remove property from it, then call refresh() method to reload the table model.");
    }

    public void bind(Object object) throws Exception {
        Method method = object.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
        method.invoke(object, this);
    }

    public void unbind(Object object) throws Exception {
        Method method = object.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
        method.invoke(object, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block3: {
            block1: {
                Property property;
                block2: {
                    if (!(propertyChangeEvent.getSource() instanceof Property)) break block1;
                    property = (Property)propertyChangeEvent.getSource();
                    if (!"name".equals(propertyChangeEvent.getPropertyName())) break block2;
                    property.cellUpdated(0);
                    break block3;
                }
                if (!"value".equals(propertyChangeEvent.getPropertyName())) break block3;
                property.cellUpdated(1);
                break block3;
            }
            for (Row row : this.getOriginalProperties()) {
                if (!(row instanceof Property) || !((Property)row).getName().equals(propertyChangeEvent.getPropertyName())) continue;
                row.cellUpdated(1);
                break;
            }
        }
    }

    @Override
    public Map<Object, Boolean> getExpansionState() {
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        List<T> list = this.getProperties(true);
        for (Property property : list) {
            hashMap.put(property.getFullName(), property.isExpanded());
        }
        return hashMap;
    }

    @Override
    public void setExpansionState(Map<Object, Boolean> map) {
        List<T> list = this.getProperties(true);
        for (Property property : list) {
            Boolean bl = map.get(property.getFullName());
            if (bl == null) continue;
            property.setExpanded(bl);
        }
        this.refresh();
    }

    @Override
    public int getEditorStyleAt(int n2, int n3) {
        T t2;
        if (n3 == 1 && (t2 = this.getPropertyAt(n2)) != null) {
            return ((Property)t2).getEditorStyle();
        }
        return 0;
    }
}

