/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.BooleanCheckBoxCellEditor;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellEditorValueProvider;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorContextSupport;
import com.jidesoft.grid.H;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTableCellRenderer;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TextFieldCellEditor;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.HtmlUtils;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PropertyTable
extends TreeTable {
    private TableCellRenderer \u1e33;
    private TableCellRenderer \u1e32;
    public static final int SHOW_NONEDITABLE_BOTH_NAME_VALUE = 3;
    public static final int SHOW_NONEDITABLE_VALUE_ONLY = 2;
    public static final int SHOW_NONEDITABLE_NAME_ONLY = 1;
    public static final int SHOW_NONEDITABLE_NEITHER = 0;
    private int \u1e31 = 2;
    private boolean \u1e34 = false;

    public PropertyTable(TableModel tableModel) {
        super(tableModel);
        this.\u02a2();
    }

    public PropertyTable() {
        this.\u02a2();
    }

    private void \u02a2() {
        MouseMotionListener[] mouseMotionListenerArray;
        this.setSortable(false);
        this.setExpandableColumn(0);
        this.getSelectionModel().setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setAutoResizeMode(4);
        MouseMotionListener mouseMotionListener = null;
        for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray = this.getMouseMotionListeners()) {
            if (!(mouseMotionListener2 instanceof BasicTableUI.MouseInputHandler)) continue;
            mouseMotionListener = mouseMotionListener2;
            break;
        }
        if (mouseMotionListener != null) {
            this.removeMouseMotionListener(mouseMotionListener);
        }
        if (mouseMotionListener != null) {
            this.addMouseMotionListener(mouseMotionListener);
        }
        this.\u1e33 = this.createPropertyCellRenderer();
        this.setColumnResizable(true);
        this.setAutoStartCellEditing(true);
        this.setAlwaysRequestFocusForEditor(true);
    }

    @Override
    protected void muteDefaultKeyStroke() {
        super.muteDefaultKeyStroke();
        this.replaceAction(KeyStroke.getKeyStroke(9, 0));
    }

    protected TableCellRenderer createPropertyCellRenderer() {
        return new PropertyTableCellRenderer();
    }

    private void \u02a3() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    private void \u02a1() {
        if (this.isEditing()) {
            this.removeEditor();
        }
    }

    @Override
    protected String convertElementToString(Object object, int n2, int n3) {
        Property property = this.\u0147(n2);
        if (property != null) {
            return ObjectConverterManager.toString(object, property.getType(), property.getConverterContext());
        }
        return super.convertElementToString(object, n2, n3);
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.\u02a3();
        this.\u02a1();
        if (!(tableModel instanceof PropertyTableModel) && TableModelWrapperUtils.getActualTableModel(tableModel, PropertyTableModel.class) == null) {
            super.setModel(new PropertyTableModel());
        } else {
            super.setModel(tableModel);
        }
    }

    Property \u0147(int n2) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof PropertyTableModel) {
            return ((PropertyTableModel)tableModel).getPropertyAt(n2);
        }
        PropertyTableModel propertyTableModel = (PropertyTableModel)TableModelWrapperUtils.getActualTableModel(tableModel, PropertyTableModel.class);
        int n3 = TableModelWrapperUtils.getActualRowAt(tableModel, n2, propertyTableModel);
        return propertyTableModel.getPropertyAt(n3);
    }

    public PropertyTableModel getPropertyTableModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof PropertyTableModel) {
            return (PropertyTableModel)tableModel;
        }
        return (PropertyTableModel)TableModelWrapperUtils.getActualTableModel(tableModel, PropertyTableModel.class);
    }

    public void setSelectedProperty(Property property) {
        this.setSelectedRow(property);
    }

    public Property getSelectedProperty() {
        int n2 = this.getSelectionModel().getLeadSelectionIndex();
        return this.\u0147(n2);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        jToolTip.setBackground(this.getBackground());
        jToolTip.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getForeground()), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        return jToolTip;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Rectangle rectangle;
        Point point = this.getCellAt(mouseEvent.getPoint());
        if (point != null && this.needToolTip(point.y, point.x, mouseEvent) && (rectangle = this.getCellRect(mouseEvent.getPoint())) != null) {
            return rectangle.getLocation();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean needToolTip(int n2, int n3, MouseEvent mouseEvent) {
        int n4;
        String string;
        Property property = this.\u0147(n2);
        if (property == null) {
            return false;
        }
        if (n3 == 1) {
            string = super.getToolTipText(mouseEvent);
            if (string != null) return true;
            string = ObjectConverterManager.toString(property.getValue(), property.getType(), property.getConverterContext());
        } else {
            string = property.getDisplayName();
        }
        if (string == null) return false;
        if (string.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (this.convertColumnIndexToModel(n3) == 0) {
            int n5 = property.isCategoryRow() ? SwingUtilities.computeStringWidth(this.getGraphics().getFontMetrics(), string) : SwingUtilities.computeStringWidth(this.getGraphics().getFontMetrics(), string);
            int n6 = property.getLevel() * this.getIndent() + 1;
            int n7 = this.getCellRect((int)n2, (int)n3, (boolean)true).width - n6 - this.getIndent() - 4 - 1;
            if (n5 <= n7) return bl;
            return true;
        }
        int n8 = SwingUtilities.computeStringWidth(this.getGraphics().getFontMetrics(), string);
        if (n8 <= (n4 = this.getCellRect((int)n2, (int)n3, (boolean)true).width - 3)) return bl;
        return true;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = this.getCellAt(mouseEvent.getPoint());
        if (point != null && this.needToolTip(point.y, point.x, mouseEvent)) {
            Property property = this.\u0147(point.y);
            if (point.x == 1) {
                String string = super.getToolTipText(mouseEvent);
                if (string == null) {
                    string = ObjectConverterManager.toString(property.getValue(), property.getType(), property.getConverterContext());
                }
                return "<HTML>" + HtmlUtils.formatHtmlSubString(string) + "</HTML>";
            }
            return property.getDisplayName();
        }
        return null;
    }

    protected void resizeColumn(int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(this.getWidth() - n2);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(0);
        tableColumn2.setPreferredWidth(n2);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n2, int n3) {
        Component component = super.prepareRenderer(tableCellRenderer, n2, n3);
        if (!this.isEnableIgnored()) {
            Property property = this.\u0147(n2);
            int n4 = this.getShowNonEditable();
            boolean bl = true;
            if (this.convertColumnIndexToModel(n3) == 0) {
                if ((n4 & 1) != 0 && !property.isEditable()) {
                    bl = false;
                }
            } else if (n3 == 1 && (n4 & 2) != 0 && !property.isEditable()) {
                bl = false;
            }
            if (!this.isEnabled()) {
                bl = false;
            }
            if (!bl) {
                JideSwingUtilities.setEnabledRecursively(component, false);
            }
        }
        return component;
    }

    @Override
    void \u0101(TableCellRenderer tableCellRenderer, int n2, int n3, Component component, boolean bl) {
        Property property;
        super.\u0101(tableCellRenderer, n2, n3, component, bl);
        if (this.convertColumnIndexToModel(n3) == 0) {
            Property property2;
            if ((this.getShowNonEditable() & 1) != 0 && !(property2 = this.\u0147(n2)).isEditable()) {
                component.setEnabled(true);
            }
        } else if (n3 == 1 && (this.getShowNonEditable() & 2) != 0 && !(property = this.\u0147(n2)).isEditable()) {
            component.setEnabled(true);
        }
        if (tableCellRenderer instanceof PropertyTableCellRenderer) {
            ((PropertyTableCellRenderer)tableCellRenderer).releaseCellRenderer();
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n2, int n3) {
        Property property = this.\u0147(n2);
        int n4 = this.convertColumnIndexToModel(n3);
        if (n4 == 0) {
            if (this.\u1e33 instanceof PropertyTableCellRenderer) {
                TableCellRenderer tableCellRenderer = this.getActualCellRenderer(n2, n3);
                ((PropertyTableCellRenderer)this.\u1e33).setActualCellRenderer(tableCellRenderer);
            }
            return this.\u1e33;
        }
        if (n4 == 1) {
            if (property == null) {
                return super.getCellRenderer(n2, n3);
            }
            if (property.isCategoryRow()) {
                return this.\u1e33;
            }
            TableCellRenderer tableCellRenderer = property.getTableCellRenderer(n4);
            PropertyTableModel propertyTableModel = this.getPropertyTableModel();
            Class<?> clazz = property.getType();
            EditorContext editorContext = property.getEditorContext();
            ConverterContext converterContext = property.getConverterContext();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getDefaultCellRenderer();
            }
            if (tableCellRenderer == null && propertyTableModel != null) {
                int n5 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, propertyTableModel);
                clazz = propertyTableModel.getCellClassAt(n5, n4);
                editorContext = propertyTableModel.getEditorContextAt(n5, n4);
                converterContext = propertyTableModel.getConverterContextAt(n5, n4);
                tableCellRenderer = CellRendererManager.getRenderer(clazz, editorContext);
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getActualCellRenderer(n2, n3);
            }
            if (tableCellRenderer instanceof ConverterContextSupport) {
                ((ConverterContextSupport)((Object)tableCellRenderer)).setType(clazz);
                ((ConverterContextSupport)((Object)tableCellRenderer)).setConverterContext(converterContext);
            }
            if (tableCellRenderer instanceof EditorContextSupport) {
                ((EditorContextSupport)((Object)tableCellRenderer)).setEditorContext(editorContext);
            }
            if (tableCellRenderer instanceof H) {
                ((H)tableCellRenderer).\u010b(n2);
                ((H)tableCellRenderer).\u010a(n3);
                ((H)tableCellRenderer).\u0101((CellEditorValueProvider)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), CellEditorValueProvider.class)));
            }
            return tableCellRenderer;
        }
        return super.getCellRenderer(n2, n3);
    }

    @Override
    public TableCellEditor getCellEditor(int n2, int n3) {
        int n4 = this.convertColumnIndexToModel(n3);
        if (n4 == 0) {
            return (TableCellEditor)CellEditorManager.getEditor(String.class);
        }
        if (n4 == 1) {
            Object object;
            Property property = this.\u0147(n2);
            if (property == null) {
                return super.getCellEditor(n2, n3);
            }
            if (!property.isEditable()) {
                if (property.getEditorContext() == BooleanCheckBoxCellEditor.CONTEXT) {
                    return null;
                }
                TextFieldCellEditor textFieldCellEditor = new TextFieldCellEditor(property.getType());
                textFieldCellEditor.setType(property.getType());
                textFieldCellEditor.setConverterContext(property.getConverterContext());
                textFieldCellEditor.setEditorContext(property.getEditorContext());
                return textFieldCellEditor;
            }
            TableCellEditor tableCellEditor = null;
            EditorContext editorContext = property.getEditorContext();
            Class<?> clazz = property.getType();
            ConverterContext converterContext = property.getConverterContext();
            if (EditorContext.DEFAULT_CONTEXT_DYNAMIC_VALUE.equals(editorContext) && (object = (CellEditorValueProvider)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), CellEditorValueProvider.class))) != null) {
                tableCellEditor = new ListComboBoxCellEditor(object.getPossibleValues(n2, n3), property.getType(), (CellEditorValueProvider)object, n2, n3){
                    private static final long \u0539 = 6796931878361962037L;
                    final /* synthetic */ CellEditorValueProvider \u0538;
                    final /* synthetic */ int \u0536;
                    final /* synthetic */ int \u0537;
                    {
                        this.\u0538 = cellEditorValueProvider;
                        this.\u0536 = n2;
                        this.\u0537 = n3;
                        super(objectArray, clazz);
                    }

                    @Override
                    protected ListExComboBox createListComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
                        ListExComboBox listExComboBox = new ListExComboBox(comboBoxModel, clazz);
                        listExComboBox.setConverter(this.\u0538.getConverter(this.\u0536, this.\u0537));
                        listExComboBox.setEditable(false);
                        return listExComboBox;
                    }
                };
            }
            if (tableCellEditor == null) {
                tableCellEditor = (TableCellEditor)property.getCellEditor(n4);
            }
            object = this.getPropertyTableModel();
            if (tableCellEditor == null && object != null) {
                int n5 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, (TableModel)object);
                clazz = ((PropertyTableModel)object).getCellClassAt(n5, n4);
                editorContext = ((PropertyTableModel)object).getEditorContextAt(n5, n4);
                converterContext = ((PropertyTableModel)object).getConverterContextAt(n5, n4);
                tableCellEditor = (TableCellEditor)CellEditorManager.getEditor(clazz, editorContext);
            }
            if (tableCellEditor == null) {
                tableCellEditor = super.getCellEditor(n2, n3);
            }
            if (tableCellEditor instanceof ConverterContextSupport) {
                ((ConverterContextSupport)((Object)tableCellEditor)).setType(clazz);
                ((ConverterContextSupport)((Object)tableCellEditor)).setConverterContext(converterContext);
            }
            if (tableCellEditor instanceof EditorContextSupport) {
                ((EditorContextSupport)((Object)tableCellEditor)).setEditorContext(editorContext);
            }
            return tableCellEditor;
        }
        return super.getCellEditor(n2, n3);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n2, int n3) {
        Component component = super.prepareEditor(tableCellEditor, n2, n3);
        Property property = this.\u0147(n2);
        if (!property.isEditable() && component instanceof JTextField) {
            ((JTextField)component).setEditable(false);
            if ((this.getShowNonEditable() & 2) != 0) {
                component.setForeground(UIDefaultsLookup.getColor("TextField.inactiveForeground"));
            }
        }
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(this);
        return component;
    }

    public int getShowNonEditable() {
        return this.\u1e31;
    }

    public void setShowNonEditable(int n2) {
        int n3 = this.\u1e31;
        if (n3 != n2) {
            this.\u1e31 = n2;
            this.firePropertyChange("showNonEditable", n3, n2);
        }
    }

    public TableCellRenderer getMarginRenderer() {
        return this.\u1e32;
    }

    public void setMarginRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.\u1e32;
        if (tableCellRenderer2 != tableCellRenderer) {
            this.\u1e32 = tableCellRenderer;
            this.repaint();
            this.firePropertyChange("marginRenderer", tableCellRenderer2, tableCellRenderer);
        }
    }

    public boolean isHideMargin() {
        return this.\u1e34;
    }

    public void setHideMargin(boolean bl) {
        this.\u1e34 = bl;
    }

    @Override
    public Rectangle getEditorCellRect(int n2, int n3) {
        Rectangle rectangle = super.getEditorCellRect(n2, n3);
        if (n3 == 0) {
            int n4 = 0;
            Row row = this.getRowAt(n2);
            if (row != null) {
                n4 = row.getLevel() * 16;
                n4 += (this.isHideMargin() ? 0 : 16) + 0;
            }
            rectangle.x += n4;
            rectangle.width -= n4;
        }
        return rectangle;
    }
}

