/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveTable;
import com.jidesoft.grid.NavigableModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class NavigableTable
extends ContextSensitiveTable {
    private static final String \u119a = "NavigableTableUI";
    private KeyStroke \u119b = null;

    public NavigableTable() {
    }

    public NavigableTable(int n2, int n3) {
        super(n2, n3);
    }

    public NavigableTable(TableModel tableModel) {
        super(tableModel);
    }

    public NavigableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    public NavigableTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
    }

    public NavigableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public NavigableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public TableModel getNavigableModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof NavigableModel) {
            return tableModel;
        }
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, NavigableModel.class);
        if (tableModel2 != null) {
            return tableModel2;
        }
        return tableModel;
    }

    public TableModel getNextNavigableModel(TableModel tableModel) {
        if (tableModel instanceof TableModelWrapper) {
            return TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel)).getActualModel(), NavigableModel.class);
        }
        return null;
    }

    public boolean isCellNavigable(int n2, int n3) {
        if (n3 < 0 || n3 >= this.getColumnModel().getColumnCount()) {
            return true;
        }
        int n4 = this.convertColumnIndexToModel(n3);
        TableModel tableModel = this.getNavigableModel();
        while (tableModel != null) {
            if (tableModel instanceof NavigableModel && ((NavigableModel)((Object)tableModel)).isNavigationOn()) {
                int n5 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, tableModel);
                int n6 = TableModelWrapperUtils.getActualColumnAt(this.getModel(), n4, tableModel);
                if (n5 == -1 || n6 == -1) break;
                boolean bl = ((NavigableModel)((Object)tableModel)).isNavigableAt(n5, n6);
                if (!bl) {
                    return false;
                }
            }
            tableModel = this.getNextNavigableModel(tableModel);
        }
        return true;
    }

    protected boolean isNavigationKey(KeyStroke keyStroke) {
        return keyStroke == null || keyStroke.getKeyCode() == 9 || keyStroke.getKeyCode() == 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl) {
        try {
            if (bl && this.isNavigationKey(keyStroke)) {
                this.\u119b = keyStroke;
            }
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n2, bl);
            return bl2;
        }
        finally {
            this.\u119b = null;
        }
    }

    @Override
    public void changeSelection(int n2, int n3, boolean bl, boolean bl2) {
        if (!this.isCellNavigable(n2, n3)) {
            this.scrollRectToVisible(this.getCellRect(n2, n3, true));
            int n4 = this.getSelectedRow();
            int n5 = this.getSelectedColumn();
            int n6 = n2;
            int n7 = n3;
            int n8 = this.getRowCount();
            int n9 = this.getColumnCount();
            int[] nArray = null;
            if (this.isNavigationKey(this.\u119b) && this.\u119b != null) {
                InputMap inputMap = this.getInputMap(1);
                Object object = inputMap.get(this.\u119b);
                if ("selectNextColumnCell".equals(object)) {
                    nArray = this.findNextNavigableCell(n2, n3, n4, n5, n8, n9);
                } else if ("selectPreviousColumnCell".equals(object)) {
                    nArray = this.findPreviousNavigableCell(n2, n3, n4, n5, n8, n9);
                } else if ("selectNextRowCell".equals(object)) {
                    nArray = this.findNextNavigableCellVertically(n2, n3, n4, n5, n8, n9);
                } else if ("selectPreviousRowCell".equals(object)) {
                    nArray = this.findPreviousNavigableCellVertically(n2, n3, n4, n5, n8, n9);
                } else if ("selectNextColumn".equals(object) || "selectNextColumnExtendSelection".equals(object)) {
                    if (bl2) {
                        --n7;
                    }
                    nArray = this.findNextNavigableCellInRow(n2, n3, n9);
                } else if ("selectPreviousColumn".equals(object) || "selectPreviousColumnExtendSelection".equals(object)) {
                    if (bl2) {
                        ++n7;
                    }
                    nArray = this.findPreviousNavigableCellInRow(n2, n3);
                } else if ("selectNextRow".equals(object) || "selectNextRowExtendSelection".equals(object)) {
                    if (bl2) {
                        --n6;
                    }
                    nArray = this.findNextNavigableCellInColumn(n2, n3, n8);
                } else if ("selectPreviousRow".equals(object) || "selectPreviousRowExtendSelection".equals(object)) {
                    if (bl2) {
                        ++n6;
                    }
                    nArray = this.findPreviousNavigableCellInColumn(n2, n3);
                } else if ("selectFirstColumn".equals(object)) {
                    nArray = this.findNextNavigableCellInRow(n2, n3, n9);
                } else if ("selectFirstRow".equals(object)) {
                    nArray = this.findNextNavigableCellInColumn(n2, n3, n8);
                } else if ("selectLastColumn".equals(object)) {
                    nArray = this.findPreviousNavigableCellInRow(n2, n3);
                } else if ("selectLastRow".equals(object)) {
                    nArray = this.findPreviousNavigableCellInColumn(n2, n3);
                } else if ("scrollUpChangeSelection".equals(object)) {
                    nArray = this.findPreviousNavigableCellInColumn(n2, n3);
                } else if ("scrollLeftChangeSelection".equals(object)) {
                    nArray = this.findNextNavigableCellInRow(n2, n3, n9);
                } else if ("scrollDownChangeSelection".equals(object)) {
                    nArray = this.findNextNavigableCellInColumn(n2, n3, n8);
                } else if ("scrollRightChangeSelection".equals(object)) {
                    nArray = this.findPreviousNavigableCellInRow(n2, n3);
                }
                if (nArray == null && !bl2) {
                    nArray = new int[]{n4, n5};
                }
            }
            if (nArray != null) {
                n6 = nArray[0];
                n7 = nArray[1];
            }
            super.changeSelection(n6, n7, bl, bl2);
        } else {
            super.changeSelection(n2, n3, bl, bl2);
        }
    }

    protected int[] findNextNavigableCell(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 * n7;
        do {
            if (++n3 >= n7) {
                n3 = 0;
                if (++n2 >= n6) {
                    n2 = 0;
                }
            }
            if (n2 == n4 && n3 == n5) {
                return null;
            }
            if (!this.isCellNavigable(n2, n3)) continue;
            return new int[]{n2, n3};
        } while (--n8 > 0);
        return null;
    }

    protected int[] findNextNavigableCellVertically(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 * n7;
        do {
            if (++n2 >= n6) {
                n2 = 0;
                if (++n3 >= n7) {
                    n3 = 0;
                }
            }
            if (n3 == n5 && n2 == n4) {
                return null;
            }
            if (!this.isCellNavigable(n2, n3)) continue;
            return new int[]{n2, n3};
        } while (--n8 > 0);
        return null;
    }

    protected int[] findPreviousNavigableCell(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 * n7;
        do {
            if (--n3 < 0) {
                n3 = n7 - 1;
                if (--n2 < 0) {
                    n2 = n6 - 1;
                }
            }
            if (n2 == n4 && n3 == n5) {
                return null;
            }
            if (!this.isCellNavigable(n2, n3)) continue;
            return new int[]{n2, n3};
        } while (--n8 > 0);
        return null;
    }

    protected int[] findPreviousNavigableCellVertically(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 * n7;
        do {
            if (--n2 < 0) {
                n2 = n6 - 1;
                if (--n3 < 0) {
                    n3 = n7 - 1;
                }
            }
            if (n3 == n5 && n2 == n4) {
                return null;
            }
            if (!this.isCellNavigable(n2, n3)) continue;
            return new int[]{n2, n3};
        } while (--n8 > 0);
        return null;
    }

    protected int[] findNextNavigableCellInRow(int n2, int n3, int n4) {
        do {
            if (++n3 < n4) continue;
            return null;
        } while (!this.isCellNavigable(n2, n3));
        return new int[]{n2, n3};
    }

    protected int[] findPreviousNavigableCellInRow(int n2, int n3) {
        do {
            if (--n3 >= 0) continue;
            return null;
        } while (!this.isCellNavigable(n2, n3));
        return new int[]{n2, n3};
    }

    protected int[] findNextNavigableCellInColumn(int n2, int n3, int n4) {
        do {
            if (++n2 < n4) continue;
            return null;
        } while (!this.isCellNavigable(n2, n3));
        return new int[]{n2, n3};
    }

    protected int[] findPreviousNavigableCellInColumn(int n2, int n3) {
        do {
            if (--n2 >= 0) continue;
            return null;
        } while (!this.isCellNavigable(n2, n3));
        return new int[]{n2, n3};
    }

    protected int[] findNearestNavigableCellInRow(int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray;
        if (n3 > n5) {
            nArray = this.findPreviousNavigableCellInRow(n2, n3);
            if (nArray != null && nArray[0] == n4 && nArray[1] == n5) {
                nArray = this.findPreviousNavigableCellInRow(n4, n5);
            }
            if (nArray == null) {
                nArray = this.findNextNavigableCellInRow(n2, n3, n7);
            }
        } else {
            nArray = this.findNextNavigableCellInRow(n2, n3, n7);
            if (nArray != null && nArray[0] == n4 && nArray[1] == n5) {
                nArray = this.findNextNavigableCellInRow(n4, n5, n7);
            }
            if (nArray == null) {
                nArray = this.findPreviousNavigableCellInRow(n2, n3);
            }
        }
        return nArray;
    }

    protected int[] findNearestNavigableCellInColumn(int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray;
        if (n3 > n5) {
            nArray = this.findPreviousNavigableCellInColumn(n3, n3);
            if (nArray != null && nArray[0] == n5 && nArray[1] == n5) {
                nArray = this.findPreviousNavigableCellInColumn(n5, n5);
            }
            if (nArray == null) {
                nArray = this.findNextNavigableCellInColumn(n3, n3, n6);
            }
        } else {
            nArray = this.findNextNavigableCellInColumn(n3, n3, n6);
            if (nArray != null && nArray[0] == n5 && nArray[1] == n5) {
                nArray = this.findNextNavigableCellInColumn(n5, n5, n6);
            }
            if (nArray == null) {
                nArray = this.findPreviousNavigableCellInColumn(n3, n3);
            }
        }
        return nArray;
    }
}

