/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;

public class ColorCellRenderer
extends ContextSensitiveCellRenderer {
    private boolean \u0556 = true;
    private boolean \u0555 = true;
    private boolean \u0554 = false;
    public static final String PROPERTY_COLOR_VALUE_VISIBLE = "colorValueVisible";
    public static final String PROPERTY_COLOR_ICON_VISIBLE = "colorIconVisible";

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
        if (component instanceof JLabel) {
            ColorIcon colorIcon = new ColorIcon();
            if (object instanceof Color) {
                colorIcon.setColor((Color)object);
            }
            if (this.isColorIconVisible()) {
                ((JLabel)component).setIcon(colorIcon);
            } else {
                ((JLabel)component).setIcon(null);
            }
            ((JLabel)component).setIconTextGap(8);
            if (!this.isColorValueVisible()) {
                ((JLabel)component).setText("");
            }
        }
        this.putClientProperty("AbstractComboBox.isTableCellRenderer", this);
        return this;
    }

    public boolean isColorValueVisible() {
        return this.\u0556;
    }

    public void setColorValueVisible(boolean bl) {
        boolean bl2 = this.\u0556;
        if (bl2 != bl) {
            this.\u0556 = bl;
            this.firePropertyChange(PROPERTY_COLOR_VALUE_VISIBLE, bl2, bl);
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isColorIconVisible() {
        return this.\u0555;
    }

    public void setColorIconVisible(boolean bl) {
        boolean bl2 = this.\u0555;
        if (bl2 != bl) {
            this.\u0555 = bl;
            this.firePropertyChange(PROPERTY_COLOR_ICON_VISIBLE, bl2, bl);
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isCrossBackGroundStyle() {
        return this.\u0554;
    }

    public void setCrossBackGroundStyle(boolean bl) {
        if (this.\u0554 != bl) {
            this.\u0554 = bl;
            this.repaint();
        }
    }

    public class ColorIcon
    implements Icon {
        private int \u0102 = 1;
        private static final double \u0103 = 1.618;
        private Color \u0104;

        public Color getColor() {
            return this.\u0104;
        }

        public void setColor(Color color) {
            this.\u0104 = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            int n4 = component.getHeight();
            this.\u0102 = 2;
            if (!ColorCellRenderer.this.isColorIconVisible()) {
                return;
            }
            int n5 = ColorCellRenderer.this.isColorValueVisible() ? (int)((double)n4 * 1.618) : component.getWidth();
            Rectangle rectangle = new Rectangle(this.\u0102, this.\u0102, n5 - 2 * this.\u0102, n4 - 2 * this.\u0102 - (component.getHeight() - n4 + 1) % 2);
            if (ColorCellRenderer.this.isCrossBackGroundStyle()) {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
            } else {
                graphics.setColor(new Color(204, 204, 204));
                int n6 = rectangle.x + rectangle.width;
                int n7 = rectangle.y + rectangle.height;
                int n8 = 4;
                int n9 = 4;
                boolean bl = false;
                for (int i2 = rectangle.y + 1; i2 <= n7; i2 += n9) {
                    int n10 = bl ? rectangle.x + 1 : rectangle.x + 1 + n8;
                    boolean bl2 = bl = !bl;
                    while (n10 <= n6) {
                        graphics.fillRect(n10, i2, Math.min(n8, n6 - n10 + 1), Math.min(n9, n7 - i2 + 1));
                        n10 += 2 * n8;
                    }
                }
            }
            if (this.getColor() != null) {
                graphics.setColor(this.getColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics.setColor(Color.gray);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        @Override
        public int getIconWidth() {
            return (int)((double)this.getIconHeight() * 1.618);
        }

        @Override
        public int getIconHeight() {
            return ColorCellRenderer.this.getHeight() - 4;
        }
    }
}

