/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Orientation;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BulletIntervalMarker
implements Drawable {
    private Bullet \u01b4;
    private double \u01b8;
    private double \u01b7;
    private Paint \u01b6 = Color.GRAY;
    private double \u01b5 = 1.0;

    public BulletIntervalMarker(Bullet bullet, double d2, double d3) {
        this(bullet, Color.GRAY, d2, d3);
    }

    public BulletIntervalMarker(Bullet bullet, Paint paint, double d2, double d3) {
        this.\u01b4 = bullet;
        this.setFill(paint);
        this.\u01b8 = d2;
        this.\u01b7 = d3;
    }

    public void setInterval(double d2, double d3) {
        if (d3 < d2) {
            throw new IllegalArgumentException(String.format("The from value (%f) should be less than the to value (%f)", d2, d3));
        }
        this.\u01b8 = d2;
        this.\u01b7 = d3;
    }

    public double getFrom() {
        return this.\u01b8;
    }

    public double getTo() {
        return this.\u01b7;
    }

    public double getBreadthProportion() {
        return this.\u01b5;
    }

    public void setBreadthProportion(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("The breadth proportion should be a value in the range [0,1]");
        }
        this.\u01b5 = d2;
    }

    public Paint getFill() {
        return this.\u01b6;
    }

    public void setFill(Paint paint) {
        this.\u01b6 = paint;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BulletAxis bulletAxis = this.\u01b4.getAxis();
        Point2D point2D = this.\u01b4.calculatePixelPoint2D(bulletAxis, this.\u01b8);
        Point2D point2D2 = this.\u01b4.calculatePixelPoint2D(bulletAxis, this.\u01b7);
        if (point2D != null && point2D2 != null) {
            double d2;
            double d3;
            double d4 = this.\u01b5 * this.\u01b4.getBulletBreadth();
            Orientation orientation = this.\u01b4.getOrientation();
            double d5 = 0.0;
            double d6 = 0.0;
            if (orientation == Orientation.horizontal) {
                d3 = point2D.getX();
                d2 = point2D.getY() - d4 / 2.0;
                if (point2D2.getX() != point2D.getX()) {
                    d5 = 1.0 + point2D2.getX() - point2D.getX();
                }
                if (d4 > 0.0) {
                    d6 = (int)Math.ceil(d4);
                }
            } else {
                d3 = point2D.getX() - d4 / 2.0;
                d2 = point2D2.getY();
                if (d4 > 0.0) {
                    d5 = (int)Math.ceil(d4);
                }
                if (point2D.getY() != point2D2.getY()) {
                    d6 = 1.0 + point2D.getY() - point2D2.getY();
                }
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d2, d5, d6);
            graphics2D.setPaint(this.\u01b6);
            graphics2D.fill(double_);
        }
        graphics2D.dispose();
    }
}

