/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarginSupport;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.editor.margin.DefaultCodeFoldingPainter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.event.MouseInputListener;

public class CodeFoldingMargin
extends AbstractMargin
implements FoldingSpanListener,
MouseInputListener {
    private transient FoldingSpan \u0120;
    private transient ArrayList<FoldingSpan> \u0121;
    protected CodeFoldingPainter _codeFoldingPainter;

    public CodeFoldingMargin() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public CodeFoldingMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    protected void installListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().addFoldingSpanListener(this);
    }

    @Override
    protected void uninstallListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().removeFoldingSpanListener(this);
    }

    @Override
    public void paintMargin(Graphics graphics) {
        if (this.getCodeEditor() == null) {
            return;
        }
        CodeEditor codeEditor = this.getCodeEditor();
        if (codeEditor.getDocument() instanceof LazyLoadDocument) {
            FoldingSpan[] foldingSpanArray;
            int n2 = codeEditor.getPainter().getLineHeight();
            Rectangle rectangle = codeEditor.getVisibleRect();
            int n3 = codeEditor.xyToOffset(rectangle.x, rectangle.y);
            int n4 = codeEditor.xyToOffset(rectangle.width, rectangle.height);
            for (FoldingSpan foldingSpan : foldingSpanArray = codeEditor.getFoldingModel().getFoldingSpans()) {
                int n5 = foldingSpan.getStartOffset();
                int n6 = foldingSpan.getEndOffset();
                if (!(n5 >= n3 && n5 <= n4 || n6 >= n3 && n6 < n4) && (n5 >= n3 || n6 <= n4)) continue;
                this.paintFolding(graphics, foldingSpan, n2);
            }
        } else {
            FoldingSpan[] foldingSpanArray;
            int n7 = this.getCodeEditor().getPainter().getLineHeight();
            for (FoldingSpan foldingSpan : foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans()) {
                this.paintFolding(graphics, foldingSpan, n7);
            }
        }
    }

    @Override
    public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
        if (!foldingSpanEvent.isAdjusting()) {
            this.repaint();
        }
    }

    public CodeFoldingPainter getCodeFoldingPainter() {
        if (this._codeFoldingPainter == null) {
            this._codeFoldingPainter = new DefaultCodeFoldingPainter();
        }
        return this._codeFoldingPainter;
    }

    public void setCodeFoldingPainter(CodeFoldingPainter codeFoldingPainter) {
        this._codeFoldingPainter = codeFoldingPainter;
        this.repaint();
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
        this.getCodeFoldingPainter().paintBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    @Override
    public int getPreferredWidth() {
        return this.getCodeFoldingPainter().getPreferredWidth();
    }

    protected ArrayList<FoldingSpan> getFoldingSpansAt(Point point) {
        ArrayList<FoldingSpan> arrayList = new ArrayList<FoldingSpan>();
        if (this.getCodeEditor() == null) {
            return arrayList;
        }
        int n2 = this.getCodeEditor().getFirstLine();
        int n3 = this.getCodeEditor().getPainter().getLineHeight();
        int n4 = point.y / n3;
        this.getFoldingSpans(arrayList, n2 + n4);
        return arrayList;
    }

    protected void getFoldingSpans(ArrayList<FoldingSpan> arrayList, int n2) {
        FoldingSpan[] foldingSpanArray;
        for (FoldingSpan foldingSpan : foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans()) {
            int n3 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
            int n4 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
            if (n4 < 0) continue;
            int n5 = this.getCodeEditor().modelToViewLine(n3);
            int n6 = this.getCodeEditor().modelToViewLine(n4);
            if (n5 < 0) {
                n5 = n6;
            } else if (n6 < 0 || n6 < n5) {
                n6 = n5;
            }
            if (n2 != n5 && n2 != n6) continue;
            arrayList.add(foldingSpan);
        }
    }

    protected boolean isMixedSpansAt(Point point) {
        return this.isMixedSpans(this.getFoldingSpansAt(point));
    }

    protected boolean isMixedSpans(ArrayList<FoldingSpan> arrayList) {
        if (arrayList.size() > 1) {
            boolean bl = false;
            boolean bl2 = false;
            for (FoldingSpan foldingSpan : arrayList) {
                if (foldingSpan.isExpanded()) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
            return bl2 && bl;
        }
        return false;
    }

    protected void paintFolding(Graphics graphics, FoldingSpan foldingSpan, int n2) {
        int n3;
        if (this.getCodeEditor() == null) {
            return;
        }
        boolean bl = false;
        if (this.\u0121 != null && this.\u0121.size() > 1) {
            bl = this.isMixedSpans(this.\u0121);
            for (FoldingSpan foldingSpan2 : this.\u0121) {
                if (foldingSpan2.isExpanded() || foldingSpan != foldingSpan2) continue;
                this.\u0120 = foldingSpan2;
                break;
            }
        }
        int n4 = this.getCodeEditor().getFirstLine();
        int n5 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
        int n6 = n3 = this.\u0120 == foldingSpan ? 2 : 0;
        if (!foldingSpan.isExpanded()) {
            n5 = this.getCodeEditor().modelToViewLine(n5) + 1;
            this.getCodeFoldingPainter().paintCollapsedFolding(this, graphics, foldingSpan, new Rectangle(0, (n5 - n4 - 1) * n2 + 1, this.getWidth(), n2), n3);
        } else {
            int n7 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
            if (n7 < 0) {
                return;
            }
            if (n5 != n7) {
                if (bl && this.\u0121.contains(foldingSpan)) {
                    return;
                }
                n5 = this.getCodeEditor().modelToViewLine(n5) + 1;
                if (n5 == (n7 = this.getCodeEditor().modelToViewLine(n7) + 1)) {
                    return;
                }
                int n8 = this.getCodeFoldingPainter().paintFoldingStart(this, graphics, foldingSpan, new Rectangle(0, (n5 - n4 - 1) * n2 + 1, this.getWidth(), n2), n3);
                int n9 = this.getCodeFoldingPainter().paintFoldingEnd(this, graphics, foldingSpan, new Rectangle(0, (n7 - n4 - 1) * n2 + 1, this.getWidth(), n2), n3);
                this.getCodeFoldingPainter().paintFoldingLine(this, graphics, foldingSpan, new Rectangle(0, n8, this.getWidth(), n9 - n8), n3);
            } else {
                n5 = this.getCodeEditor().modelToViewLine(n5) + 1;
                this.getCodeFoldingPainter().paintExpandedFolding(this, graphics, foldingSpan, new Rectangle(0, (n5 - n4 - 1) * n2 + 1, this.getWidth(), n2), n3);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getCodeEditor() == null) {
            return;
        }
        if (this.isMixedSpansAt(mouseEvent.getPoint())) {
            ArrayList<FoldingSpan> arrayList = this.getFoldingSpansAt(mouseEvent.getPoint());
            for (FoldingSpan foldingSpan : arrayList) {
                if (foldingSpan.isExpanded()) continue;
                this.getCodeEditor().getFoldingModel().expandFoldingSpan(foldingSpan);
                break;
            }
        } else {
            HitInfo hitInfo = this.getSpanInfo(mouseEvent.getPoint());
            if (hitInfo != null) {
                if (hitInfo.\u0103.isExpanded() && (hitInfo.\u0101 == 0 || hitInfo.\u0101 == 1)) {
                    this.getCodeEditor().getFoldingModel().collapseFoldingSpan(hitInfo.\u0103);
                } else if (!(hitInfo.\u0103.isExpanded() || hitInfo.\u0101 != 0 && hitInfo.\u0101 != 1)) {
                    this.getCodeEditor().getFoldingModel().expandFoldingSpan(hitInfo.\u0103);
                }
            }
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.\u0120 != null) {
            this.\u0120 = null;
            this.\u0121 = null;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        ArrayList<FoldingSpan> arrayList = this.getFoldingSpansAt(mouseEvent.getPoint());
        this.\u0121 = arrayList;
        if (!arrayList.isEmpty() && this.\u0120 != arrayList.get(0)) {
            this.\u0120 = arrayList.get(0);
            this.repaint();
        } else if (arrayList.isEmpty() && this.\u0120 != null) {
            this.\u0120 = null;
            this.\u0121 = null;
            this.repaint();
        }
    }

    protected HitInfo getSpanInfo(Point point) {
        if (this.getCodeEditor() == null) {
            return null;
        }
        int n2 = this.getCodeEditor().getFirstLine();
        int n3 = this.getCodeEditor().getPainter().getLineHeight();
        int n4 = point.y;
        int n5 = n4 / n3;
        FoldingSpan[] foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans();
        int n6 = n2 + n5;
        for (FoldingSpan foldingSpan : foldingSpanArray) {
            int n7 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
            int n8 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
            if (n8 < 0) {
                return null;
            }
            int n9 = this.getCodeEditor().modelToViewLine(n7);
            int n10 = this.getCodeEditor().modelToViewLine(n8);
            if (n9 < 0) {
                n9 = n10;
            } else if (n10 < 0 || n10 < n9) {
                n10 = n9;
            }
            if (n6 < n9 || n6 > n10) continue;
            HitInfo hitInfo = new HitInfo();
            hitInfo.\u0103 = foldingSpan;
            if (n6 == n9) {
                hitInfo.\u0101 = 0;
                return hitInfo;
            }
            if (n6 != n10) continue;
            hitInfo.\u0101 = 0;
            return hitInfo;
        }
        return null;
    }

    @Override
    public void setCodeEditor(CodeEditor codeEditor) {
        this.setMarginSupport(new CodeEditorMarginSupport(codeEditor));
        super.setCodeEditor(codeEditor);
    }

    protected static class HitInfo {
        static final int \u0104 = 0;
        static final int \u0105 = 1;
        static final int \u0102 = 2;
        FoldingSpan \u0103;
        int \u0101;

        protected HitInfo() {
        }
    }
}

