/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.SyntaxDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextUtils {
    private static final int \u0103 = 0;
    private static final int \u0101 = 1;
    private static final int \u0102 = 2;

    public static int findPreviousOpenBracket(Document document, int n2) throws BadLocationException {
        if (document.getLength() == 0) {
            return -1;
        }
        String string = document.getText(0, n2);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            switch (string.charAt(i2)) {
                case '(': 
                case '<': 
                case '[': 
                case '{': {
                    return i2;
                }
            }
        }
        return -1;
    }

    public static int findMatchingBracket(Document document, int n2) throws BadLocationException {
        if (document.getLength() == 0) {
            return -1;
        }
        if (n2 >= document.getLength()) {
            return -1;
        }
        if (document instanceof LazyLoadDocument && !((LazyLoadDocument)document).isOffsetLoaded(n2)) {
            return -1;
        }
        char c2 = '\u0000';
        if (n2 >= 0 && n2 < document.getLength()) {
            String string = document.getText(n2, 1);
            c2 = string.length() > 0 ? (char)string.charAt(0) : (char)'\u0000';
        }
        char c3 = '\u0000';
        if (n2 + 1 < document.getLength()) {
            String string = document.getText(n2 + 1, 1);
            c3 = string.length() > 0 ? (char)string.charAt(0) : (char)'\u0000';
        }
        char c4 = '\u0000';
        boolean bl = false;
        switch (c2) {
            case ')': {
                c4 = '(';
                bl = true;
                break;
            }
            case ']': {
                c4 = '[';
                bl = true;
                break;
            }
            case '}': {
                c4 = '{';
                bl = true;
            }
        }
        if (c4 == '\u0000') {
            ++n2;
            switch (c3) {
                case '(': {
                    c4 = ')';
                    bl = false;
                    break;
                }
                case '[': {
                    c4 = ']';
                    bl = false;
                    break;
                }
                case '{': {
                    c4 = '}';
                    bl = false;
                    break;
                }
                default: {
                    return -1;
                }
            }
            c2 = c3;
        }
        if (document instanceof SyntaxDocument && ((SyntaxDocument)document).isInCommentOrLiteral(n2)) {
            return -1;
        }
        if (!(document instanceof SyntaxDocument)) {
            if (bl) {
                int n3 = 1;
                String string = document.getText(0, n2);
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    char c5 = string.charAt(i2);
                    if (c5 == c2) {
                        ++n3;
                        continue;
                    }
                    if (c5 != c4 || --n3 != 0) continue;
                    return i2;
                }
            } else {
                int n4 = 1;
                int n5 = document.getLength() - ++n2;
                String string = document.getText(n2, n5);
                for (int i3 = 0; i3 < n5; ++i3) {
                    char c6 = string.charAt(i3);
                    int n6 = i3 + n2;
                    if (c6 == c2) {
                        ++n4;
                        continue;
                    }
                    if (c6 != c4 || --n4 != 0) continue;
                    return n6;
                }
            }
        } else {
            String[] stringArray = new String[]{"" + c2, "" + c4};
            int n7 = 1;
            int n8 = n2;
            if (bl) {
                while (n8 >= 0 && (n8 = ((SyntaxDocument)document).\u0101(stringArray, n8, 0, true, false, false)) >= 0 && n8 < document.getLength()) {
                    char c7 = document.getText(n8, 1).charAt(0);
                    if (c7 == c2) {
                        if (((SyntaxDocument)document).isInCommentOrLiteral(n8)) continue;
                        ++n7;
                        continue;
                    }
                    if (c7 != c4 || ((SyntaxDocument)document).isInCommentOrLiteral(n8) || --n7 != 0) continue;
                    return n8;
                }
            } else {
                while (n8 >= 0 && n8 < document.getLength() && (n8 = ((SyntaxDocument)document).\u0102(stringArray, n8 + 1, document.getLength(), true, false, false)) >= 0 && n8 < document.getLength()) {
                    char c8 = document.getText(n8, 1).charAt(0);
                    if (c8 == c2) {
                        if (((SyntaxDocument)document).isInCommentOrLiteral(n8)) continue;
                        ++n7;
                        continue;
                    }
                    if (c8 != c4 || ((SyntaxDocument)document).isInCommentOrLiteral(n8) || --n7 != 0) continue;
                    return n8;
                }
            }
        }
        return -1;
    }

    public static int findWordStart(String string, int n2, String string2) {
        return TextUtils.findWordStart(string, n2, string2, true, false);
    }

    public static int findWordStart(String string, int n2, String string2, boolean bl) {
        return TextUtils.findWordStart(string, n2, string2, bl, false);
    }

    public static int findWordStart(String string, int n2, String string2, boolean bl, boolean bl2) {
        return TextUtils.findWordStart(string, n2, string2, bl, bl2, false);
    }

    public static int findWordStart(String string, int n2, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (n2 > string.length() - 1) {
            n2 = string.length() - 1;
        }
        char c2 = string.charAt(n2);
        if (string2 == null) {
            string2 = "";
        }
        int n3 = Character.isWhitespace(c2) ? 0 : (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1 ? 1 : 2);
        block5: for (int i2 = n2; i2 >= 0; --i2) {
            c2 = string.charAt(i2);
            switch (n3) {
                case 0: {
                    if (Character.isWhitespace(c2)) continue block5;
                    if (!bl3) {
                        return i2 + 1;
                    }
                    if (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1) {
                        n3 = 1;
                        continue block5;
                    }
                    n3 = 2;
                    continue block5;
                }
                case 1: {
                    if (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1) continue block5;
                    if (Character.isWhitespace(c2) && bl2) {
                        n3 = 0;
                        bl3 = false;
                        continue block5;
                    }
                    return i2 + 1;
                }
                case 2: {
                    if (!bl && n2 != i2) {
                        return i2 + 1;
                    }
                    if (Character.isWhitespace(c2)) {
                        if (bl2) {
                            n3 = 0;
                            bl3 = false;
                            continue block5;
                        }
                        return i2 + 1;
                    }
                    if (!Character.isLetterOrDigit(c2) && string2.indexOf(c2) == -1) continue block5;
                    return i2 + 1;
                }
            }
        }
        return 0;
    }

    public static int findWordEnd(String string, int n2, String string2) {
        return TextUtils.findWordEnd(string, n2, string2, true);
    }

    public static int findWordEnd(String string, int n2, String string2, boolean bl) {
        return TextUtils.findWordEnd(string, n2, string2, bl, false);
    }

    public static int findWordEnd(String string, int n2, String string2, boolean bl, boolean bl2) {
        if (n2 > string.length() - 1) {
            n2 = string.length() - 1;
            ++n2;
        }
        if (n2 != 0) {
            --n2;
        }
        char c2 = string.charAt(n2);
        if (string2 == null) {
            string2 = "";
        }
        int n3 = Character.isWhitespace(c2) ? 0 : (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1 ? 1 : 2);
        boolean bl3 = n3 != 0;
        block5: for (int i2 = n2; i2 < string.length(); ++i2) {
            c2 = string.charAt(i2);
            switch (n3) {
                case 0: {
                    if (Character.isWhitespace(c2)) continue block5;
                    if (bl3) {
                        return i2;
                    }
                    n3 = Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1 ? 1 : 2;
                    bl3 = true;
                    continue block5;
                }
                case 1: {
                    if (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1) continue block5;
                    if (Character.isWhitespace(c2) && bl2) {
                        n3 = 0;
                        continue block5;
                    }
                    return i2;
                }
                case 2: {
                    if (!bl && i2 != n2) {
                        return i2;
                    }
                    if (Character.isWhitespace(c2)) {
                        if (bl2) {
                            n3 = 0;
                            continue block5;
                        }
                        return i2;
                    }
                    if (!Character.isLetterOrDigit(c2) && string2.indexOf(c2) == -1) continue block5;
                    return i2;
                }
            }
        }
        return string.length() - (bl3 ? 1 : 0);
    }

    public static String getLeadingWhitespace(String string) {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2 && ((c2 = string.charAt(i2)) == ' ' || c2 == '\t'); ++i2) {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String createWhiteSpace(int n2, int n3, boolean bl, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 == 0) {
            while (n2-- > 0) {
                stringBuffer.append(' ');
            }
        } else if (n2 == 1) {
            stringBuffer.append(' ');
        } else {
            int n5 = (n2 + n4 % n3) / n3;
            if (n5 != 0) {
                n2 += n4;
            }
            while (n5-- > 0) {
                if (bl) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        stringBuffer.append(' ');
                    }
                    continue;
                }
                stringBuffer.append('\t');
            }
            n5 = n2 % n3;
            while (n5-- > 0) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public static String createWhiteSpace(int n2, int n3, boolean bl) {
        return TextUtils.createWhiteSpace(n2, n3, bl, 0);
    }

    public static String getLineBreak(int n2) {
        switch (n2) {
            case 2: {
                return "\r";
            }
            case 1: {
                return "\n";
            }
        }
        return "\r\n";
    }

    public static boolean isBracket(char c2) {
        return c2 == '(' || c2 == ')' || c2 == '[' || c2 == ']' || c2 == '{' || c2 == '}';
    }
}

