/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.DocumentListenerEx;
import com.jidesoft.editor.LineBreak;
import com.jidesoft.editor.TextUtils;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.swing.DelayUndoManager;
import com.jidesoft.utils.PortingUtils;
import java.util.Locale;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SyntaxDocument
extends PlainDocument
implements LineBreak {
    protected UndoManager _undoManager;
    protected CompoundEdit _compoundEdit;
    protected int _compoundEditCount = 0;
    private int \u013b = 256;
    private static final long \u0138 = -6307295612809666540L;
    Segment \u013c = new Segment();
    Segment \u0139 = new Segment();
    Token \u013a = null;
    protected TokenMarker tokenMarker;

    public SyntaxDocument() {
        this._undoManager = new DelayUndoManager();
        this.addUndoableEditListener(new MyUndoableEditListener());
    }

    public String getLineText(int n2) throws BadLocationException {
        Element element = this.getDefaultRootElement();
        int n3 = element.getElementIndex(n2);
        int n4 = element.getElement(n3).getStartOffset();
        int n5 = element.getElement(n3).getEndOffset();
        return this.getText(n4, n5 - n4);
    }

    public int getLineNumber(int n2) {
        return this.getDefaultRootElement().getElementIndex(n2);
    }

    public void undo() {
        UndoManager undoManager = this.getUndoManager();
        if (undoManager.canUndo()) {
            undoManager.undo();
        } else {
            PortingUtils.notifyUser();
        }
    }

    public void redo() {
        UndoManager undoManager = this.getUndoManager();
        if (undoManager.canRedo()) {
            undoManager.redo();
        } else {
            PortingUtils.notifyUser();
        }
    }

    public UndoManager getUndoManager() {
        return this._undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this._undoManager = undoManager;
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        if (this.tokenMarker != null) {
            this.tokenMarker.setDocument(null);
        }
        this.tokenMarker = tokenMarker;
        if (tokenMarker == null) {
            return;
        }
        this.tokenMarker.setDocument(this);
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int n2, int n3) {
        this.\u0101(n2, n3, false, false);
    }

    void \u0101(int n2, int n3, boolean bl, boolean bl2) {
        if (this.tokenMarker == null || !this.tokenMarker.supportsMultilineTokens()) {
            return;
        }
        n3 += n2;
        Segment segment = new Segment();
        try {
            for (int i2 = n2; i2 < n3 && i2 < this.getLineCount(); ++i2) {
                int n4 = this.getLineStartOffset(i2);
                int n5 = this.getLineEndOffset(i2) - n4;
                this.getText(n4, n5, segment);
                this.tokenMarker.markTokens(segment, i2);
                if (!bl) continue;
                byte by = this.tokenMarker.getLastToken(i2);
                if (!(bl2 ? by != 3 && by != 1 : by == 3 || by == 1)) {
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean isInCommentOrLiteral(int n2) throws BadLocationException {
        TokenMarker tokenMarker = this.getTokenMarker();
        if (tokenMarker == null || n2 < 0 || n2 >= this.getLength()) {
            return false;
        }
        int n3 = this.getLineNumber(n2);
        int n4 = this.getLineStartOffset(n3);
        int n5 = this.getLineEndOffset(n3) - n4;
        if (n2 >= n4 && n2 < n4 + n5) {
            if (this.\u0139.getBeginIndex() != n4 || this.\u0139.getEndIndex() != n4 + n5 || this.\u013a == null) {
                this.getText(n4, n5, this.\u0139);
                this.\u013a = tokenMarker.markTokens(this.\u0139, n3);
            }
            Token token = this.\u013a;
            int n6 = 0;
            while (token != null && token.id != 127) {
                if ((token.id == 1 || token.id == 2 || token.id == 3 || token.id == 4) && n4 + n6 < n2 && n4 + n6 + token.length > n2 + 1) {
                    return true;
                }
                n6 += token.length;
                token = token.next;
            }
        }
        return false;
    }

    public void beginCompoundEdit() {
        if (this._compoundEdit == null) {
            this._compoundEdit = new CompoundEdit();
        }
        ++this._compoundEditCount;
    }

    public void endCompoundEdit() {
        --this._compoundEditCount;
        if (this._compoundEditCount == 0) {
            this._compoundEdit.end();
            this.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, this._compoundEdit));
            this._compoundEdit = null;
        }
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        this.\u0102(documentEvent);
        super.fireInsertUpdate(documentEvent);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        this.\u0101(documentEvent);
        super.fireRemoveUpdate(documentEvent);
    }

    void \u0102(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.insertLines(elementChange.getIndex() + 1, elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
        }
    }

    void \u0101(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.deleteLines(elementChange.getIndex() + 1, elementChange.getChildrenRemoved().length - elementChange.getChildrenAdded().length);
        }
    }

    public static int convertLineBreaks(String string, StringBuffer stringBuffer) {
        int n2 = CodeEditor.\u011f();
        int n3 = SyntaxDocument.\u0101(string, stringBuffer, TextUtils.getLineBreak(n2 != 2 ? n2 : 1), null);
        if (n3 != n2 && n3 != 2 && n3 != -1 && n3 != -2) {
            stringBuffer.replace(0, stringBuffer.length(), "");
            n3 = SyntaxDocument.\u0101(string, stringBuffer, TextUtils.getLineBreak(n3), null);
        }
        return n3;
    }

    public static int convertLineBreaks(String string, StringBuffer stringBuffer, String string2) {
        return SyntaxDocument.\u0101(string, stringBuffer, string2, null);
    }

    private static int \u0101(String string, StringBuffer stringBuffer, String string2, int[] nArray) {
        int n2 = -2;
        boolean bl = false;
        if (string == null) {
            return n2;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\n') {
                stringBuffer.append(string2);
                SyntaxDocument.\u0101(nArray, stringBuffer.length(), 1, string2.length());
                if (bl) continue;
                if (n2 == -2) {
                    n2 = 1;
                    continue;
                }
                if (n2 == 1) continue;
                n2 = -1;
                bl = true;
                continue;
            }
            if (c2 == '\r') {
                stringBuffer.append(string2);
                if (i2 < string.length() - 1 && string.charAt(i2 + 1) == '\n') {
                    ++i2;
                    SyntaxDocument.\u0101(nArray, stringBuffer.length(), 2, string2.length());
                    if (bl) continue;
                    if (n2 == -2) {
                        n2 = 0;
                        continue;
                    }
                    if (n2 == 0) continue;
                    n2 = -1;
                    bl = true;
                    continue;
                }
                if (i2 < string.length() - 2 && string.charAt(i2 + 1) == '\r' && string.charAt(i2 + 2) == '\n') {
                    i2 += 2;
                    SyntaxDocument.\u0101(nArray, stringBuffer.length(), 3, string2.length());
                    if (bl) continue;
                    if (n2 == -2) {
                        n2 = 0;
                        continue;
                    }
                    if (n2 == 0) continue;
                    n2 = -1;
                    bl = true;
                    continue;
                }
                SyntaxDocument.\u0101(nArray, stringBuffer.length(), 1, string2.length());
                if (bl) continue;
                if (n2 == -2) {
                    n2 = 2;
                    continue;
                }
                if (n2 == 2) continue;
                n2 = -1;
                bl = true;
                continue;
            }
            stringBuffer.append(c2);
        }
        return n2;
    }

    private static void \u0101(int[] nArray, int n2, int n3, int n4) {
        if (nArray == null) {
            return;
        }
        int n5 = n4 - n3;
        if (n5 == 0) {
            return;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n6 = nArray[i2];
            if (n6 < n2 + n3) continue;
            int n7 = i2;
            nArray[n7] = nArray[n7] + n5;
        }
    }

    public char charAt(int n2) throws BadLocationException {
        this.getContent().getChars(n2, 1, this.\u013c);
        return this.\u013c.first();
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        this.fireRemovingUpdate(defaultDocumentEvent);
        super.removeUpdate(defaultDocumentEvent);
    }

    protected void fireRemovingUpdate(DocumentEvent documentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != DocumentListener.class || !(objectArray[i2 + 1] instanceof DocumentListenerEx)) continue;
            ((DocumentListenerEx)objectArray[i2 + 1]).removingUpdate(documentEvent);
        }
    }

    public int getLookupBufferSize() {
        return this.\u013b;
    }

    public void setLookupBufferSize(int n2) {
        this.\u013b = n2;
    }

    public int findNext(String[] stringArray, int n2, int n3, boolean bl) {
        return this.findNext(stringArray, n2, n3, bl, false);
    }

    public int findNext(String[] stringArray, int n2, int n3, boolean bl, boolean bl2) {
        return this.\u0102(stringArray, n2, n3, bl, true, bl2);
    }

    protected boolean isWordChar(char c2) {
        return c2 == '_' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
    }

    int \u0102(String[] stringArray, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        int n4;
        if (n2 < 0 || n3 < 0 || n2 >= this.getLength() || n3 > this.getLength()) {
            return -1;
        }
        String[] stringArray2 = stringArray;
        int n5 = 0;
        if (!bl) {
            stringArray2 = new String[stringArray.length];
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                stringArray2[n4] = stringArray[n4].toLowerCase(Locale.getDefault());
                n5 = Math.max(n5, stringArray2[n4].length());
            }
        } else {
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                n5 = Math.max(n5, stringArray2[n4].length());
            }
        }
        if (n2 + n5 > n3) {
            return -1;
        }
        n4 = n2;
        int n6 = Math.min(this.getLookupBufferSize(), n3 - n4);
        while (n4 < n3) {
            String string;
            if (!bl2 && !this.isOffsetLoaded(n4 + n6 - 1)) {
                return -1;
            }
            try {
                string = this.getText(n4, n6);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            if (!bl) {
                string = string.toLowerCase(Locale.getDefault());
            }
            int n7 = -1;
            for (String string2 : stringArray2) {
                int n8 = string.indexOf(string2);
                if (n8 >= 0 && bl3) {
                    int n9;
                    do {
                        n9 = n8;
                        if (n8 > 0 && this.isWordChar(string.charAt(n8 - 1))) {
                            n9 = -1;
                        }
                        if (n8 >= 0 && n8 + string2.length() < string.length() && this.isWordChar(string.charAt(n8 + string2.length()))) {
                            n9 = -1;
                        }
                        n8 = string.indexOf(string2, n8 + 1);
                    } while (n9 < 0 && n8 >= 0);
                    n8 = n9;
                }
                if (n8 < 0) continue;
                n7 = n7 < 0 ? n8 : Math.min(n7, n8);
            }
            if (n7 >= 0) {
                return n4 + n7;
            }
            if (n4 + n6 >= n3) break;
            n6 = Math.min(this.getLookupBufferSize(), n3 - (n4 += n6 - n5 + 1));
        }
        return -1;
    }

    public int findPrevious(String[] stringArray, int n2, int n3, boolean bl) {
        return this.findPrevious(stringArray, n2, n3, bl, false);
    }

    public int findPrevious(String[] stringArray, int n2, int n3, boolean bl, boolean bl2) {
        return this.\u0101(stringArray, n2, n3, bl, true, bl2);
    }

    public boolean isOffsetLoaded(int n2) {
        return true;
    }

    public boolean isLineLoaded(int n2) {
        return true;
    }

    int \u0101(String[] stringArray, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        int n4;
        if (n2 < 0 || n3 < 0 || n2 > this.getLength() || n3 >= this.getLength()) {
            return -1;
        }
        String[] stringArray2 = stringArray;
        int n5 = 0;
        if (!bl) {
            stringArray2 = new String[stringArray.length];
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                stringArray2[n4] = stringArray[n4].toLowerCase(Locale.getDefault());
                n5 = Math.max(n5, stringArray2[n4].length());
            }
        } else {
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                n5 = Math.max(n5, stringArray2[n4].length());
            }
        }
        if (n3 + n5 > n2) {
            return -1;
        }
        n4 = Math.max(n2 - this.getLookupBufferSize(), n3);
        int n6 = Math.min(this.getLookupBufferSize(), n2 - n3);
        while (n4 >= n3) {
            String string;
            if (!bl2 && !this.isOffsetLoaded(n4)) {
                return -1;
            }
            try {
                string = this.getText(n4, n6);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            if (!bl) {
                string = string.toLowerCase(Locale.getDefault());
            }
            int n7 = -1;
            for (String string2 : stringArray2) {
                int n8 = string.lastIndexOf(string2);
                if (n8 >= 0 && bl3) {
                    int n9;
                    do {
                        n9 = n8;
                        if (n8 > 0 && this.isWordChar(string.charAt(n8 - 1))) {
                            n9 = -1;
                        }
                        if (n8 >= 0 && n8 + string2.length() < string.length() && this.isWordChar(string.charAt(n8 + string2.length()))) {
                            n9 = -1;
                        }
                        string = string.substring(0, n8);
                        n8 = string.lastIndexOf(string2);
                    } while (n9 < 0 && n8 >= 0);
                    n8 = n9;
                }
                if (n8 < 0) continue;
                n7 = n7 < 0 ? n8 : Math.max(n7, n8);
            }
            if (n7 >= 0) {
                return n4 + n7;
            }
            if (n4 == n3) break;
            n6 = Math.min(this.getLookupBufferSize(), n4 + n5 - 1);
            n4 = Math.max(n4 + n5 - 1 - this.getLookupBufferSize(), n3);
        }
        return -1;
    }

    public int getLineCount() {
        return this.getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int n2) {
        Element element = this.getDefaultRootElement();
        if (n2 >= element.getElementCount()) {
            return this.getLength() + 1;
        }
        Element element2 = element.getElement(n2);
        if (element2 == null) {
            return -1;
        }
        return element2.getStartOffset();
    }

    public int getLineEndOffset(int n2) {
        Element element;
        Element element2 = this.getDefaultRootElement();
        if (n2 >= element2.getElementCount()) {
            n2 = element2.getElementCount() - 1;
        }
        if ((element = element2.getElement(n2)) == null) {
            return -1;
        }
        return element.getEndOffset() - 1;
    }

    public int getLineLength(int n2) {
        return this.getLineEndOffset(n2) - this.getLineStartOffset(n2) + 1;
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (SyntaxDocument.this._compoundEdit != null) {
                SyntaxDocument.this._compoundEdit.addEdit(undoableEditEvent.getEdit());
            } else {
                SyntaxDocument.this.getUndoManager().undoableEditHappened(undoableEditEvent);
            }
        }
    }
}

