/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.SlidingOverFrameContainer;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class SlidingAnimator {
    private DockingManager \u010c;
    private Handler \u010d;
    private DockedFrameContainer \u010a;
    private SlidingOverFrameContainer \u0108;
    private Component \u010b;
    private SlidingOverFrameContainer.SlidingFrameConstraint \u0107;
    private int \u0109;
    private Timer \u0104;
    private boolean \u0105;
    private boolean \u0102;
    private boolean \u0103;
    private boolean \u0101;
    private JComponent \u0106;

    public SlidingAnimator(DockingManager dockingManager, Handler handler, DockedFrameContainer dockedFrameContainer, SlidingOverFrameContainer slidingOverFrameContainer, DockableFrame dockableFrame, int n2, int n3, int n4) {
        if (dockingManager == null || handler == null || dockedFrameContainer == null || slidingOverFrameContainer == null) {
            throw new IllegalArgumentException("dockingManager, handler, dockedFrameContainer, and animationLayer must be non null.");
        }
        this.\u010c = dockingManager;
        this.\u010d = handler;
        this.\u010a = dockedFrameContainer;
        this.\u0108 = slidingOverFrameContainer;
        this.\u0107 = new SlidingOverFrameContainer.SlidingFrameConstraint(this.\u0108);
        this.\u0107.frame = dockableFrame;
        this.\u0107.side = n2;
        this.\u0107.steps = n4;
        this.\u0107.currentStep = 0;
        this.\u0107.isLeftToRight = this.\u010a.getComponentOrientation().isLeftToRight();
        this.\u0107.dockingComponent = this.\u010a;
        this.\u0106 = new JPanel(){

            @Override
            public boolean contains(int n2, int n3) {
                return false;
            }
        };
        this.\u0106.setOpaque(false);
        this.\u0109 = n3;
        this.\u0105 = false;
        this.\u0101 = false;
        this.\u0102 = false;
        this.\u0103 = false;
        this.\u0104 = new Timer(this.\u0109, new TimerActionListener());
    }

    public void \u0101(int n2) {
        if (this.\u0105) {
            return;
        }
        if (this.\u0107.currentStep >= this.\u0107.steps && this.\u0107.opening) {
            return;
        }
        this.\u0107.opening = true;
        if (!this.\u010b()) {
            if (n2 == 0) {
                this.\u010d();
            }
            this.\u0104.setInitialDelay(n2);
            this.\u0104.setDelay(this.\u0109);
            this.\u0104.restart();
        }
    }

    public void \u0101(int n2, boolean bl) {
        if (this.\u0107.currentStep <= 0 && !this.\u0107.opening) {
            return;
        }
        this.\u0103 = true;
        this.\u0105 = bl;
        this.\u0107.opening = false;
        if (!this.\u010b()) {
            if (n2 == 0) {
                this.\u010d();
            }
            this.\u0104.setInitialDelay(n2);
            this.\u0104.setDelay(this.\u0109 / 2);
            this.\u0104.restart();
        }
    }

    public void \u010c() {
        this.\u0103();
        if (this.\u010d != null && !this.\u0101) {
            this.\u010d.handleOpened(this.\u0107.frame);
        }
        this.\u0101 = true;
    }

    public void \u0104() {
        this.\u0101();
        if (this.\u010d != null) {
            if (this.\u0101) {
                this.\u010d.handleHidden(this.\u0107.frame);
            } else {
                this.\u010d.handleShowingCancelled(this.\u0107.frame);
            }
        }
        this.\u0101 = false;
        this.\u0103 = false;
    }

    public void \u010a() {
        this.\u0101();
        this.\u0101 = false;
        this.\u0103 = false;
    }

    protected DockableFrame \u0101(Component component) {
        DockableFrame dockableFrame = null;
        if (component instanceof DockableFrame) {
            dockableFrame = (DockableFrame)component;
        } else if (component instanceof HeavyweightWrapper) {
            dockableFrame = (DockableFrame)((HeavyweightWrapper)component).getComponent();
        }
        return dockableFrame;
    }

    public boolean \u010b() {
        return this.\u0102;
    }

    public boolean \u0108() {
        return this.\u0103;
    }

    public boolean \u0102() {
        return this.\u010b() && this.\u0107.opening;
    }

    public Component \u0106() {
        return this.\u010b;
    }

    public DockableFrame \u0107() {
        return this.\u0107.frame;
    }

    protected void \u010d() {
        if (this.\u0107.frame != null && (this.\u0107.frame.isAutohide() || this.\u0107.frame.isAutohideShowing())) {
            if (this.\u0107.currentStep <= 0) {
                if (this.\u0107.opening) {
                    this.\u0107.frame.fireDockableFrameEvent(4009);
                    this.\u0105();
                    if (this.\u010d != null) {
                        this.\u010d.handleBeginShowing(this.\u0107.frame);
                    }
                } else {
                    this.\u0107.frame.fireDockableFrameEvent(4010);
                    this.\u0104();
                    return;
                }
            }
            if (this.\u0107.opening) {
                ++this.\u0107.currentStep;
                if (this.\u0107.currentStep > this.\u0107.steps) {
                    this.\u0107.currentStep = this.\u0107.steps;
                }
            } else {
                this.\u0101 = false;
                --this.\u0107.currentStep;
                if (this.\u0107.currentStep < 0) {
                    this.\u0107.currentStep = 0;
                }
            }
            if (this.\u010c.isAutohideShowingContentHidden()) {
                this.\u0107.frame.getContentPane().setVisible(false);
            }
            this.\u0102 = true;
            try {
                this.\u0107.frame.setAutohideShowing(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.\u010f();
            if (this.\u0107.currentStep >= this.\u0107.steps) {
                this.\u010c();
            }
        }
    }

    protected void \u0105() {
        Object object;
        this.\u0108.setVisible(true);
        this.\u010b = !SystemInfo.isJdk6u14Above() && this.\u010c.isHeavyweightComponentEnabled() && this.\u0107.frame.isSlidingAutohide() ? ((object = this.\u0107.frame.getClientProperty("HeavyweightWrapper")) instanceof HeavyweightWrapper ? (HeavyweightWrapper)object : new HeavyweightWrapper(this.\u0107.frame, true)) : this.\u0107.frame;
        if (!this.\u0107.frame.isVisible()) {
            this.\u0107.frame.setVisible(true);
        }
        this.\u0107.frame.getContext().setCurrentDockSide(this.\u0107.side);
        if (this.\u0107.frame.isSlidingAutohide()) {
            this.\u0109();
        } else {
            this.\u010e();
        }
    }

    protected void \u0109() {
        if (this.\u010b instanceof HeavyweightWrapper) {
            ((HeavyweightWrapper)this.\u010b).delegateAdd(this.\u0108, this.\u0107);
        } else {
            this.\u0108.add(this.\u010b, this.\u0107);
        }
    }

    protected void \u010e() {
        this.\u0108.add((Component)this.\u0106, this.\u0107);
        ContainerContainer containerContainer = (ContainerContainer)this.\u010a.getParent();
        this.\u010b.setSize(this.\u0107.frame.getAutohideWidth(), this.\u0107.frame.getAutohideHeight());
        switch (this.\u0107.side) {
            case 4: {
                containerContainer.setOrientation(1);
                containerContainer.insertPane(this.\u010b, "flexible", containerContainer.getPaneCount());
                break;
            }
            case 8: {
                containerContainer.setOrientation(1);
                containerContainer.insertPane(this.\u010b, "flexible", 0);
                break;
            }
            case 2: {
                containerContainer.setOrientation(0);
                containerContainer.insertPane(this.\u010b, "flexible", containerContainer.getPaneCount());
                break;
            }
            case 1: {
                containerContainer.setOrientation(0);
                containerContainer.insertPane(this.\u010b, "flexible", 0);
            }
        }
        containerContainer.doLayout();
    }

    protected void \u010f() {
        this.\u0108.validate();
        this.\u0108.doLayout();
        Window window = SwingUtilities.getWindowAncestor(this.\u0108);
        if (window != null) {
            window.validate();
        }
        if (this.\u010b != null) {
            if (this.\u0107.frame.isSlidingAutohide()) {
                Rectangle rectangle = this.\u010b.getBounds();
                this.\u0108.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                ContainerContainer containerContainer = (ContainerContainer)this.\u010a.getParent();
                switch (this.\u0107.side) {
                    case 4: {
                        containerContainer.setDividerLocation(0, containerContainer.getWidth() - containerContainer.getDividerSize() - this.\u0106.getSize().width);
                        break;
                    }
                    case 8: {
                        containerContainer.setDividerLocation(0, this.\u0106.getSize().width);
                        break;
                    }
                    case 2: {
                        containerContainer.setDividerLocation(0, containerContainer.getHeight() - containerContainer.getDividerSize() - this.\u0106.getSize().height);
                        break;
                    }
                    case 1: {
                        containerContainer.setDividerLocation(0, this.\u0106.getSize().height);
                    }
                }
                this.\u010a.getParent().invalidate();
                this.\u010a.getParent().doLayout();
                this.\u010a.getParent().repaint();
            }
        }
    }

    protected void \u0103() {
        this.\u0102 = false;
        this.\u0104.stop();
        this.\u0107.currentStep = this.\u0107.steps;
        this.\u010f();
        if (this.\u0107.opening) {
            DockableFrame dockableFrame = this.\u0101(this.\u010b);
            if (this.\u010c.isAutohideShowingContentHidden()) {
                dockableFrame.getContentPane().setVisible(true);
            }
        }
        this.\u010c.finishShowingAutohideFrame(this.\u0101(this.\u010b).getKey());
    }

    protected void \u0101() {
        this.\u0104.stop();
        this.\u0102 = false;
        this.\u0108.setVisible(false);
        if (this.\u010b != null) {
            Container container = this.\u010b.getParent();
            if (container != null) {
                if (this.\u010b instanceof HeavyweightWrapper) {
                    ((HeavyweightWrapper)this.\u010b).delegateRemove(container);
                } else {
                    JideSwingUtilities.removeFromParentWithFocusTransfer(this.\u010b);
                }
            }
            this.\u0108.remove(this.\u0106);
            this.\u010b = null;
            this.\u0107.currentStep = 0;
            this.\u0107.opening = false;
            this.\u0105 = false;
        }
        if (this.\u0107.frame != null && this.\u0107.frame.isAutohideShowing()) {
            if (this.\u010c.isAutohideShowingContentHidden()) {
                this.\u0107.frame.getContentPane().setVisible(true);
            }
            try {
                this.\u0107.frame.setAutohide(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.\u0108.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void \u0101(DockableFrame dockableFrame) {
        try {
            dockableFrame.\u0107(true);
            int n2 = dockableFrame.getContext().getCurrentDockSide();
            switch (n2) {
                case 4: 
                case 8: {
                    dockableFrame.setAutohideWidth(dockableFrame.getWidth());
                    return;
                }
                case 1: 
                case 2: {
                    dockableFrame.setAutohideHeight(dockableFrame.getHeight());
                    return;
                }
            }
            return;
        }
        finally {
            dockableFrame.\u0107(false);
        }
    }

    protected class TimerActionListener
    implements ActionListener {
        protected TimerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SlidingAnimator.this.\u010d();
        }
    }

    public static interface Handler {
        public void handleBeginShowing(DockableFrame var1);

        public void handleShowingCancelled(DockableFrame var1);

        public void handleOpened(DockableFrame var1);

        public void handleHidden(DockableFrame var1);
    }
}

