/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class BannerPanel
extends JPanel {
    private static final long \u0103 = -7191474275030489327L;
    protected String _title;
    protected String _subtitle;
    protected ImageIcon _titleIcon;
    public static final String TITLE_PROPERTY = "title";
    public static final String SUBTITLE_PROPERTY = "subTitle";
    public static final String ICON_PROPERTY = "icon";
    public static final String ICON_COMPONENT_PROPERTY = "iconComponent";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    public static final String PROPERTY_SUBTITLE_FONT = "subTitleFont";
    public static final String PROPERTY_TITLE_ICON_LOCATION = "titleIconLocation";
    private JComponent \u0101;
    protected int _subTitleIndent = 20;
    protected Font _titleFont;
    protected Color _titleColor;
    protected Font _subTitleFont;
    protected Color _subTitleColor;
    protected Paint _backgroundPaint;
    protected PropertyChangeListener _propertyListener;
    private JLabel \u0102;
    private JComponent \u0104;
    protected Color _startColor;
    protected Color _endColor;
    protected boolean _isVertical;
    private int \u0105 = 11;
    public JPanel _textPanel;

    public BannerPanel() {
        this.lazyInitialize();
    }

    public BannerPanel(String string) {
        this.setTitle(string);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2, ImageIcon imageIcon) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this.setTitleIcon(imageIcon);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2, JComponent jComponent) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this.\u0101 = jComponent;
        this.lazyInitialize();
    }

    public void lazyInitialize() {
        this.removeAll();
        this._textPanel = new JPanel(new BorderLayout(5, 5));
        this._textPanel.setOpaque(false);
        this._textPanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 2, 10));
        if (this.getSubTitleFont() == null) {
            this.setSubTitleFont(this.getFont());
        }
        this.\u0104 = this.createSubtitleLabel();
        this.\u0104.setFont(this.getSubTitleFont());
        if (this.getSubTitleColor() == null) {
            this.setSubTitleColor(this.getForeground());
        }
        this.\u0104.setForeground(this.getSubTitleColor());
        this.\u0104.setBorder(BorderFactory.createEmptyBorder(0, this.getSubTitleIndent(), 0, 0));
        this._textPanel.add((Component)this.\u0104, "Center");
        this.\u0102 = new JLabel(this.getTitle()){
            private static final long \u0102 = -5832474694740336965L;

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, super.getMinimumSize().height);
            }
        };
        if (this.getTitleFont() == null) {
            this.setTitleFont(SecurityUtils.createFont(this.getFont().getFontName(), 1, this.getFont().getSize() + 2));
        }
        this.\u0102.setFont(this.getTitleFont());
        if (this.getTitleColor() == null) {
            this.setTitleColor(this.getForeground());
        }
        this.\u0102.setForeground(this.getTitleColor());
        if (this.getSubtitle() != null && this.getSubtitle().length() != 0) {
            this._textPanel.add((Component)this.\u0102, "First");
        } else {
            this._textPanel.add((Component)this.\u0102, "Center");
        }
        if (this.getTitleIcon() == null && this.\u0101 == null) {
            this.\u0101 = new JLabel("");
        } else if (this.getTitleIcon() != null || this.\u0101 == null) {
            this.\u0101 = new JLabel(this.getTitleIcon());
        }
        this.\u0101.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 0));
        this.add((Component)this._textPanel, "Center");
        this.\u0101(this.\u0101);
        this._propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (BannerPanel.this.\u0102 != null && BannerPanel.TITLE_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    BannerPanel.this.\u0102.setText((String)propertyChangeEvent.getNewValue());
                } else if (BannerPanel.this.\u0104 != null && BannerPanel.SUBTITLE_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    if (BannerPanel.this.\u0104 instanceof JTextArea) {
                        ((JTextArea)BannerPanel.this.\u0104).setText(string);
                    } else if (BannerPanel.this.\u0104 instanceof JLabel) {
                        ((JLabel)BannerPanel.this.\u0104).setText(string);
                    }
                    if (string != null && string.length() != 0) {
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this.\u0102, "First");
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this.\u0104, "Center");
                    } else {
                        BannerPanel.this._textPanel.add((Component)BannerPanel.this.\u0102, "Center");
                    }
                } else if (BannerPanel.ICON_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    if (BannerPanel.this.\u0101 instanceof JLabel) {
                        ((JLabel)BannerPanel.this.\u0101).setIcon(BannerPanel.this.getTitleIcon());
                    }
                } else if (BannerPanel.ICON_COMPONENT_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getOldValue() instanceof JComponent) {
                        BannerPanel.this._textPanel.remove((JComponent)propertyChangeEvent.getOldValue());
                    }
                    if (propertyChangeEvent.getNewValue() instanceof JComponent) {
                        BannerPanel.this.\u0101((JComponent)propertyChangeEvent.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_TITLE_FONT.equals(propertyChangeEvent.getPropertyName())) {
                    if (BannerPanel.this.\u0102 != null) {
                        BannerPanel.this.\u0102.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_SUBTITLE_FONT.equals(propertyChangeEvent.getPropertyName())) {
                    if (BannerPanel.this.\u0104 != null) {
                        BannerPanel.this.\u0104.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                } else if (BannerPanel.PROPERTY_TITLE_ICON_LOCATION.equals(propertyChangeEvent.getPropertyName())) {
                    BannerPanel.this.\u0101(BannerPanel.this.\u0101);
                }
            }
        };
        this.addPropertyChangeListener(this._propertyListener);
    }

    protected JComponent createSubtitleLabel() {
        return new MultilineLabel(this.getSubtitle()){
            private static final long \u057f = -1609681547852636926L;

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
    }

    private void \u0101(JComponent jComponent) {
        if (jComponent != null) {
            switch (this.getTitleIconLocation()) {
                case 3: {
                    this.add((Component)jComponent, "East");
                    break;
                }
                case 7: {
                    this.add((Component)jComponent, "West");
                    break;
                }
                case 10: {
                    this.add((Component)jComponent, "Before");
                    break;
                }
                case 11: {
                    this.add((Component)jComponent, "After");
                }
            }
        }
    }

    protected ImageIcon prepareTitleIcon(ImageIcon imageIcon) {
        return imageIcon;
    }

    public Paint getBackgroundPaint() {
        return this._backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this._backgroundPaint = paint;
    }

    public void setGradientPaint(Color color, Color color2, boolean bl) {
        this.setStartColor(color);
        this.setEndColor(color2);
        this.setVertical(bl);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getStartColor() != null && this.getEndColor() != null) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.getStartColor(), this.getEndColor(), this.isVertical());
        } else if (this.getBackgroundPaint() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        String string2 = this._title;
        this._title = string;
        this.firePropertyChange(TITLE_PROPERTY, string2, this._title);
    }

    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String string) {
        String string2 = this._subtitle;
        this._subtitle = string;
        this.firePropertyChange(SUBTITLE_PROPERTY, string2, this._subtitle);
    }

    public ImageIcon getTitleIcon() {
        return this._titleIcon;
    }

    public void setTitleIcon(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = this._titleIcon;
        this._titleIcon = this.prepareTitleIcon(imageIcon);
        this.firePropertyChange(ICON_PROPERTY, imageIcon2, this._titleIcon);
    }

    public JComponent getIconComponent() {
        return this.\u0101;
    }

    public void setIconComponent(JComponent jComponent) {
        JComponent jComponent2 = this.\u0101;
        this.\u0101 = jComponent;
        this.firePropertyChange(ICON_COMPONENT_PROPERTY, jComponent2, this.\u0101);
    }

    public Font getSubTitleFont() {
        return this._subTitleFont;
    }

    public void setSubTitleFont(Font font) {
        Font font2 = this._subTitleFont;
        this._subTitleFont = font;
        this.firePropertyChange(PROPERTY_SUBTITLE_FONT, font2, this._subTitleFont);
    }

    public Font getTitleFont() {
        return this._titleFont;
    }

    public void setTitleFont(Font font) {
        Font font2 = this._titleFont;
        this._titleFont = font;
        this.firePropertyChange(PROPERTY_TITLE_FONT, font2, this._titleFont);
    }

    public int getSubTitleIndent() {
        return this._subTitleIndent;
    }

    public void setSubTitleIndent(int n2) {
        this._subTitleIndent = n2;
    }

    public Color getTitleColor() {
        return this._titleColor;
    }

    public void setTitleColor(Color color) {
        this._titleColor = color;
        if (this.\u0102 != null) {
            this.\u0102.setForeground(color);
        }
    }

    public Color getSubTitleColor() {
        return this._subTitleColor;
    }

    public void setSubTitleColor(Color color) {
        this._subTitleColor = color;
        if (this.\u0104 != null) {
            this.\u0104.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.\u0102 != null) {
            this.\u0102.setBackground(color);
        }
        if (this.\u0104 != null) {
            this.\u0104.setBackground(color);
        }
        if (this.\u0101 != null) {
            this.\u0101.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setTitleColor(color);
        this.setSubTitleColor(color);
        if (this.\u0101 != null) {
            this.\u0101.setForeground(color);
        }
    }

    public Color getStartColor() {
        return this._startColor;
    }

    public void setStartColor(Color color) {
        this._startColor = color;
    }

    public Color getEndColor() {
        return this._endColor;
    }

    public void setEndColor(Color color) {
        this._endColor = color;
    }

    public boolean isVertical() {
        return this._isVertical;
    }

    public void setVertical(boolean bl) {
        this._isVertical = bl;
    }

    public int getTitleIconLocation() {
        return this.\u0105;
    }

    public void setTitleIconLocation(int n2) {
        int n3 = this.\u0105;
        if (n3 != n2) {
            this.\u0105 = n2;
            this.firePropertyChange(PROPERTY_TITLE_ICON_LOCATION, n3, this.\u0105);
        }
    }

    public JComponent getTitleLabel() {
        return this.\u0102;
    }

    public JComponent getSubtitleLabel() {
        return this.\u0104;
    }
}

