/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.MultiSelectListChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ConverterContext;
import java.awt.Font;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;

public class MultiSelectListComboBox
extends AbstractComboBox {
    private boolean \u0190 = true;
    protected int maximumRowCount = 8;
    protected int _selectionMode = 2;
    public static final String PROPERTY_SELECTION_MODE = "selectionMode";

    public MultiSelectListComboBox() {
        this(new Object[0]);
    }

    public MultiSelectListComboBox(Object[] objectArray) {
        this(objectArray, Object[].class);
    }

    public MultiSelectListComboBox(Vector<?> vector) {
        this(vector, Object[].class);
    }

    public MultiSelectListComboBox(ComboBoxModel comboBoxModel) {
        this(comboBoxModel, Object[].class);
    }

    public MultiSelectListComboBox(Object[] objectArray, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        defaultComboBoxModel.setSelectedItem(null);
        this.initComponent(defaultComboBoxModel);
    }

    public MultiSelectListComboBox(Vector<?> vector, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        defaultComboBoxModel.setSelectedItem(null);
        this.initComponent(defaultComboBoxModel);
    }

    public MultiSelectListComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        this.initComponent(comboBoxModel);
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            return new AbstractComboBox.DefaultTextFieldEditorComponent(this.getType());
        }
        return new AbstractComboBox.DefaultRendererComponent(this.getType());
    }

    @Override
    public PopupPanel createPopupComponent() {
        MultiSelectListChooserPanel multiSelectListChooserPanel = this.createListChooserPanel(this.dataModel, this.getType().getComponentType(), ConverterContext.getElementConverterContext(this.getConverterContext()));
        multiSelectListChooserPanel.setRenderer(this.getRenderer());
        multiSelectListChooserPanel.setResizable(true);
        multiSelectListChooserPanel.setResizableCorners(16);
        multiSelectListChooserPanel.setMaximumRowCount(this.getMaximumRowCount());
        return multiSelectListChooserPanel;
    }

    protected MultiSelectListChooserPanel createListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz, ConverterContext converterContext) {
        return new MultiSelectListChooserPanel(comboBoxModel, clazz, converterContext, this.getDefaultOKAction(), this.getDefaultCancelAction()){

            @Override
            protected void setupList(JList jList) {
                super.setupList(jList);
                MultiSelectListComboBox.this.setupList(jList);
            }
        };
    }

    public void setMaximumRowCount(int n2) {
        int n3 = this.maximumRowCount;
        this.maximumRowCount = n2;
        this.firePropertyChange("maximumRowCount", n3, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setSelectedIndex(int n2) {
        int n3 = this.dataModel.getSize();
        if (n2 == -1) {
            super.setSelectedItem(null);
        } else {
            if (n2 < -1 || n2 >= n3) {
                throw new IllegalArgumentException("setSelectedIndex: " + n2 + " out of bounds");
            }
            Object object = Array.newInstance(this.getType().getComponentType(), 1);
            Array.set(object, 0, this.dataModel.getElementAt(n2));
            super.setSelectedItem(object);
        }
    }

    public int getSelectedIndex() {
        Object[] objectArray = this.getSelectedObjects();
        if (objectArray == null || objectArray.length == 0) {
            return -1;
        }
        int n2 = this.dataModel.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = this.dataModel.getElementAt(i2);
            int n3 = objectArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (e2 == null || !e2.equals(objectArray[i3])) continue;
                return i2;
            }
        }
        return -1;
    }

    public void setSelectedIndices(int[] nArray) {
        int n2 = this.dataModel.getSize();
        if (nArray.length == 0) {
            super.setSelectedItem(null);
        } else {
            Object object = Array.newInstance(this.getType().getComponentType(), nArray.length);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n3 = nArray[i2];
                if (n3 < -1 || n3 >= n2) {
                    throw new IllegalArgumentException("setSelectedIndices: " + n3 + " out of bounds");
                }
                Array.set(object, i2, this.dataModel.getElementAt(n3));
            }
            this.setSelectedItem(object);
        }
    }

    public int[] getSelectedIndices() {
        Object[] objectArray = this.getSelectedObjects();
        int[] nArray = new int[objectArray.length];
        block0: for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            nArray[i2] = -1;
            int n2 = this.dataModel.getSize();
            for (int i3 = 0; i3 < n2; ++i3) {
                Object e2 = this.dataModel.getElementAt(i3);
                if (e2 == null || !e2.equals(object)) continue;
                nArray[i2] = i3;
                continue block0;
            }
        }
        return nArray;
    }

    @Override
    public void setSelectedItem(Object object, boolean bl) {
        super.setSelectedItem(this.convertArrayType(object), bl);
    }

    public Object convertArrayType(Object object) {
        if (object == null || this.getType() == null) {
            return object;
        }
        if (object.getClass().isArray()) {
            Class<?> clazz = this.getType().getComponentType();
            if (clazz.isAssignableFrom(object.getClass().getComponentType())) {
                return object;
            }
            int n2 = Array.getLength(object);
            Object object2 = Array.newInstance(clazz, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = Array.get(object, i2);
                try {
                    Array.set(object2, i2, object3);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object2;
        }
        Object object4 = Array.newInstance(this.getType().getComponentType(), 1);
        Array.set(object4, 0, object);
        return object4;
    }

    public void setSelectedObjects(Object[] objectArray) {
        super.setSelectedItem(objectArray);
    }

    @Override
    public Object getSelectedItem() {
        Object object = super.getSelectedItem();
        return this.convertArrayType(object);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        Object object = super.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        try {
            int n2 = Array.getLength(object);
            objectArray = new Object[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = Array.get(object, i2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArray = new Object[]{object};
        }
        return objectArray;
    }

    public JList getList() {
        if (!this.isPopupVisible() && this.isShowing()) {
            this.showPopup();
        }
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof MultiSelectListChooserPanel) {
            return ((MultiSelectListChooserPanel)this.getPopupPanel()).getList();
        }
        return null;
    }

    @Override
    protected JComponent getDelegateTarget() {
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof MultiSelectListChooserPanel) {
            return ((MultiSelectListChooserPanel)this.getPopupPanel()).getList();
        }
        return null;
    }

    @Override
    protected boolean validateValueForNonEditable(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            for (int i2 = 0; i2 < n2; ++i2) {
                boolean bl = super.validateValueForNonEditable(Array.get(object, i2));
                if (bl) continue;
                return false;
            }
            return true;
        }
        return super.validateValueForNonEditable(object);
    }

    protected void setupList(final JList jList) {
        Font font = this.getFont();
        if (font != null && !(font instanceof UIResource)) {
            jList.setFont(font);
        }
        jList.getSelectionModel().setSelectionMode(this.getSelectionMode());
        jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object[] objectArray;
                Object object;
                if (!listSelectionEvent.getValueIsAdjusting() && MultiSelectListComboBox.this.isUpdateOnChange() && !Boolean.TRUE.equals(jList.getClientProperty("PopupPanel.selectedByMouseRollover")) && (object = MultiSelectListComboBox.this.convertArrayType(objectArray = jList.getSelectedValues())) != null && MultiSelectListComboBox.this.getEditor().getItem() != object) {
                    MultiSelectListComboBox.this.getEditor().setItem(object);
                    MultiSelectListComboBox.this.getEditor().selectAll();
                }
            }
        });
    }

    public void setSelectionMode(int n2) {
        int n3 = this._selectionMode;
        if (n3 != n2) {
            this._selectionMode = n2;
            if (this._popupPanel instanceof MultiSelectListChooserPanel && ((MultiSelectListChooserPanel)this._popupPanel).getList() != null) {
                ((MultiSelectListChooserPanel)this._popupPanel).getList().setSelectionMode(n2);
            }
            this.firePropertyChange(PROPERTY_SELECTION_MODE, n3, n2);
        }
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public boolean isUpdateOnChange() {
        return this.\u0190;
    }

    public void setUpdateOnChange(boolean bl) {
        this.\u0190 = bl;
    }
}

