/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ChartUtils {
    private static boolean \u0101 = false;

    public static void setAssertEDTViolations(boolean bl) {
        \u0101 = bl;
    }

    public static boolean isAssertingEDTViolations() {
        return \u0101;
    }

    public static void assertEDT() {
        if (\u0101) assert (SwingUtilities.isEventDispatchThread());
    }

    public static void runOnEdt(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void writeGifToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.\u0101(component, "gif", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writeJpegToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.\u0101(component, "jpg", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writePngToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.\u0101(component, "png", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writeToStream(Component component, OutputStream outputStream) {
        ChartUtils.\u0101(component, "png", outputStream);
    }

    private static void \u0101(Component component, String string, OutputStream outputStream) {
        BufferedImage bufferedImage = ChartUtils.createImage(component);
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static BufferedImage createImage(Component component) {
        return ChartUtils.createImage(component, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createImage(Component component, int n2) {
        Dimension dimension = component.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            boolean bl = jComponent.isDoubleBuffered();
            try {
                jComponent.setDoubleBuffered(false);
                jComponent.paint(graphics2D);
            }
            finally {
                jComponent.setDoubleBuffered(bl);
            }
        } else {
            component.paint(graphics2D);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image createThumbnailImage(Component component, int n2, int n3) {
        BufferedImage bufferedImage = ChartUtils.createImage(component);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double d2 = (double)n2 / (double)bufferedImage.getWidth();
        double d3 = (double)n3 / (double)bufferedImage.getHeight();
        assert (d2 <= 1.0) : "The thumbnail should be smaller than the original";
        assert (d3 <= 1.0) : "The thumbnail should be smaller than the original";
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    public static ImageIcon createThumbnail(Component component, int n2, int n3) {
        return new ImageIcon(ChartUtils.createThumbnailImage(component, n2, n3));
    }

    public static TexturePaint createTexture(JComponent jComponent, String string) {
        Image image = ChartUtils.createImage(string);
        MediaTracker mediaTracker = new MediaTracker(jComponent);
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        int n2 = image.getWidth(jComponent);
        int n3 = image.getHeight(jComponent);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, jComponent);
        return new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public static Image createImage(String string) {
        ClassLoader classLoader = ChartUtils.class.getClassLoader();
        if (classLoader != null) {
            URL uRL = classLoader.getResource(string);
            if (uRL == null) {
                uRL = classLoader.getResource("/" + string);
            }
            return Toolkit.getDefaultToolkit().createImage(uRL);
        }
        return null;
    }

    public static void clearBufferedImage(BufferedImage bufferedImage, Color color) {
        if (bufferedImage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(1, 1.0f));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(color);
        graphics2D.fill(double_);
    }

    public static boolean isHardwareAccelerated(Image image) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        return image.getCapabilities(graphicsConfiguration).isAccelerated();
    }

    public static int[] getPixels(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int[] nArray) {
        if (n4 == 0 || n5 == 0) {
            return new int[0];
        }
        if (nArray == null) {
            nArray = new int[n4 * n5];
        } else if (nArray.length < n4 * n5) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n6 = bufferedImage.getType();
        if (n6 == 2 || n6 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            return (int[])writableRaster.getDataElements(n2, n3, n4, n5, nArray);
        }
        return bufferedImage.getRGB(n2, n3, n4, n5, nArray, 0, n4);
    }

    public static void setPixels(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int[] nArray) {
        if (nArray == null || n4 == 0 || n5 == 0) {
            return;
        }
        if (nArray.length < n4 * n5) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n6 = bufferedImage.getType();
        if (n6 == 2 || n6 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(n2, n3, n4, n5, nArray);
        } else {
            bufferedImage.setRGB(n2, n3, n4, n5, nArray, 0, n4);
        }
    }

    public static void copyImageToClipboard(Component component) {
        Dimension dimension = component.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        A a2 = new A(bufferedImage);
        component.paint(graphics);
        clipboard.setContents(a2, null);
    }

    public static Font deriveResizedFont(Font font, Dimension dimension, Dimension dimension2) {
        if (dimension == null || dimension2 == null) {
            return font;
        }
        int n2 = dimension2.width;
        int n3 = dimension2.height;
        float f2 = (float)n3 / (float)dimension.height;
        float f3 = (float)n2 / (float)dimension.width;
        float f4 = Math.min(f2, f3);
        float f5 = font.getSize2D() * f4;
        return font.deriveFont(f5);
    }

    public static Font deriveResizedFont(Font font, Dimension dimension, JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        Dimension dimension2 = jComponent.getSize();
        if (dimension2 == null || dimension == null) {
            return font;
        }
        int n2 = dimension2.width - insets.left - insets.right;
        int n3 = dimension2.height - insets.top - insets.bottom;
        return ChartUtils.deriveResizedFont(font, dimension, new Dimension(n2, n3));
    }

    private static class A
    implements Transferable {
        public static DataFlavor \u0101 = DataFlavor.imageFlavor;
        private Image \u0102;

        public A(Image image) {
            this.\u0102 = image;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{\u0101};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return \u0101.equals(dataFlavor);
        }

        @Override
        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!\u0101.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.\u0102;
        }
    }
}

