/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AbstractDelegatingChartModel;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.ChartPoint3D;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.range.Positionable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WaterfallModelAdapter
extends AbstractDelegatingChartModel {
    public static final Highlight FIRST = new Highlight("First");
    public static final Highlight RISING = new Highlight("Rising");
    public static final Highlight FALLING = new Highlight("Falling");
    public static final Highlight LAST = new Highlight("Last");
    private List<Chartable> \u01b7;

    public WaterfallModelAdapter(ChartModel chartModel) {
        this.setDelegate(chartModel);
    }

    @Override
    protected void update() {
        this.\u01b7 = new ArrayList<Chartable>();
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        int n2 = annotatedChartModel == null ? 0 : annotatedChartModel.getPointCount();
        Positionable positionable = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Chartable chartable = annotatedChartModel.getPoint(i2);
            ChartPoint chartPoint = null;
            if (i2 == 0) {
                positionable = chartable.getY();
                chartPoint = new ChartPoint(chartable.getX(), positionable, FIRST);
            } else if (i2 == n2 - 1) {
                positionable = chartable.getY();
                chartPoint = new ChartPoint(chartable.getX(), positionable, LAST);
            } else {
                Positionable positionable2 = chartable.getX();
                Positionable positionable3 = chartable.getY();
                if (positionable3 != null && positionable2 != null) {
                    double d2 = positionable3.position();
                    if (d2 > 0.0) {
                        chartPoint = new ChartPoint3D(positionable2.position(), positionable.position() + d2, d2);
                        chartPoint.setHighlight(RISING);
                    } else {
                        chartPoint = new ChartPoint3D(positionable2.position(), positionable.position(), d2);
                        chartPoint.setHighlight(FALLING);
                    }
                    positionable = new RealPosition(positionable.position() + d2);
                }
            }
            if (chartPoint == null) continue;
            this.\u01b7.add(chartPoint);
        }
    }

    @Override
    public int getAnnotationCount() {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel != null) {
            return annotatedChartModel.getAnnotationCount();
        }
        return 0;
    }

    @Override
    public Annotation getAnnotation(int n2) {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel != null) {
            return annotatedChartModel.getAnnotation(n2);
        }
        return null;
    }

    @Override
    public boolean isAnnotationsVisible() {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        return annotatedChartModel != null && annotatedChartModel.isAnnotationsVisible();
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel == null) {
            throw new UnsupportedOperationException("Delegate Model does not support annotations");
        }
        annotatedChartModel.setAnnotationsVisible(bl);
    }

    @Override
    public Chartable getPoint(int n2) {
        if (this.\u01b7 == null) {
            this.update();
        }
        return this.\u01b7.get(n2);
    }

    @Override
    public int getPointCount() {
        if (this.\u01b7 == null) {
            this.update();
        }
        return this.\u01b7.size();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }

    @Override
    public Iterator<Chartable> iterator() {
        return this.\u01b7.iterator();
    }
}

