/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.ChartPanner;
import com.jidesoft.chart.event.MouseHandler;
import com.jidesoft.chart.event.PanListener;
import com.jidesoft.range.Range;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class MouseDragPanner
implements MouseHandler {
    public static final String PROPERTY_HORIZONTAL_PAN = "Pan Horizontal";
    public static final String PROPERTY_VERTICAL_PAN = "Pan Vertical";
    public static final String PROPERTY_X_LIMITS = "X Limits";
    public static final String PROPERTY_Y_LIMITS = "Y Limits";
    private Chart \u0104;
    private Point \u0105;
    private boolean \u0102 = false;
    private PropertyChangeSupport \u0106 = new PropertyChangeSupport(this);
    private boolean \u0103 = true;
    private Cursor \u0108 = Cursor.getPredefinedCursor(13);
    private ChartPanner \u0101;
    private int \u0107 = 16;

    public MouseDragPanner(Chart chart) {
        this(chart, true, true);
    }

    public MouseDragPanner(Chart chart, boolean bl, boolean bl2) {
        this.\u0104 = chart;
        this.\u0101 = new ChartPanner(chart, bl, bl2);
        this.\u0101.resetSpeeds();
        this.setHorizontalPan(bl);
        this.setVerticalPan(bl2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0106.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0106.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isHorizontalPan() {
        return this.\u0101.isHorizontalPan();
    }

    public void setHorizontalPan(boolean bl) {
        boolean bl2 = this.\u0101.isHorizontalPan();
        this.\u0101.setHorizontalPan(bl);
        this.\u0106.firePropertyChange(PROPERTY_HORIZONTAL_PAN, bl2, bl);
    }

    public boolean isVerticalPan() {
        return this.\u0101.isVerticalPan();
    }

    public void setVerticalPan(boolean bl) {
        boolean bl2 = this.\u0101.isVerticalPan();
        this.\u0101.setVerticalPan(bl);
        this.\u0106.firePropertyChange(PROPERTY_VERTICAL_PAN, bl2, bl);
    }

    public Cursor getDragCursor() {
        return this.\u0108;
    }

    public void setDragCursor(Cursor cursor) {
        this.\u0108 = cursor;
    }

    public boolean isChangeCursorWhileDragging() {
        return this.\u0103;
    }

    public void setChangeCursorWhileDragging(boolean bl) {
        this.\u0103 = bl;
    }

    public boolean isContinuous() {
        return this.\u0101.isContinuous();
    }

    public void setContinuous(boolean bl) {
        this.\u0101.setContinuous(bl);
    }

    public double getFrictionCoefficient() {
        return this.\u0101.getFrictionCoefficient();
    }

    public int getButtonMask() {
        return this.\u0107;
    }

    public void setButtonMask(int n2) {
        this.\u0107 = n2;
    }

    public void setFrictionCoefficient(double d2) {
        if (d2 <= 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException("Friction coefficient must be between 0 and 1");
        }
        this.\u0101.setFrictionCoefficient(d2);
    }

    public Range<?> getXLimits() {
        return this.\u0101.getXLimits();
    }

    public void setXLimits(Range<?> range) {
        Range<?> range2 = this.\u0101.getXLimits();
        this.\u0101.setXLimits(range);
        this.\u0106.firePropertyChange(PROPERTY_X_LIMITS, range2, range);
    }

    public Range<?> getYLimits() {
        return this.\u0101.getYLimits();
    }

    public void setYLimits(Range<?> range) {
        Range<?> range2 = this.\u0101.getYLimits();
        this.\u0101.setYLimits(range);
        this.\u0106.firePropertyChange(PROPERTY_Y_LIMITS, range2, range);
    }

    public void addPanListener(PanListener panListener) {
        this.\u0101.addPanListener(panListener);
    }

    public void removePanListener(PanListener panListener) {
        this.\u0101.removePanListener(panListener);
    }

    Point \u0101() {
        return this.\u0105;
    }

    private boolean \u0101(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & this.\u0107) != 0;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.\u0101(mouseEvent) || !this.\u0104.isEnabled()) {
            return;
        }
        this.\u0105 = mouseEvent.getPoint();
        this.setHandled(true);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.\u0101(mouseEvent) || !this.\u0104.isEnabled()) {
            return;
        }
        this.\u0101.resetSpeeds();
        if (this.\u0103) {
            this.\u0104.setCursor(Cursor.getDefaultCursor());
        }
        this.\u0105 = null;
        this.setHandled(true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setHandled(!this.\u0104.isEnabled());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setHandled(!this.\u0104.isEnabled());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setHandled(!this.\u0104.isEnabled());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.\u0101(mouseEvent) || !this.\u0104.isEnabled()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (this.\u0103) {
            this.\u0104.setCursor(this.\u0108);
        }
        if (this.\u0105 != null) {
            this.\u0101.drag(this.\u0105, point);
        }
        this.\u0105 = point;
        this.setHandled(true);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public boolean isHandled() {
        return this.\u0102;
    }

    @Override
    public void setHandled(boolean bl) {
        this.\u0102 = bl;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.setHandled(false);
    }
}

