/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LabelPlacement;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.Shadowable;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.axis.Axis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JViewport;

public class IntervalMarker
implements Drawable,
Frontable,
Shadowable,
ZOrder {
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_ORIENTATION = "Orientation";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_COLOR = "Color";
    public static final String PROPERTY_PAINT = "Paint";
    public static final String PROPERTY_MAX = "Maximum";
    public static final String PROPERTY_MIN = "Minimum";
    public static final String PROPERTY_LABEL = "Label";
    public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";
    public static final String PROPERTY_LABEL_COLOR = "Label Color";
    public static final String PROPERTY_LABEL_FONT = "Label Font";
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_OUTLINE_COLOR = "Outline Color";
    public static final String PROPERTY_OUTLINE_STROKE = "Outline Stroke";
    public static final String PROPERTY_SHADOW_VISIBLE = "Shadow Visible";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Chart \u0164;
    private Paint \u0165 = new Color(255, 0, 0, 128);
    private Orientation \u015f = Orientation.vertical;
    private double \u0166;
    private double \u0167;
    private boolean \u015e = true;
    private boolean \u0163 = false;
    private boolean \u016a = false;
    private String \u0162;
    private LabelPlacement \u015d;
    private Color \u0169;
    private Color \u016b;
    private Stroke \u0168 = new BasicStroke(1.0f);
    private Font \u0161;
    private static final int \u0160 = 4;
    private int \u015c = 100;

    public IntervalMarker() {
    }

    public IntervalMarker(Chart chart) {
        this.\u0164 = chart;
    }

    public IntervalMarker(Chart chart, double d2, double d3, Paint paint) {
        this.\u0164 = chart;
        this.\u0165 = paint;
        this.setInterval(d2, d3);
    }

    public IntervalMarker(Chart chart, Orientation orientation, double d2, double d3, Paint paint) {
        this.\u0164 = chart;
        this.\u0165 = paint;
        this.\u015f = orientation;
        this.setInterval(d2, d3);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Chart getChart() {
        return this.\u0164;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.\u0164;
        this.\u0164 = chart;
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public boolean isVisible() {
        return this.\u015e;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.\u015e;
        this.\u015e = bl;
        this.support.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
    }

    public Color getColor() {
        if (this.\u0165 instanceof Color) {
            return (Color)this.\u0165;
        }
        return null;
    }

    public void setColor(Color color) {
        Paint paint = this.\u0165;
        this.\u0165 = color;
        if (this.\u0164 != null) {
            this.\u0164.repaint();
        }
        this.support.firePropertyChange(PROPERTY_COLOR, paint, color);
    }

    public Paint getPaint() {
        return this.\u0165;
    }

    public void setPaint(Paint paint) {
        Paint paint2 = this.\u0165;
        this.\u0165 = paint;
        if (this.\u0164 != null) {
            this.\u0164.repaint();
        }
        this.support.firePropertyChange(PROPERTY_PAINT, paint2, paint);
    }

    public Orientation getOrientation() {
        return this.\u015f;
    }

    public void setOrientation(Orientation orientation) {
        Orientation orientation2 = this.\u015f;
        this.\u015f = orientation;
        if (this.\u0164 != null) {
            this.\u0164.repaint();
        }
        this.support.firePropertyChange(PROPERTY_ORIENTATION, (Object)orientation2, (Object)orientation);
    }

    @Override
    public int getZOrder() {
        return this.\u015c;
    }

    @Override
    public void setZOrder(int n2) {
        this.\u015c = n2;
    }

    public double getMin() {
        return this.\u0166;
    }

    public double getMax() {
        return this.\u0167;
    }

    public void setMin(double d2) {
        double d3 = this.\u0166;
        this.\u0166 = d2;
        if (this.\u0164 != null) {
            this.\u0164.repaint();
        }
        this.support.firePropertyChange(PROPERTY_MIN, d3, d2);
    }

    public void setMax(double d2) {
        double d3 = this.\u0167;
        this.\u0167 = d2;
        if (this.\u0164 != null) {
            this.\u0164.repaint();
        }
        this.support.firePropertyChange(PROPERTY_MAX, d3, d2);
    }

    public void setInterval(double d2, double d3) {
        double d4 = this.\u0166;
        double d5 = this.\u0167;
        this.\u0166 = d2;
        this.\u0167 = d3;
        if (this.\u0164 != null) {
            this.\u0164.repaint();
        }
        this.support.firePropertyChange(PROPERTY_MIN, d4, d2);
        this.support.firePropertyChange(PROPERTY_MAX, d5, d3);
    }

    public String getLabel() {
        return this.\u0162;
    }

    public void setLabel(String string) {
        String string2 = this.\u0162;
        this.\u0162 = string;
        this.support.firePropertyChange(PROPERTY_LABEL, string2, string);
    }

    public LabelPlacement getLabelPlacement() {
        return this.\u015d;
    }

    public void setLabelPlacement(LabelPlacement labelPlacement) {
        LabelPlacement labelPlacement2 = this.\u015d;
        this.\u015d = labelPlacement;
        this.support.firePropertyChange(PROPERTY_LABEL_PLACEMENT, (Object)labelPlacement2, (Object)labelPlacement);
    }

    public Color getLabelColor() {
        return this.\u0169;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.\u0169;
        this.\u0169 = color;
        this.support.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Font getLabelFont() {
        return this.\u0161;
    }

    public void setLabelFont(Font font) {
        Font font2 = this.\u0161;
        this.\u0161 = font;
        this.support.firePropertyChange(PROPERTY_LABEL_FONT, font2, font);
    }

    public Color getOutlineColor() {
        return this.\u016b;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.\u016b;
        this.\u016b = color;
        this.support.firePropertyChange(PROPERTY_OUTLINE_COLOR, color2, color);
    }

    public Stroke getOutlineStroke() {
        return this.\u0168;
    }

    public void setOutlineStroke(Stroke stroke) {
        Stroke stroke2 = this.\u0168;
        this.\u0168 = stroke;
        this.support.firePropertyChange(PROPERTY_OUTLINE_STROKE, stroke2, stroke);
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.\u0164 == null) {
            return;
        }
        if (this.\u015e) {
            Axis axis = this.\u0164.getXAxis();
            Axis axis2 = this.\u0164.getYAxis();
            if (this.\u015f == Orientation.horizontal) {
                double d2 = axis == null ? 0.0 : axis.minimum();
                double d3 = axis2.isFlipped() ? this.\u0167 : this.\u0166;
                double d4 = axis2.isFlipped() ? this.\u0166 : this.\u0167;
                Point point = this.\u0164.calculatePixelPoint(new Point2D.Double(d2, d3));
                Point point2 = this.\u0164.calculatePixelPoint(new Point2D.Double(d2, d4));
                if (point != null && point2 != null) {
                    Paint paint = this.createHorizontalPaint(this.\u0164, point.y, point2.y);
                    point2.x = this.\u0164.getXStart();
                    graphics2D.setPaint(paint);
                    graphics2D.fillRect(point2.x, point2.y, this.\u0164.getChartWidth(), point.y - point2.y);
                    if (this.\u016b != null && this.\u0168 != null) {
                        graphics2D.setColor(this.\u016b);
                        graphics2D.setStroke(this.\u0168);
                        graphics2D.drawLine(this.\u0164.getXStart(), point2.y, this.\u0164.getXEnd(), point2.y);
                        graphics2D.drawLine(this.\u0164.getXStart(), point.y, this.\u0164.getXEnd(), point.y);
                    }
                    if (this.\u0162 != null) {
                        this.\u0101(graphics2D, this.\u0162, point.x, point2.y, this.\u0164.getChartWidth(), point.y - point2.y);
                    }
                }
            } else if (this.\u015f == Orientation.vertical) {
                double d5 = axis2 == null ? 0.0 : axis2.minimum();
                double d6 = axis.isFlipped() ? this.\u0167 : this.\u0166;
                double d7 = axis.isFlipped() ? this.\u0166 : this.\u0167;
                Point point = this.\u0164.calculatePixelPoint(new Point2D.Double(d6, d5));
                Point point3 = this.\u0164.calculatePixelPoint(new Point2D.Double(d7, d5));
                if (point != null && point3 != null) {
                    Paint paint = this.createVerticalPaint(this.\u0164, point.x, point3.x);
                    graphics2D.setPaint(paint);
                    graphics2D.fillRect(point.x, this.\u0164.getYEnd(), point3.x - point.x, this.\u0164.getChartHeight());
                    if (this.\u016b != null && this.\u0168 != null) {
                        graphics2D.setColor(this.\u016b);
                        graphics2D.setStroke(this.\u0168);
                        graphics2D.drawLine(point3.x, this.\u0164.getYStart(), point3.x, this.\u0164.getYEnd());
                        graphics2D.drawLine(point.x, this.\u0164.getYStart(), point.x, this.\u0164.getYEnd());
                    }
                    if (this.\u0162 != null) {
                        this.\u0101(graphics2D, this.\u0162, point.x, this.\u0164.getYEnd(), point3.x - point.x, this.\u0164.getChartHeight());
                    }
                }
            }
        }
        graphics2D.dispose();
    }

    protected Paint createHorizontalPaint(Chart chart, int n2, int n3) {
        return this.\u0165;
    }

    protected Paint createVerticalPaint(Chart chart, int n2, int n3) {
        return this.\u0165;
    }

    private void \u0101(Graphics2D graphics2D, String string, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (this.\u0161 != null) {
            graphics2D.setFont(this.\u0161);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n8 = fontMetrics.stringWidth(string);
        int n9 = fontMetrics.getHeight();
        int n10 = fontMetrics.getAscent();
        int n11 = n2 + n4;
        int n12 = n3 + n5;
        Rectangle rectangle = null;
        Container container = this.\u0164.getParent();
        if (container != null && container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            rectangle = jViewport.getViewRect();
        }
        if (this.\u015d == LabelPlacement.WEST || this.\u015d == LabelPlacement.NORTH_WEST || this.\u015d == LabelPlacement.SOUTH_WEST) {
            n7 = n2 + 4;
            if (rectangle != null) {
                n7 += rectangle.x;
            }
        } else if (this.\u015d == LabelPlacement.EAST || this.\u015d == LabelPlacement.NORTH_EAST || this.\u015d == LabelPlacement.SOUTH_EAST) {
            n7 = n11 - n8 - 4;
            if (rectangle != null) {
                n7 = n7 - this.\u0164.getChartWidth() + rectangle.x + rectangle.width;
            }
        } else {
            n7 = n2 + n4 / 2 - n8 / 2;
            if (rectangle != null) {
                n7 += rectangle.x;
            }
        }
        if (this.\u015d == LabelPlacement.NORTH || this.\u015d == LabelPlacement.NORTH_WEST || this.\u015d == LabelPlacement.NORTH_EAST) {
            n6 = n3 + n9;
            if (rectangle != null) {
                n6 += rectangle.y;
            }
        } else if (this.\u015d == LabelPlacement.SOUTH || this.\u015d == LabelPlacement.SOUTH_EAST || this.\u015d == LabelPlacement.SOUTH_WEST) {
            n6 = n12 - 4;
            if (rectangle != null) {
                n6 = n6 + this.\u0164.getChartHeight() + rectangle.y + rectangle.height;
            }
        } else {
            n6 = (n3 + n12) / 2 + n10 / 2;
            if (rectangle != null) {
                n6 += rectangle.y;
            }
        }
        if (rectangle != null) {
            n6 += rectangle.y;
        }
        if (this.\u0169 == null) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(this.\u0169);
        }
        graphics2D.drawString(string, n7, n6);
    }

    @Override
    public boolean isAtFront() {
        return this.\u0163;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.\u0163;
        this.\u0163 = bl;
        this.support.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }

    @Override
    public boolean isShadowVisible() {
        return this.\u016a;
    }

    @Override
    public void setShadowVisible(boolean bl) {
        boolean bl2 = this.\u016a;
        this.\u016a = bl;
        this.support.firePropertyChange(PROPERTY_SHADOW_VISIBLE, bl2, bl);
    }
}

