/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling;

final class RevisitQueue<T> {
    private int elements = 0;
    private Element listHead = null;
    private Element listTail = null;

    RevisitQueue() {
    }

    void enqueue(T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("data is null");
        }
        Element element = new Element(t2);
        ++this.elements;
        if (this.listTail != null) {
            this.listTail.next = element;
        }
        this.listTail = element;
        if (this.listHead == null) {
            this.listHead = this.listTail;
        }
    }

    T dequeue() {
        if (this.listHead == null) {
            return null;
        }
        Element element = this.listHead;
        this.listHead = this.listHead.next;
        if (this.listHead == null) {
            this.listTail = null;
        }
        --this.elements;
        return element.data;
    }

    void clear() {
        this.listTail = null;
        this.listHead = null;
    }

    private final class Element {
        final T data;
        Element next = null;

        Element(T t2) {
            this.data = t2;
        }
    }
}

