/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class PartialLineBorder
extends LineBorder {
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 4;
    public static final int WEST = 8;
    public static final int HORIZONTAL = 3;
    public static final int VERTICAL = 12;
    public static final int ALL = 15;
    private int sides = 15;

    public PartialLineBorder(Color color, int thickness, int sides) {
        super(color, thickness);
        this.sides = sides;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            if (this.sides == 15) {
                g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                continue;
            }
            if ((this.sides & 1) != 0) {
                g.drawLine(x, y + i, x + width - 1, y + i);
            }
            if ((this.sides & 2) != 0) {
                g.drawLine(x, y + height - i - 1, x + width - 1, y + height - i - 1);
            }
            if ((this.sides & 8) != 0) {
                g.drawLine(x + i, y, x + i, y + height - 1);
            }
            if ((this.sides & 4) == 0) continue;
            g.drawLine(x + width - i - 1, y, x + width - i - 1, y + height - 1);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets borderInsets = super.getBorderInsets(c);
        if ((this.sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this.sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this.sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this.sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets borderInsets = super.getBorderInsets(c, insets);
        if ((this.sides & 1) == 0) {
            borderInsets.top = 0;
        }
        if ((this.sides & 2) == 0) {
            borderInsets.bottom = 0;
        }
        if ((this.sides & 8) == 0) {
            borderInsets.left = 0;
        }
        if ((this.sides & 4) == 0) {
            borderInsets.right = 0;
        }
        return borderInsets;
    }
}

