/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.ejt.framework.io.StreamConsumerThread;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class Execution {
    public static boolean executeAndWait(String[] command, StringBuffer output) throws IOException {
        return Execution.executeWithReturnCode(command, output, false) == 0;
    }

    public static int executeWithReturnCode(String[] command, StringBuffer output, boolean utf8) throws IOException {
        return Execution.executeWithReturnCode(command, output, output, utf8);
    }

    public static int executeWithReturnCode(String[] command, StringBuffer output, StringBuffer error, boolean utf8) throws IOException {
        if (InstallerUtil.isWindows()) {
            Process process = new ProcessBuilder(command).start();
            return Execution.handleProcess(process, output, error, utf8);
        }
        File scriptFile = File.createTempFile("i4j", ".sh");
        Process process = Execution.executeWithScript(command, scriptFile);
        int ret = Execution.handleProcess(process, output, error, utf8);
        scriptFile.delete();
        return ret;
    }

    public static Process execute(String[] command) throws IOException {
        if (InstallerUtil.isMacOS()) {
            File scriptFile = File.createTempFile("i4j", ".sh");
            return Execution.executeWithScript(command, scriptFile);
        }
        return new ProcessBuilder(command).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int handleProcess(Process process, StringBuffer output, StringBuffer error, boolean utf8) throws IOException {
        try {
            StreamConsumerThread.consumeOutput(process, output, error, utf8);
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            int n = 1;
            return n;
        }
        finally {
            process.destroy();
        }
    }

    private static Process executeWithScript(String[] command, File scriptFile) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(scriptFile)), StandardCharsets.UTF_8));
        pw.println("#!/bin/sh");
        for (int i = 0; i < command.length; ++i) {
            pw.print("\"" + command[i] + "\"");
            if (i >= command.length - 1) continue;
            pw.print(" ");
        }
        pw.println();
        pw.close();
        String[] cmd = new String[]{"/bin/sh", scriptFile.getAbsolutePath()};
        return new ProcessBuilder(cmd).start();
    }
}

