#!/bin/sh

# Script to launch DbVisualizer by manually invoking Java

# Function: Initializes the java version variables
init_java_version() {
  version_output=`"$JAVA_EXEC" $1 -version 2>&1`
  is_gcj=`expr "$version_output" : '.*gcj'`
  IS_OPENJDK=`expr "$version_output" : '.*OpenJDK'`
  if [ "$is_gcj" = "0" ]; then
    java_version=`expr "$version_output" : '.*"\(.*\)".*'`
    JAVA_MAJOR_VERSION=`expr "$java_version" : '\([0-9][0-9]*\).*'`
    JAVA_MINOR_VERSION=`expr "$java_version" : '[0-9][0-9]*\.\([0-9][0-9]*\).*'`
    JAVA_MICRO_VERSION=`expr "$java_version" : '[0-9][0-9]*\.[0-9][0-9]*\.\([0-9][0-9]*\).*'`
    VER_PATCH=`expr "$java_version" : '[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*[\._]\([0-9][0-9]*\).*'`
  fi
}

if [ -z "$DBVIS_HOME" ] ; then 
  DBVIS_HOME=`dirname "$0"`
fi

if [ -z "$JAVA_EXEC" ] ; then 
 JAVA_EXEC=java
fi

init_java_version

if [ -z "$java_version" ] ; then 
   echo Unable to extract java version - is a supported JRE installed?
   exit 1
fi

if [  "$JAVA_MAJOR_VERSION" -eq "1" ]; then
  if [  "$JAVA_MINOR_VERSION" -le "7" ]; then
     echo Java version $java_version is not supported. At least java 8 is required.
     exit 1
  fi
fi

CP="$DBVIS_HOME/resources"
CP="$CP:$DBVIS_HOME/lib/*"

VM_ARGS="-XX:StringTableSize=1000003 -Xmx768M "

DBVIS_OSTYPE=`uname`

if [ "$JAVA_MAJOR_VERSION" -ge "9" ]; then
   JAVA_ARGS="${VM_ARGS} @java9-args ${COMMON_ARGS}"
    echo $DBVIS_OSTYPE | grep -iq darwin
    if [ $? = "0" ]; then
       # Java 9+ found and using macOS
       $JAVA_EXEC ${VM_ARGS} \
          @"${DBVIS_HOME}"/java9-args @"${DBVIS_HOME}"/java9-args-macos \
          -Dsun.locale.formatasdefault=true \
          -Ddbvis.home="${DBVIS_HOME}" \
          -splash:"${DBVIS_HOME}/resources/images/ix3/dbvis-splash_dark.png" \
          -Xdock:name="DbVisualizer" \
          -Xdock:icon="${DBVIS_HOME}/resources/images/ix3/dbvis-icon.icns" \
          -cp "${CP}" \
          com.onseven.dbvis.DbVisualizerGUI "$@"
    else
       # Java 9+ found and using Windows or Linux/UNIX
       $JAVA_EXEC ${VM_ARGS} \
          @"${DBVIS_HOME}"/java9-args \
          -Dsun.locale.formatasdefault=true \
          -Ddbvis.home="${DBVIS_HOME}" \
          -splash:"${DBVIS_HOME}/resources/images/ix3/dbvis-splash_dark.png" \
          -cp "${CP}" \
          com.onseven.dbvis.DbVisualizerGUI "$@"
    fi
elif [ "$JAVA_MAJOR_VERSION" = "1" ] && [ "$JAVA_MINOR_VERSION" = "8" ]; then
   # Java 8 found
   $JAVA_EXEC ${VM_ARGS} \
     -Dsun.java2d.xrender=false \
     -Dsun.locale.formatasdefault=true \
     -Ddbvis.home="${DBVIS_HOME}" \
     -splash:"${DBVIS_HOME}/resources/images/ix3/dbvis-splash_dark.png" \
     -Xdock:name="DbVisualizer" \
     -Xdock:icon="${DBVIS_HOME}/resources/images/ix3/dbvis-icon.icns" \
     -cp "${CP}" \
     com.onseven.dbvis.DbVisualizerGUI "$@"
else
   echo "Error: Java 8 is required. Below is the version currently being used:\n"
   $JAVA_EXEC -version
   exit 2
fi

