/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.range.IntegerRange;
import com.jidesoft.range.LongRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.List;

public final class MathUtils {
    protected MathUtils() {
    }

    public static double sum(List<Number> list) {
        double d2 = 0.0;
        for (Number number : list) {
            d2 += number.doubleValue();
        }
        return d2;
    }

    public static double mean(List<Number> list) {
        double d2 = MathUtils.sum(list);
        return d2 / (double)list.size();
    }

    public static double min(List<Number> list) {
        double d2 = Double.MAX_VALUE;
        for (Number number : list) {
            double d3 = number.doubleValue();
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static double max(List<Number> list) {
        double d2 = -1.7976931348623157E308;
        for (Number number : list) {
            double d3 = number.doubleValue();
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static double stddev(List<Number> list, boolean bl) {
        double d2 = Double.NaN;
        int n2 = list.size();
        if (n2 > 0) {
            d2 = n2 > 1 ? Math.sqrt(MathUtils.var(list, bl)) : 0.0;
        }
        return d2;
    }

    public static double var(List<Number> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return Double.NaN;
        }
        if (n2 == 1) {
            return 0.0;
        }
        double d2 = MathUtils.mean(list);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (Number number : list) {
            double d3 = number.doubleValue() - d2;
            arrayList.add(Math.pow(d3, 2.0));
        }
        double d4 = MathUtils.sum(arrayList);
        return d4 / (double)(bl ? n2 - 1 : n2);
    }

    public static Range<Double> range(List<Number> list) {
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        for (Number number : list) {
            double d4 = number.doubleValue();
            if (d4 < d2) {
                d2 = d4;
            }
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        return new NumericRange(d2, d3);
    }

    public static Range<Integer> rangeInteger(List<Number> list) {
        double d2 = 2.147483647E9;
        double d3 = -2.147483647E9;
        for (Number number : list) {
            double d4 = number.doubleValue();
            if (d4 < d2) {
                d2 = d4;
            }
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        return new IntegerRange((int)d2, (int)d3);
    }

    public static Range<Long> rangeLong(List<Number> list) {
        double d2 = 9.223372036854776E18;
        double d3 = -9.223372036854776E18;
        for (Number number : list) {
            double d4 = number.doubleValue();
            if (d4 < d2) {
                d2 = d4;
            }
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        return new LongRange((long)d2, (long)d3);
    }
}

