/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;

public class CachedVector<E>
extends Vector<E> {
    private static final long \u0103 = -4994486169224407197L;
    private Map<Object, IntegerWrapper> \u0101;
    private boolean \u0102 = false;

    public CachedVector() {
    }

    public CachedVector(Collection<? extends E> collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedVector(int n2) {
        super(n2);
    }

    @Override
    public int indexOf(Object object) {
        this.\u0101();
        IntegerWrapper integerWrapper = this.\u0101.get(object);
        if (integerWrapper != null) {
            return integerWrapper.\u0101;
        }
        if (this.isLazyCaching()) {
            int n2 = super.indexOf(object);
            if (n2 == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n2);
            }
            return n2;
        }
        return -1;
    }

    protected synchronized void adjustCache(int n2, int n3) {
        if (this.\u0101 != null) {
            if (this.size() - n2 <= this.size() >> 2) {
                Collection<IntegerWrapper> collection = this.\u0101.values();
                for (IntegerWrapper integerWrapper : collection) {
                    if (integerWrapper.\u0101 < n2) continue;
                    integerWrapper.\u0101 += n3;
                }
            } else {
                this.uncacheAll();
                if (!this.isLazyCaching()) {
                    this.cacheAll();
                }
            }
        }
    }

    protected Map<Object, IntegerWrapper> createCache() {
        return new IdentityHashMap<Object, IntegerWrapper>();
    }

    public synchronized void cacheIt(Object object, int n2) {
        if (this.\u0101 != null && (this.\u0101.get(object) == null || n2 < this.\u0101.get((Object)object).\u0101)) {
            this.\u0101.put(object, new IntegerWrapper(n2));
        }
    }

    public synchronized void uncacheIt(Object object) {
        if (this.\u0101 != null) {
            this.\u0101.remove(object);
        }
    }

    @Override
    public synchronized boolean add(E e2) {
        boolean bl = super.add(e2);
        if (!this.isLazyCaching() && bl) {
            this.\u0101();
            this.cacheIt(e2, this.size() - 1);
        }
        return bl;
    }

    @Override
    public synchronized void add(int n2, E e2) {
        super.add(n2, e2);
        if (!this.isLazyCaching()) {
            this.\u0101();
            this.adjustCache(n2, 1);
            this.cacheIt(e2, n2);
        } else if (this.\u0101 != null) {
            this.adjustCache(n2, 1);
            this.cacheIt(e2, n2);
        }
    }

    private void \u0101() {
        if (this.\u0101 == null) {
            this.\u0101 = this.createCache();
        }
    }

    @Override
    public synchronized E remove(int n2) {
        Object e2 = super.remove(n2);
        if (e2 != null) {
            this.uncacheIt(e2);
            this.adjustCache(n2, -1);
        }
        return e2;
    }

    @Override
    public synchronized boolean remove(Object object) {
        int n2 = this.indexOf(object);
        boolean bl = super.remove(object);
        if (bl) {
            this.uncacheIt(object);
            this.adjustCache(n2, -1);
        }
        return bl;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    @Override
    public synchronized void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            this.cacheAll();
        }
        return bl;
    }

    @Override
    public synchronized boolean addAll(int n2, Collection<? extends E> collection) {
        boolean bl = super.addAll(n2, collection);
        this.\u0101();
        this.adjustCache(n2, collection.size());
        for (E e2 : collection) {
            this.cacheIt(e2, n2++);
        }
        return bl;
    }

    @Override
    public synchronized E set(int n2, E e2) {
        if (!this.isLazyCaching()) {
            this.\u0101();
            E e3 = super.set(n2, e2);
            this.uncacheIt(e3);
            this.cacheIt(e2, n2);
            return e3;
        }
        return super.set(n2, e2);
    }

    public synchronized void invalidateCache() {
        this.uncacheAll();
    }

    public synchronized void uncacheAll() {
        if (this.\u0101 != null) {
            this.\u0101.clear();
            this.\u0101 = null;
        }
    }

    public synchronized void cacheAll() {
        this.\u0101 = this.createCache();
        Integer n2 = 0;
        for (Object e2 : this) {
            if (this.\u0101.get(e2) == null) {
                this.\u0101.put(e2, new IntegerWrapper(n2));
            }
            Integer n3 = n2;
            Integer n4 = n2 = Integer.valueOf(n2 + 1);
        }
    }

    public boolean isLazyCaching() {
        return this.\u0102;
    }

    public void setLazyCaching(boolean bl) {
        this.\u0102 = bl;
    }

    @Override
    protected synchronized void removeRange(int n2, int n3) {
        if (n2 == n3) {
            this.remove(n2);
        } else {
            super.removeRange(n2, n3);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }

    public static class IntegerWrapper {
        int \u0101;

        private IntegerWrapper(int n2) {
            this.\u0101 = n2;
        }
    }
}

