/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.swing.JideSwingUtilities;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static TreePath[] saveSelection(JTree jTree) {
        return jTree.getSelectionPaths();
    }

    public static void loadSelection(JTree jTree, TreePath[] treePathArray) {
        if (treePathArray != null && treePathArray.length > 0) {
            jTree.setSelectionPaths(treePathArray);
            jTree.scrollPathToVisible(treePathArray[0]);
        }
    }

    public static Enumeration<TreePath> saveExpansionStateByTreePath(JTree jTree) {
        return jTree.getExpandedDescendants(new TreePath(jTree.getModel().getRoot()));
    }

    public static void loadExpansionStateByTreePath(JTree jTree, Enumeration<TreePath> enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = enumeration.nextElement();
                jTree.expandPath(treePath);
            }
        }
    }

    public static boolean isDescendant(TreePath treePath, TreePath treePath2) {
        int n2;
        int n3 = treePath.getPathCount();
        if (n3 <= (n2 = treePath2.getPathCount())) {
            return false;
        }
        while (n3 != n2) {
            treePath = treePath.getParentPath();
            --n3;
        }
        return treePath.equals(treePath2);
    }

    public static String saveExpansionState(JTree jTree, int n2) {
        TreePath treePath = jTree.getPathForRow(n2);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = jTree.getRowCount();
        for (int i2 = n2; i2 < n3; ++i2) {
            TreePath treePath2 = jTree.getPathForRow(i2);
            if (i2 != n2 && !TreeUtils.isDescendant(treePath2, treePath)) break;
            if (!jTree.isExpanded(treePath2)) continue;
            stringBuffer.append(",").append(String.valueOf(i2 - n2));
        }
        return stringBuffer.toString();
    }

    public static void loadExpansionState(JTree jTree, int n2, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n3 = n2 + Integer.parseInt(stringTokenizer.nextToken());
            jTree.expandRow(n3);
        }
    }

    public static void expandAll(JTree jTree) {
        TreeModel treeModel = jTree.getModel();
        for (int i2 = 0; i2 < treeModel.getChildCount(treeModel.getRoot()); ++i2) {
            jTree.expandPath(new TreePath(new Object[]{treeModel.getRoot(), treeModel.getChild(treeModel.getRoot(), i2)}));
        }
    }

    public static void expandAll(JTree jTree, boolean bl) {
        Object object = jTree.getModel().getRoot();
        TreeUtils.expandAll(jTree, new TreePath(object), bl);
    }

    public static void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        Object object = treePath.getLastPathComponent();
        if (jTree.getModel().getChildCount(object) >= 0) {
            for (int i2 = 0; i2 < jTree.getModel().getChildCount(object); ++i2) {
                Object object2 = jTree.getModel().getChild(object, i2);
                TreePath treePath2 = treePath.pathByAddingChild(object2);
                TreeUtils.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public static Object findTreeNode(JTree jTree, Object object) {
        Object object2 = jTree.getModel().getRoot();
        return TreeUtils.findTreeNode(jTree, new TreePath(object2), object);
    }

    public static Object findTreeNode(JTree jTree, TreePath treePath, Object object) {
        Object object2 = treePath.getLastPathComponent();
        if (object2 instanceof DefaultMutableTreeNode && JideSwingUtilities.equals(object, ((DefaultMutableTreeNode)object2).getUserObject())) {
            return object2;
        }
        if (jTree.getModel().getChildCount(object2) >= 0) {
            for (int i2 = 0; i2 < jTree.getModel().getChildCount(object2); ++i2) {
                Object object3 = jTree.getModel().getChild(object2, i2);
                TreePath treePath2 = treePath.pathByAddingChild(object3);
                Object object4 = TreeUtils.findTreeNode(jTree, treePath2, object);
                if (object4 == null) continue;
                return object4;
            }
        }
        return null;
    }

    public static int getLeafCount(TreeModel treeModel) {
        return TreeUtils.\u0101(treeModel, treeModel.getRoot());
    }

    public static int getLeafCount(TreeModel treeModel, Object object) {
        return TreeUtils.\u0101(treeModel, object);
    }

    private static int \u0101(TreeModel treeModel, Object object) {
        if (treeModel.isLeaf(object)) {
            return 1;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < treeModel.getChildCount(object); ++i2) {
            n2 += TreeUtils.\u0101(treeModel, treeModel.getChild(object, i2));
        }
        return n2;
    }
}

