/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.parser;

import com.jidesoft.thirdparty.prefuse.data.parser.DataParseException;
import com.jidesoft.thirdparty.prefuse.data.parser.DataParser;

public class FloatParser
implements DataParser {
    @Override
    public Class getType() {
        return Float.TYPE;
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)object).floatValue()) + "f";
    }

    @Override
    public boolean canParse(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Object parse(String string) throws DataParseException {
        return new Float(this.parseFloat(string));
    }

    public float parseFloat(String string) throws DataParseException {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

