/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;

public class JideBoxLayout
implements LayoutManager2,
Serializable {
    private static final Logger \u0106 = Logger.getLogger(JideBoxLayout.class.getName());
    private boolean \u0102 = true;
    protected int _axis;
    protected Container _target;
    private int \u0107 = 0;
    protected int[] _componentSizes;
    public static final String FIX = "fix";
    public static final String FLEXIBLE = "flexible";
    public static final String VARY = "vary";
    private final HashMap<Component, Object> \u0105 = new HashMap();
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private boolean \u0103 = true;
    private boolean \u0104 = true;
    private static final long \u0101 = -183922972679053590L;

    public JideBoxLayout(Container container) {
        this(container, 0);
    }

    public JideBoxLayout(Container container, int n2) {
        this(container, n2, 0);
    }

    public JideBoxLayout(Container container, int n2, int n3) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = n2;
        this._target = container;
        this.\u0107 = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2;
            int n3;
            int n42;
            boolean bl;
            int n5;
            if (\u0106.isLoggable(Level.FINE)) {
                \u0106.fine(this + " layoutContainer started");
            }
            Dimension dimension = container.getSize();
            if (dimension.height <= 0 || dimension.width <= 0) {
                return;
            }
            Insets insets = this._target.getInsets();
            if (this.\u0102) {
                this._componentSizes = new int[this._target.getComponentCount()];
                n5 = this.getAvailableSize(dimension, insets);
                if ((n5 -= this.\u0102()) <= 0) {
                    return;
                }
                bl = this.calculateComponentSizes(n5, 0, this._target.getComponentCount());
                if (!bl) {
                    if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false"))) {
                        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
                            Component component = this._target.getComponent(i2);
                            this.setComponentToSize(component, 0, 0, insets, dimension);
                        }
                        this.\u0101(container);
                    }
                    return;
                }
                this.\u0102 = false;
                if (this._componentSizes.length == 0) {
                    container.repaint();
                }
            } else {
                n5 = 0;
                for (int n42 : this._componentSizes) {
                    n5 += n42;
                }
                boolean bl2 = bl = n5 + this.\u0102() != this.\u0101(dimension);
                if (bl) {
                    n3 = this.getAvailableSize(dimension, insets);
                    if ((n3 -= this.\u0102()) <= 0) {
                        return;
                    }
                    n2 = this.calculateComponentSizes(n3, 0, this._target.getComponentCount()) ? 1 : 0;
                    if (n2 == 0) {
                        if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false"))) {
                            for (n42 = 0; n42 < this._target.getComponentCount(); ++n42) {
                                Component component = this._target.getComponent(n42);
                                this.setComponentToSize(component, 0, 0, insets, dimension);
                            }
                            this.\u0101(container);
                        }
                        return;
                    }
                }
            }
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            bl = componentOrientation.isLeftToRight();
            n3 = this.\u0101(insets, true);
            n2 = 0;
            if (!bl && JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                n3 = dimension.width - n3;
            }
            for (n42 = 0; n42 < this._target.getComponentCount(); ++n42) {
                int n6;
                Component component = this._target.getComponent(n42);
                int n7 = this.getPreferredSizeOfComponent(component);
                if (!bl && JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                    this.setComponentToSize(component, this._componentSizes[n42], n3 -= this._componentSizes[n42], insets, dimension);
                    if (\u0106.isLoggable(Level.FINE)) {
                        \u0106.fine("layoutContainer index: " + n42 + " size: " + this._componentSizes[n42]);
                    }
                    if (this._componentSizes[n42] != 0) {
                        n3 -= this.\u0107;
                    }
                } else {
                    this.setComponentToSize(component, this._componentSizes[n42], n3, insets, dimension);
                    if (\u0106.isLoggable(Level.FINE)) {
                        \u0106.fine("layoutContainer index: " + n42 + " size: " + this._componentSizes[n42]);
                    }
                    n3 += this._componentSizes[n42];
                    if (this._componentSizes[n42] != 0) {
                        n3 += this.\u0107;
                    }
                }
                if ((n6 = this.getPreferredSizeOfComponent(component)) == n7) continue;
                n2 = 1;
            }
            if (\u0106.isLoggable(Level.FINE)) {
                \u0106.fine("layoutContainer ended");
            }
            if (this._target instanceof JideOptionPane) {
                for (n42 = 0; n42 < container.getComponentCount(); ++n42) {
                    container.getComponent(n42).invalidate();
                }
                if (n2 != 0) {
                    this.\u0101(container);
                }
            }
        }
    }

    private void \u0101(Container container) {
        Container container2;
        for (container2 = container.getParent(); container2 != null && !(container2 instanceof Dialog); container2 = container2.getParent()) {
        }
        if (container2 != null) {
            ((Dialog)container2).pack();
        }
    }

    protected boolean calculateComponentSizes(int n2, int n3, int n4) {
        boolean bl;
        int n5;
        int n6;
        int n7 = n2;
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        int n11 = 0;
        int n12 = 0;
        int n13 = -1;
        int n14 = -1;
        for (n6 = n3; n6 < n4; ++n6) {
            Component component = this._target.getComponent(n6);
            if (!component.isVisible()) continue;
            Object object = this.\u0105.get(component);
            int n15 = this.\u0101(component.getMinimumSize());
            n5 = this.\u0101(this.getPreferredSizeOf(component, n6));
            if (FIX.equals(object)) {
                n7 -= Math.max(n5, n15);
                continue;
            }
            if (VARY.equals(object)) {
                n10 = n6;
                this.getPreferredSizeOf(component, n6);
                n8 = n15;
                continue;
            }
            if (n5 > n15) {
                n12 += n5 - n15;
            }
            n11 += n5;
            n9 += n15;
            n13 = n6;
            if (n5 == 0) continue;
            n14 = n6;
        }
        if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false")) && n7 - n8 < 0) {
            return false;
        }
        n6 = n10 != -1 ? 1 : 0;
        boolean bl2 = bl = n7 - n8 >= n11;
        if (n6 == 0 || n6 != 0 && !bl) {
            double d2 = bl ? (n11 == 0 ? 0.0 : (double)(n7 - n8) / (double)n11) : (n12 == 0 ? 0.0 : (double)(n7 - n8 - n9) / (double)n12);
            for (n5 = n3; n5 < n4; ++n5) {
                Component component = this._target.getComponent(n5);
                if (!component.isVisible()) {
                    this.\u0102(n5, 0);
                    continue;
                }
                Object object = this.\u0105.get(component);
                int n16 = this.\u0101(component.getMinimumSize());
                int n17 = this.\u0101(this.getPreferredSizeOf(component, n5));
                if (FIX.equals(object)) {
                    this.\u0102(n5, Math.max(n17, n16));
                    continue;
                }
                if (VARY.equals(object)) {
                    this.\u0102(n5, n8);
                    continue;
                }
                if (bl) {
                    this.\u0102(n5, (int)((double)n17 * d2));
                    continue;
                }
                this.\u0102(n5, n16 + (int)((double)(n17 - n16) * d2));
            }
        } else {
            for (int i2 = n3; i2 < n4; ++i2) {
                Component component = this._target.getComponent(i2);
                if (!component.isVisible()) {
                    this.\u0102(i2, 0);
                    continue;
                }
                Object object = this.\u0105.get(component);
                int n18 = this.\u0101(component.getMinimumSize());
                int n19 = this.\u0101(this.getPreferredSizeOf(component, i2));
                if (FIX.equals(object)) {
                    this.\u0102(i2, Math.max(n19, n18));
                    continue;
                }
                if (VARY.equals(object)) {
                    this.\u0102(i2, n7 - n11);
                    continue;
                }
                this.\u0102(i2, Math.max(n19, n18));
            }
        }
        int n20 = 0;
        for (int i3 = n3; i3 < n4; ++i3) {
            n20 += this._componentSizes[i3];
        }
        if (n20 != n2) {
            if (n10 != -1) {
                this.\u0101(n10, n2 - n20);
            } else if (n14 != -1) {
                this.\u0101(n14, n2 - n20);
            } else if (n13 != -1) {
                this.\u0101(n13, n2 - n20);
            }
        }
        return true;
    }

    private void \u0101(int n2, int n3) {
        if (SystemInfo.isJdk15Above() && this._target.getComponent(n2).isMinimumSizeSet()) {
            this.\u0102(n2, Math.max(this._componentSizes[n2] + n3, this.\u0101(this._target.getComponent(n2).getMinimumSize())));
        } else {
            this.\u0102(n2, this._componentSizes[n2] + n3);
        }
    }

    private void \u0102(int n2, int n3) {
        if (\u0106.isLoggable(Level.FINE)) {
            \u0106.fine("setComponentSize index: " + n2 + " size: " + n3);
        }
        this._componentSizes[n2] = n3;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.\u0101();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n2 = 0;
        int n3 = 0;
        Insets insets = this._target.getInsets();
        Object object = container.getTreeLock();
        synchronized (object) {
            for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
                Component component = this._target.getComponent(i2);
                if (!component.isVisible()) continue;
                Object object2 = this.\u0105.get(component);
                Dimension dimension = component.getMinimumSize();
                n2 = FIX.equals(object2) ? (n2 += this.getPreferredSizeOfComponent(component)) : (n2 += this.\u0101(dimension));
                int n4 = this.\u0102(dimension);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (insets != null) {
                n2 += this.\u0101(insets, true) + this.\u0101(insets, false);
                n3 += this.\u0102(insets, true) + this.\u0102(insets, false);
            }
        }
        object = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, (ComponentOrientation)object) == 0) {
            return new Dimension(n2 + this.\u0102(), n3);
        }
        return new Dimension(n3, n2 + this.\u0102());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n2 = 0;
        int n3 = 0;
        Insets insets = this._target.getInsets();
        Object object = container.getTreeLock();
        synchronized (object) {
            for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
                Component component = this._target.getComponent(i2);
                if (!component.isVisible()) continue;
                Dimension dimension = this.getPreferredSizeOf(component, i2);
                n2 += this.\u0101(dimension);
                int n4 = this.\u0102(dimension);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (insets != null) {
                n2 += this.\u0101(insets, true) + this.\u0101(insets, false);
                n3 += this.\u0102(insets, true) + this.\u0102(insets, false);
            }
        }
        object = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, (ComponentOrientation)object) == 0) {
            return new Dimension(n2 + this.\u0102(), n3);
        }
        return new Dimension(n3, n2 + this.\u0102());
    }

    private int \u0102() {
        if (this.\u0107 == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            if (!this._target.getComponent(i2).isVisible()) continue;
            ++n2;
        }
        return Math.max(0, n2 - 1) * this.\u0107;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.\u0105.remove(component);
        if (component instanceof JideSplitPaneDivider) {
            this.\u0101();
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            this.\u0105.put(component, FLEXIBLE);
        } else {
            this.\u0105.put(component, object);
        }
        this.\u0101();
    }

    private void \u0101() {
        this.\u0102 = true;
        if (\u0106.isLoggable(Level.FINE)) {
            \u0106.fine(this + " layoutReset");
        }
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public synchronized void invalidateLayout(Container container) {
        if (this.isResetWhenInvalidate() || this.componentCountChanged(container)) {
            this.\u0101();
        }
    }

    protected boolean componentCountChanged(Container container) {
        if (this._componentSizes == null) {
            return true;
        }
        int n2 = 0;
        int[] nArray = this._componentSizes;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n4 <= 0) continue;
            ++n2;
        }
        int n5 = 0;
        for (n3 = 0; n3 < container.getComponentCount(); ++n3) {
            if (!container.getComponent(n3).isVisible()) continue;
            ++n5;
        }
        return n5 != n2;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected int getPreferredSizeOfComponent(Component component) {
        return this.\u0101(component.getPreferredSize());
    }

    int \u0101(Component component) {
        return this.\u0101(component.getMinimumSize());
    }

    protected int getSizeOfComponent(Component component) {
        return this.\u0101(component.getSize());
    }

    protected int getAvailableSize(Dimension dimension, Insets insets) {
        if (insets == null) {
            return this.\u0101(dimension);
        }
        return this.\u0101(dimension) - (this.\u0101(insets, true) + this.\u0101(insets, false));
    }

    protected int getInitialLocation(Insets insets) {
        if (insets != null) {
            return this.\u0101(insets, true);
        }
        return 0;
    }

    protected void setComponentToSize(Component component, int n2, int n3, Insets insets, Dimension dimension) {
        if (insets != null) {
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                component.setBounds(n3, Math.max(insets.top, 0), Math.max(n2, 0), Math.max(dimension.height - (insets.top + insets.bottom), 0));
            } else {
                component.setBounds(Math.max(insets.left, 0), n3, Math.max(dimension.width - (insets.left + insets.right), 0), Math.max(n2, 0));
            }
        } else {
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                component.setBounds(n3, 0, Math.max(n2, 0), Math.max(dimension.height, 0));
            } else {
                component.setBounds(0, n3, Math.max(dimension.width, 0), Math.max(n2, 0));
            }
        }
    }

    int \u0101(Dimension dimension) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            return dimension.width;
        }
        return dimension.height;
    }

    int \u0102(Dimension dimension) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            return dimension.height;
        }
        return dimension.width;
    }

    int \u0101(Insets insets, boolean bl) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            if (bl) {
                return insets.left;
            }
            return insets.right;
        }
        if (bl) {
            return insets.top;
        }
        return insets.bottom;
    }

    int \u0102(Insets insets, boolean bl) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            if (bl) {
                return insets.top;
            }
            return insets.bottom;
        }
        if (bl) {
            return insets.left;
        }
        return insets.right;
    }

    public Map<Component, Object> getConstraintMap() {
        return this.\u0105;
    }

    protected static int resolveAxis(int n2, ComponentOrientation componentOrientation) {
        int n3 = n2 == 2 ? (componentOrientation.isHorizontal() ? 0 : 1) : (n2 == 3 ? (componentOrientation.isHorizontal() ? 1 : 0) : n2);
        return n3;
    }

    public int getGap() {
        return this.\u0107;
    }

    public void setGap(int n2) {
        this.\u0107 = n2;
    }

    protected Dimension getPreferredSizeOf(Component component, int n2) {
        Dimension dimension;
        Serializable serializable;
        Cloneable cloneable;
        if (component instanceof JTextArea && this.\u0102(component.getSize()) == 0) {
            cloneable = this._target.getInsets();
            serializable = this._target.getComponentOrientation();
            dimension = this._target.getSize();
            if (JideBoxLayout.resolveAxis(this._axis, (ComponentOrientation)serializable) == 0) {
                component.setSize(new Dimension(component.getPreferredSize().width, dimension.height - ((Insets)cloneable).top - ((Insets)cloneable).bottom));
            } else {
                component.setSize(new Dimension(dimension.width - ((Insets)cloneable).left - ((Insets)cloneable).right, component.getPreferredSize().height));
            }
        }
        cloneable = component.getPreferredSize();
        serializable = component.getMinimumSize();
        if (cloneable.height < serializable.height) {
            cloneable.height = serializable.height;
        }
        if (cloneable.width < serializable.width) {
            cloneable.width = serializable.width;
        }
        dimension = component.getMaximumSize();
        if (cloneable.height > dimension.height && dimension.height != Short.MAX_VALUE) {
            cloneable.height = dimension.height;
        }
        if (cloneable.width > dimension.width && dimension.height != Short.MAX_VALUE) {
            cloneable.width = dimension.width;
        }
        return cloneable;
    }

    public boolean isResetWhenInvalidate() {
        return this.\u0103;
    }

    public void setResetWhenInvalidate(boolean bl) {
        this.\u0103 = bl;
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int n2) {
        this._axis = n2;
    }

    public boolean isAlwaysLayout() {
        return this.\u0104;
    }

    public void setAlwaysLayout(boolean bl) {
        this.\u0104 = bl;
    }
}

