/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.rss.FeedReader;
import com.jidesoft.rss.U;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelUpdatePeriod;
import de.nava.informa.core.CloudIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.impl.basic.Channel;
import de.nava.informa.impl.basic.ChannelGroup;
import de.nava.informa.impl.basic.Image;
import de.nava.informa.impl.basic.Item;
import de.nava.informa.impl.basic.TextInput;
import de.nava.informa.utils.ItemComparator;
import de.nava.informa.utils.manager.PersistenceManagerException;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class FeedDatabasePersistenceManager
implements PersistenceManagerIF {
    private FeedReader \u0101 = null;
    private Logger \u0102 = Logger.getLogger(FeedDatabasePersistenceManager.class.getName());

    public FeedDatabasePersistenceManager(FeedReader feedReader) {
        this.\u0101 = feedReader;
        try {
            this.initializeDB();
        }
        catch (Exception exception) {
            this.\u0102.warning(exception.getLocalizedMessage());
        }
    }

    public ChannelGroupIF createGroup(String string) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(this.getTableName("CHANNEL_GROUPS")).append("(TITLE) ");
        stringBuffer.append("VALUES(?)");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT CHANNEL_GROUP_ID FROM ").append(this.getTableName("CHANNEL_GROUPS")).append(" ");
            stringBuffer.append("WHERE TITLE = ? ORDER BY CHANNEL_GROUP_ID DESC ");
            preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            long l2 = 0L;
            if (resultSet.next()) {
                l2 = resultSet.getLong("CHANNEL_GROUP_ID");
            }
            ChannelGroup channelGroup = new ChannelGroup();
            channelGroup.setId(l2);
            channelGroup.setTitle(string);
            return channelGroup;
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    public void updateGroup(ChannelGroupIF channelGroupIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(this.getTableName("CHANNEL_GROUPS")).append(" ");
        stringBuffer.append("SET TITLE = ? ");
        stringBuffer.append("WHERE CHANNEL_GROUP_ID = ? ");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, channelGroupIF.getTitle());
            preparedStatement.setLong(2, channelGroupIF.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    public void deleteGroup(ChannelGroupIF channelGroupIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(this.getTableName("CHANNEL_GROUPS")).append(" ");
        stringBuffer.append("WHERE CHANNEL_GROUP_ID = ?");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            preparedStatement.executeUpdate();
            stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
            stringBuffer.append("WHERE GROUP_ID = ?");
            preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    public void mergeGroups(ChannelGroupIF channelGroupIF, ChannelGroupIF channelGroupIF2) throws PersistenceManagerException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT CHANNEL_ID FROM ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
            stringBuffer.append("WHERE GROUP_ID = ? ");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("CHANNEL_ID"));
            }
            preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF2.getId());
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString("CHANNEL_ID"));
            }
            Channel channel = new Channel();
            for (String string : arrayList2) {
                if (arrayList.contains(string)) continue;
                channel.setId(Long.parseLong(string));
                this.addChannelToGroup((ChannelIF)channel, channelGroupIF);
            }
            this.deleteGroup(channelGroupIF2);
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ChannelGroupIF[] getGroups() throws PersistenceManagerException {
        try {
            if (this.\u0101.isAllowGroup()) {
                ChannelGroup[] channelGroupArray;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT CHANNEL_GROUP_ID, TITLE, PARENT_ID ");
                stringBuffer.append("FROM ").append(this.getTableName("CHANNEL_GROUPS"));
                Connection connection = this.getConnection();
                PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<ChannelGroup[]> arrayList = new ArrayList<ChannelGroup[]>();
                while (resultSet.next()) {
                    channelGroupArray = new ChannelGroup();
                    channelGroupArray.setId(resultSet.getLong("CHANNEL_GROUP_ID"));
                    channelGroupArray.setTitle(resultSet.getString("TITLE"));
                    channelGroupArray.setParent(resultSet.getLong("PARENT_ID") == 0L ? null : this.\u0105(resultSet.getLong("PARENT_ID")));
                    arrayList.add(channelGroupArray);
                }
                for (ChannelGroupIF channelGroupIF : arrayList) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("SELECT CHANNEL_ID FROM ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
                    stringBuffer.append("WHERE GROUP_ID = ? ");
                    preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
                    preparedStatement.setLong(1, channelGroupIF.getId());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        channelGroupIF.add(this.\u0103(resultSet.getLong("CHANNEL_ID")));
                    }
                }
                channelGroupArray = null;
                if (arrayList != null && !arrayList.isEmpty()) {
                    void var7_14;
                    channelGroupArray = new ChannelGroup[arrayList.size()];
                    boolean i2 = false;
                    while (var7_14 < channelGroupArray.length) {
                        channelGroupArray[var7_14] = (ChannelGroupIF)arrayList.get((int)var7_14);
                        ++var7_14;
                    }
                }
                return channelGroupArray;
            }
            ChannelGroup channelGroup = new ChannelGroup();
            channelGroup.setId(0L);
            channelGroup.setTitle("Default");
            channelGroup.setParent(null);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT CHANNEL_ID FROM ").append(this.getTableName("CHANNELS"));
            Connection connection = this.getConnection();
            ResultSet resultSet = connection.createStatement().executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                channelGroup.add(this.\u0103(resultSet.getLong("CHANNEL_ID")));
            }
            return new ChannelGroupIF[]{channelGroup};
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
    }

    public ChannelIF createChannel(String string, URL uRL) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(this.getTableName("CHANNELS")).append(" ");
        stringBuffer.append("(TITLE, LOCSTRING) ");
        stringBuffer.append("VALUES (?, ?)");
        Connection connection = this.getConnection();
        if (connection == null || uRL == null) {
            return null;
        }
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, uRL.toExternalForm());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT CHANNEL_ID FROM ").append(this.getTableName("CHANNELS")).append(" ");
            stringBuffer.append("WHERE TITLE = ? AND LOCSTRING = ? ORDER BY CHANNEL_ID DESC ");
            preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, uRL.toExternalForm());
            Channel channel = new Channel();
            channel.setTitle(string);
            channel.setLocation(uRL);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                channel.setId(resultSet.getLong("CHANNEL_ID"));
            }
            preparedStatement.close();
            Channel channel2 = channel;
            return channel2;
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                this.\u0102.warning(sQLException.getLocalizedMessage());
            }
        }
    }

    public void updateChannel(ChannelIF channelIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(this.getTableName("CHANNELS")).append(" SET TITLE = ?, DESCRIPTION = ?, LOCSTRING = ?, SITE = ?, CREATOR = ?, PUBLISHER = ?, LANGUAGE = ?, FORMAT = ?, IMAGE_ID = ?, TEXTINPUT_ID = ?, COPYRIGHT = ?, RATING = ?, CLOUD_ID = ?, GENERATOR = ?, DOCS = ?, TTL = ?, LAST_UPDATED = ?, LAST_BUILD_DATE = ?, PUB_DATE = ?, UPDATE_PERIOD = ?, UPDATE_FREQUENCY = ?, UPDATE_BASE = ? ");
        stringBuffer.append("WHERE CHANNEL_ID = ?");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, U.\u0101(channelIF.getTitle()));
            preparedStatement.setString(2, U.\u0101(channelIF.getDescription()));
            preparedStatement.setString(3, channelIF.getLocation() == null ? null : channelIF.getLocation().toExternalForm());
            preparedStatement.setBytes(4, channelIF.getSite() == null ? null : U.\u0101((Serializable)channelIF.getSite()));
            preparedStatement.setString(5, U.\u0101(channelIF.getCreator()));
            preparedStatement.setString(6, U.\u0101(channelIF.getPublisher()));
            preparedStatement.setString(7, U.\u0101(channelIF.getLanguage()));
            preparedStatement.setString(8, channelIF.getFormat() == null ? null : U.\u0101(channelIF.getFormat().toString()));
            if (channelIF.getImage() != null) {
                if (this.\u0104(channelIF.getImage().getId()) == null) {
                    this.\u0101(channelIF.getImage());
                }
                preparedStatement.setLong(9, channelIF.getImage().getId());
            } else {
                preparedStatement.setObject(9, null);
            }
            if (channelIF.getTextInput() != null) {
                if (this.\u0102(channelIF.getTextInput().getId()) == null) {
                    this.\u0101(channelIF.getTextInput());
                }
                preparedStatement.setLong(10, channelIF.getTextInput().getId());
            } else {
                preparedStatement.setObject(10, null);
            }
            preparedStatement.setString(11, U.\u0101(channelIF.getCopyright()));
            preparedStatement.setString(12, U.\u0101(channelIF.getRating()));
            preparedStatement.setString(13, channelIF.getCloud() == null ? null : U.\u0101(channelIF.getCloud().toString()));
            preparedStatement.setString(14, U.\u0101(channelIF.getGenerator()));
            preparedStatement.setString(15, U.\u0101(channelIF.getDocs()));
            preparedStatement.setInt(16, channelIF.getTtl());
            preparedStatement.setDate(17, channelIF.getLastUpdated() == null ? null : new Date(channelIF.getLastUpdated().getTime()));
            preparedStatement.setDate(18, channelIF.getLastBuildDate() == null ? null : new Date(channelIF.getLastBuildDate().getTime()));
            preparedStatement.setDate(19, channelIF.getPubDate() == null ? null : new Date(channelIF.getPubDate().getTime()));
            ChannelUpdatePeriod channelUpdatePeriod = channelIF.getUpdatePeriod();
            preparedStatement.setString(20, U.\u0101(channelUpdatePeriod == null ? "hourly" : channelUpdatePeriod.toString()));
            preparedStatement.setInt(21, channelIF.getUpdateFrequency());
            preparedStatement.setDate(22, channelIF.getUpdateBase() == null ? null : new Date(channelIF.getUpdateBase().getTime()));
            preparedStatement.setLong(23, channelIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            ChannelIF channelIF2 = this.\u0103(channelIF.getId());
            Set set = channelIF.getItems();
            ItemIF[] itemIFArray = set.toArray(new ItemIF[set.size()]);
            Arrays.sort(itemIFArray, new ItemComparator(true));
            for (ItemIF itemIF : itemIFArray) {
                ItemIF itemIF2 = this.\u0101(channelIF2, itemIF);
                if (itemIF2 != null) {
                    itemIF.setUnRead(itemIF2.getUnRead());
                    this.deleteItem(itemIF2);
                }
                this.createItem(channelIF, itemIF);
            }
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
    }

    public void addChannelToGroup(ChannelIF channelIF, ChannelGroupIF channelGroupIF) throws PersistenceManagerException {
        try {
            if (this.\u0105(channelGroupIF.getId()) == null) {
                this.createGroup(channelGroupIF.getTitle());
            }
            if (this.\u0103(channelIF.getId()) == null) {
                this.createChannel(channelIF.getTitle(), channelIF.getLocation());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
            stringBuffer.append("(GROUP_ID, CHANNEL_ID) ");
            stringBuffer.append("VALUES (?, ?)");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            preparedStatement.setLong(2, channelIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            channelGroupIF.add(channelIF);
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
    }

    public void removeChannelFromGroup(ChannelIF channelIF, ChannelGroupIF channelGroupIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        Connection connection = this.getConnection();
        try {
            stringBuffer.append("DELETE FROM ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
            stringBuffer.append("WHERE GROUP_ID = ? AND CHANNEL_ID = ?");
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            preparedStatement.setLong(2, channelIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            channelGroupIF.remove(channelIF);
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    public void deleteChannel(ChannelIF channelIF) throws PersistenceManagerException {
        try {
            this.\u0101(channelIF);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this.getTableName("CHANNELS")).append(" ");
            stringBuffer.append("WHERE CHANNEL_ID = ?");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            if (channelIF.getImage() != null) {
                this.\u0102(channelIF.getImage());
            }
            if (channelIF.getTextInput() != null) {
                this.\u0102(channelIF.getTextInput());
            }
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
    }

    public ItemIF createItem(ChannelIF channelIF, String string) throws PersistenceManagerException {
        Item item = new Item();
        item.setTitle(string);
        return this.createItem(channelIF, (ItemIF)item);
    }

    public ItemIF createItem(ChannelIF channelIF, ItemIF itemIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(this.getTableName("ITEMS")).append(" ");
        stringBuffer.append("(ITEM_ID, CHANNEL_ID, TITLE, DESCRIPTION, UNREAD, LINK, CREATOR, SUBJECT, DATE, FOUND, GUID, COMMENTS, SOURCE, ENCLOSURE) ");
        stringBuffer.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, itemIF.getId());
            preparedStatement.setLong(2, channelIF.getId());
            preparedStatement.setString(3, U.\u0101(itemIF.getTitle()));
            preparedStatement.setString(4, U.\u0101(itemIF.getDescription()));
            preparedStatement.setInt(5, itemIF.getUnRead() ? 1 : 0);
            preparedStatement.setBytes(6, itemIF.getLink() == null ? null : U.\u0101((Serializable)itemIF.getLink()));
            preparedStatement.setString(7, U.\u0101(itemIF.getCreator()));
            preparedStatement.setString(8, U.\u0101(itemIF.getSubject()));
            preparedStatement.setString(9, itemIF.getDate() == null ? null : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(itemIF.getDate()));
            preparedStatement.setDate(10, itemIF.getFound() == null ? null : new Date(itemIF.getFound().getTime()));
            preparedStatement.setObject(11, null);
            preparedStatement.setBytes(12, itemIF.getComments() == null ? null : U.\u0101((Serializable)itemIF.getComments()));
            preparedStatement.setObject(13, null);
            preparedStatement.setObject(14, null);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
        return itemIF;
    }

    public void updateItem(ItemIF itemIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(this.getTableName("ITEMS")).append(" SET ");
        stringBuffer.append("CHANNEL_ID = ?, ");
        stringBuffer.append("TITLE = ?, ");
        stringBuffer.append("DESCRIPTION = ?, ");
        stringBuffer.append("UNREAD = ?, ");
        stringBuffer.append("LINK = ?, ");
        stringBuffer.append("CREATOR = ?, ");
        stringBuffer.append("SUBJECT = ?, ");
        stringBuffer.append("DATE = ?, ");
        stringBuffer.append("FOUND = ?, ");
        stringBuffer.append("GUID = ?, ");
        stringBuffer.append("COMMENTS = ?, ");
        stringBuffer.append("SOURCE = ?, ");
        stringBuffer.append("ENCLOSURE = ? ");
        stringBuffer.append("WHERE ITEM_ID = ? ");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, itemIF.getChannel().getId());
            preparedStatement.setString(2, U.\u0101(itemIF.getTitle()));
            preparedStatement.setString(3, U.\u0101(itemIF.getDescription()));
            preparedStatement.setInt(4, itemIF.getUnRead() ? 1 : 0);
            preparedStatement.setBytes(5, itemIF.getLink() == null ? null : U.\u0101((Serializable)itemIF.getLink()));
            preparedStatement.setString(6, U.\u0101(itemIF.getCreator()));
            preparedStatement.setString(7, U.\u0101(itemIF.getSubject()));
            preparedStatement.setString(8, itemIF.getDate() == null ? null : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(itemIF.getDate()));
            preparedStatement.setDate(9, itemIF.getFound() == null ? null : new Date(itemIF.getFound().getTime()));
            preparedStatement.setObject(10, null);
            preparedStatement.setBytes(11, itemIF.getComments() == null ? null : U.\u0101((Serializable)itemIF.getComments()));
            preparedStatement.setObject(12, null);
            preparedStatement.setObject(13, null);
            preparedStatement.setLong(14, itemIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
    }

    public void deleteItem(ItemIF itemIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(this.getTableName("ITEMS")).append(" ");
        stringBuffer.append("WHERE ITEM_ID = ?");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, itemIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    private void \u0101(ChannelIF channelIF) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(this.getTableName("ITEMS")).append(" ");
        stringBuffer.append("WHERE CHANNEL_ID = ?");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, channelIF.getId());
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void \u0102(ImageIF imageIF) throws Exception {
        if (imageIF != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this.getTableName("IMAGES")).append(" ");
            stringBuffer.append("WHERE IMAGE_ID = ?");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, imageIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
    }

    private TextInputIF \u0102(long l2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT TEXTINPUT_ID, TITLE, DESCRIPTION, NAME, LINK ");
        stringBuffer.append("FROM ").append(this.getTableName("TEXTINPUTS")).append(" ");
        stringBuffer.append("WHERE TEXTINPUT_ID = ?");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, l2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            TextInput textInput = new TextInput();
            textInput.setId(resultSet.getLong("TEXTINPUT_ID"));
            textInput.setTitle(resultSet.getString("TITLE"));
            textInput.setDescription(resultSet.getString("DESCRIPTION"));
            textInput.setName(resultSet.getString("NAME"));
            textInput.setLink(resultSet.getObject("LINK") == null ? null : (URL)U.\u0101(resultSet.getBytes("LINK")));
            resultSet.close();
            preparedStatement.close();
            return textInput;
        }
        resultSet.close();
        preparedStatement.close();
        return null;
    }

    private void \u0102(TextInputIF textInputIF) throws Exception {
        if (textInputIF != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this.getTableName("TEXTINPUTS")).append(" ");
            stringBuffer.append("WHERE TEXTINPUT_ID = ?");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, textInputIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
    }

    private ChannelIF \u0103(long l2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT CHANNEL_ID, TITLE, DESCRIPTION, LOCSTRING, SITE, CREATOR, PUBLISHER, LANGUAGE, FORMAT, IMAGE_ID, TEXTINPUT_ID, COPYRIGHT, RATING, CLOUD_ID, GENERATOR, DOCS, TTL, LAST_UPDATED, LAST_BUILD_DATE, PUB_DATE, UPDATE_PERIOD, UPDATE_FREQUENCY, UPDATE_BASE ");
        stringBuffer.append("FROM ").append(this.getTableName("CHANNELS")).append(" ");
        stringBuffer.append("WHERE CHANNEL_ID = ?");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, l2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            Channel channel = new Channel();
            channel.setId(resultSet.getLong("CHANNEL_ID"));
            channel.setTitle(resultSet.getString("TITLE"));
            channel.setDescription(resultSet.getString("DESCRIPTION"));
            try {
                channel.setLocation(resultSet.getObject("LOCSTRING") == null ? null : new URL(resultSet.getString("LOCSTRING")));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            channel.setSite(resultSet.getObject("SITE") == null ? null : (URL)U.\u0101(resultSet.getBytes("SITE")));
            channel.setCreator(resultSet.getString("CREATOR"));
            channel.setPublisher(resultSet.getString("PUBLISHER"));
            channel.setLanguage(resultSet.getString("LANGUAGE"));
            channel.setFormat(this.\u0101(resultSet.getString("FORMAT")));
            channel.setImage(resultSet.getObject("IMAGE_ID") == null ? null : this.\u0104(resultSet.getLong("IMAGE_ID")));
            channel.setTextInput(resultSet.getObject("TEXTINPUT_ID") == null ? null : this.\u0102(resultSet.getLong("TEXTINPUT_ID")));
            channel.setCopyright(resultSet.getString("COPYRIGHT"));
            channel.setRating(resultSet.getString("RATING"));
            channel.setCloud(resultSet.getObject("CLOUD_ID") == null ? null : this.\u0101(resultSet.getLong("CLOUD_ID")));
            channel.setGenerator(resultSet.getString("GENERATOR"));
            channel.setDocs(resultSet.getString("DOCS"));
            channel.setTtl(resultSet.getInt("TTL"));
            channel.setLastUpdated((java.util.Date)resultSet.getDate("LAST_UPDATED"));
            channel.setLastBuildDate((java.util.Date)resultSet.getDate("LAST_BUILD_DATE"));
            channel.setPubDate((java.util.Date)resultSet.getDate("PUB_DATE"));
            String string = resultSet.getString("UPDATE_PERIOD");
            channel.setUpdatePeriod(ChannelUpdatePeriod.valueFromText((String)(string == null || string.trim().length() == 0 ? "hourly" : string)));
            channel.setUpdateFrequency(resultSet.getInt("UPDATE_FREQUENCY"));
            channel.setUpdateBase((java.util.Date)resultSet.getDate("UPDATE_BASE"));
            List<ItemIF> list = this.\u0101((ChannelIF)channel, "DATE DESC");
            for (ItemIF itemIF : list) {
                channel.addItem(itemIF);
            }
            resultSet.close();
            preparedStatement.close();
            return channel;
        }
        resultSet.close();
        preparedStatement.close();
        return null;
    }

    private ChannelFormat \u0101(String string) {
        if (string.equals(ChannelFormat.RSS_0_90.toString())) {
            return ChannelFormat.RSS_0_90;
        }
        if (string.equals(ChannelFormat.RSS_0_91.toString())) {
            return ChannelFormat.RSS_0_91;
        }
        if (string.equals(ChannelFormat.RSS_0_92.toString())) {
            return ChannelFormat.RSS_0_92;
        }
        if (string.equals(ChannelFormat.RSS_0_93.toString())) {
            return ChannelFormat.RSS_0_93;
        }
        if (string.equals(ChannelFormat.RSS_0_94.toString())) {
            return ChannelFormat.RSS_0_94;
        }
        if (string.equals(ChannelFormat.RSS_1_0.toString())) {
            return ChannelFormat.RSS_1_0;
        }
        if (string.equals(ChannelFormat.RSS_2_0.toString())) {
            return ChannelFormat.RSS_2_0;
        }
        return ChannelFormat.UNKNOWN_CHANNEL_FORMAT;
    }

    private List<ItemIF> \u0101(ChannelIF channelIF, String string) throws Exception {
        if (channelIF == null) {
            return null;
        }
        ArrayList<ItemIF> arrayList = new ArrayList<ItemIF>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ITEM_ID, CHANNEL_ID, TITLE, DESCRIPTION, UNREAD, LINK, CREATOR, SUBJECT, DATE, FOUND, GUID, COMMENTS, SOURCE, ENCLOSURE, TIMESTAMP ");
        stringBuffer.append("FROM ").append(this.getTableName("ITEMS")).append(" WHERE CHANNEL_ID = ?");
        if (string != null) {
            stringBuffer.append(" ORDER BY ");
            stringBuffer.append(string);
        }
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, channelIF.getId());
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Item item = new Item();
            item.setId(resultSet.getLong("ITEM_ID"));
            item.setChannel(channelIF);
            item.setTitle(resultSet.getString("TITLE"));
            item.setDescription(resultSet.getString("DESCRIPTION"));
            item.setUnRead(resultSet.getInt("UNREAD") != 0);
            item.setLink(resultSet.getObject("LINK") == null ? null : (URL)U.\u0101(resultSet.getBytes("LINK")));
            item.setCreator(resultSet.getString("CREATOR"));
            item.setSubject(resultSet.getString("SUBJECT"));
            item.setDate(resultSet.getObject("DATE") == null ? null : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse(resultSet.getString("DATE")));
            item.setFound((java.util.Date)resultSet.getDate("FOUND"));
            item.setComments(resultSet.getObject("COMMENTS") == null ? null : (URL)U.\u0101(resultSet.getBytes("COMMENTS")));
            arrayList.add((ItemIF)item);
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    private CloudIF \u0101(long l2) throws Exception {
        return null;
    }

    private ImageIF \u0104(long l2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT IMAGE_ID, TITLE, DESCRIPTION, LOCATION, LINK, WIDTH, HEIGHT ");
        stringBuffer.append("FROM ").append(this.getTableName("IMAGES")).append(" WHERE IMAGE_ID = ?");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, l2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            Image image = new Image();
            image.setId(l2);
            image.setTitle(resultSet.getString("TITLE"));
            image.setDescription(resultSet.getString("DESCRIPTION"));
            image.setLocation(resultSet.getObject("LOCATION") == null ? null : (URL)U.\u0101(resultSet.getBytes("LOCATION")));
            image.setLink(resultSet.getObject("LINK") == null ? null : (URL)U.\u0101(resultSet.getBytes("LINK")));
            image.setWidth(resultSet.getInt("WIDTH"));
            image.setHeight(resultSet.getInt("HEIGHT"));
            resultSet.close();
            preparedStatement.close();
            return image;
        }
        resultSet.close();
        preparedStatement.close();
        return null;
    }

    private ChannelGroupIF \u0105(long l2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT CHANNEL_GROUP_ID, TITLE, PARENT_ID ");
        stringBuffer.append("FROM ").append(this.getTableName("CHANNEL_GROUPS")).append(" WHERE CHANNEL_GROUP_ID = ?");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, l2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            ChannelGroup channelGroup = new ChannelGroup();
            channelGroup.setId(l2);
            channelGroup.setTitle(resultSet.getString("TITLE"));
            channelGroup.setParent(resultSet.getLong("PARENT_ID") == 0L ? null : this.\u0105(resultSet.getLong("PARENT_ID")));
            return channelGroup;
        }
        resultSet.close();
        preparedStatement.close();
        return null;
    }

    private void \u0101(ImageIF imageIF) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(this.getTableName("IMAGES")).append(" ");
        stringBuffer.append("(IMAGE_ID, TITLE, DESCRIPTION, LOCATION, LINK, WIDTH, HEIGHT) ");
        stringBuffer.append("VALUES (?, ?, ?, ?, ?, ?, ?)");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, imageIF.getId());
        preparedStatement.setString(2, U.\u0101(imageIF.getTitle()));
        preparedStatement.setString(3, U.\u0101(imageIF.getDescription()));
        preparedStatement.setBytes(4, imageIF.getLocation() == null ? null : U.\u0101((Serializable)imageIF.getLocation()));
        preparedStatement.setBytes(5, imageIF.getLink() == null ? null : U.\u0101((Serializable)imageIF.getLink()));
        preparedStatement.setInt(6, imageIF.getWidth());
        preparedStatement.setInt(7, imageIF.getHeight());
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void \u0101(TextInputIF textInputIF) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(this.getTableName("TEXTINPUTS")).append(" ");
        stringBuffer.append("(TEXTINPUT_ID, TITLE, DESCRIPTION, NAME, LINK) ");
        stringBuffer.append("VALUES (?, ?, ?, ?, ?)");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, textInputIF.getId());
        preparedStatement.setString(2, U.\u0101(textInputIF.getTitle()));
        preparedStatement.setString(3, U.\u0101(textInputIF.getDescription()));
        preparedStatement.setString(4, U.\u0101(textInputIF.getName()));
        preparedStatement.setBytes(5, textInputIF.getLink() == null ? null : U.\u0101((Serializable)textInputIF.getLink()));
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public void close() throws Exception {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.createStatement().execute("shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initializeDB() throws Exception {
        Connection connection = null;
        boolean bl = false;
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            connection = this.getConnection();
            if (connection != null) {
                Statement statement = connection.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery("select * from " + this.getTablePrefix() + "config" + this.getTablePostfix());
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    this.installDB(connection);
                    bl = true;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    this.\u0102.warning(sQLException.getLocalizedMessage());
                }
            }
        }
        return bl;
    }

    protected void installDB(Connection connection) {
        try {
            byte[] byArray = U.\u0101(this.getScriptURL());
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate(new String(byArray));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            statement.close();
        }
        catch (Exception exception) {
            this.\u0102.warning(exception.getLocalizedMessage());
        }
    }

    protected URL getScriptURL() {
        return U.class.getResource("rssdbscript.ddl");
    }

    protected Connection getConnection() {
        try {
            String string = "jdbc:hsqldb:file:" + this.\u0101.getUserDataPath() + "/db/";
            return DriverManager.getConnection(string, "sa", "");
        }
        catch (SQLException sQLException) {
            this.\u0102.warning(sQLException.getLocalizedMessage());
            return null;
        }
    }

    protected String getTableName(String string) {
        return this.getTablePrefix() + string + this.getTablePostfix();
    }

    protected String getTablePrefix() {
        return "";
    }

    protected String getTablePostfix() {
        return "";
    }

    protected PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private ItemIF \u0101(ChannelIF channelIF, ItemIF itemIF) {
        String string = U.\u0101(itemIF.getTitle());
        Set set = channelIF.getItems();
        ItemIF[] itemIFArray = set.toArray(new ItemIF[set.size()]);
        Arrays.sort(itemIFArray, new ItemComparator(true));
        for (ItemIF itemIF2 : set) {
            boolean bl = itemIF2.getTitle().equals(string);
            if (!bl) continue;
            return itemIF2;
        }
        return null;
    }
}

