/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.navigation;

import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import com.jidesoft.tooltip.ExpandedTipUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class NavigationList
extends JList
implements NavigationComponent {
    private NavigationComponentHelper \u1e07;
    public static final String PROPERTY_WIDE_SELECTION = "wideSelection";
    public static final String PROPERTY_EXPANDED_TIP = "expandedTip";
    private boolean \u1e05 = true;
    private boolean \u1e06 = true;

    public NavigationList() {
        this.\u0297();
    }

    public NavigationList(Vector<?> vector) {
        super(vector);
        this.\u0297();
    }

    public NavigationList(Object[] objectArray) {
        super(objectArray);
        this.\u0297();
    }

    public NavigationList(ListModel listModel) {
        super(listModel);
        this.\u0297();
    }

    private void \u0297() {
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, object, n2, false, false);
            }
        });
        this.\u1e07 = this.createNavigationHelper();
        this.\u1e07.setup(this);
        if (this.\u1e06) {
            ExpandedTipUtils.install(this);
        }
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationListHelper();
    }

    private Rectangle \u013e(int n2) {
        Rectangle rectangle = this.getCellBounds(n2, n2);
        if (!this.isWideSelection()) {
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (listCellRenderer == null) {
                return rectangle;
            }
            Component component = listCellRenderer.getListCellRendererComponent(this, this.getModel().getElementAt(n2), n2, false, false);
            rectangle.width = component.getPreferredSize().width;
        }
        return rectangle;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.\u1e07.paint(graphics, this);
    }

    public boolean isWideSelection() {
        return this.\u1e05;
    }

    public void setWideSelection(boolean bl) {
        boolean bl2 = this.\u1e05;
        if (bl != this.\u1e05) {
            this.\u1e05 = bl;
            this.firePropertyChange(PROPERTY_WIDE_SELECTION, bl2, this.\u1e05);
            this.\u1e07.repaintSelections(this);
        }
    }

    public boolean isExpandedTip() {
        return this.\u1e06;
    }

    public void setExpandedTip(boolean bl) {
        boolean bl2 = this.\u1e06;
        if (bl != this.\u1e06) {
            this.\u1e06 = bl;
            this.firePropertyChange(PROPERTY_EXPANDED_TIP, bl2, this.\u1e06);
            if (this.\u1e06) {
                ExpandedTipUtils.install(this);
            } else {
                ExpandedTipUtils.uninstall(this);
            }
        }
    }

    public int getNavigationRolloverRow() {
        return this.\u1e07.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n2) {
        int n3 = this.\u1e07.getRolloverRow();
        if (n3 != n2) {
            this.\u1e07.setRolloverRow(n2);
            Rectangle rectangle = this.\u013e(n3);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            if ((rectangle = this.\u013e(n2)) != null) {
                this.repaint(rectangle);
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(NavigationList.class.getName(), 2);
        }
    }

    public class NavigationListHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n2) {
            return NavigationList.this.\u013e(n2);
        }

        @Override
        public int rowAtPoint(Point point) {
            int n2 = NavigationList.this.locationToIndex(point);
            Rectangle rectangle = this.getRowBounds(n2);
            if (rectangle != null && rectangle.contains(point)) {
                return n2;
            }
            return -1;
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationList.this.getSelectedIndices();
        }
    }
}

