/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.lucene;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.lucene.A;
import com.jidesoft.lucene.B;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableModel;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public class LuceneFilterableTableModel
extends FilterableTableModel
implements A {
    private static final long \u0ca0 = 4755534842798484885L;
    private B \u0c9c;
    String[] \u0c9e;
    ConverterContext[] \u0c9f;
    Class[] \u0c9b;
    private boolean \u0c9d;

    public LuceneFilterableTableModel(TableModel tableModel) {
        super(tableModel);
        this.setLuceneSupport(new B(this));
        this.setFilterAlgorithm(1);
        this.\u01dd();
    }

    private void \u01dd() {
        this.\u0c9e = new String[this._model.getColumnCount()];
        this.\u0c9f = new ConverterContext[this._model.getColumnCount()];
        this.\u0c9b = new Class[this._model.getColumnCount()];
        for (int i2 = 0; i2 < this._model.getColumnCount(); ++i2) {
            this.\u0c9e[i2] = this.getFieldNameForColumn(i2);
            this.\u0c9f[i2] = null;
            if (this._model instanceof ContextSensitiveTableModel) {
                this.\u0c9f[i2] = ((ContextSensitiveTableModel)this._model).getConverterContextAt(0, i2);
            }
            this.\u0c9b[i2] = this._model.getColumnClass(i2);
        }
    }

    protected String getFieldNameForColumn(int n2) {
        String string = this.getColumnIdentifier(n2).toString().toLowerCase();
        string = string.replaceAll(" ", "");
        return string;
    }

    @Override
    public Document getDocument(int n2) {
        if (n2 < 0 || n2 >= this._model.getRowCount()) {
            return null;
        }
        Document document = new Document();
        for (int i2 = 0; i2 < this._model.getColumnCount(); ++i2) {
            String string = ObjectConverterManager.toString(this._model.getValueAt(n2, i2), this.\u0c9b[i2], this.\u0c9f[i2]).toLowerCase();
            Field field = new Field(this.\u0c9e[i2], string, Field.Store.YES, Field.Index.ANALYZED);
            document.add((IndexableField)field);
        }
        return document;
    }

    @Override
    public int getDocumentCount() {
        return this._model.getRowCount();
    }

    @Override
    public void notifyIndexCreated() {
    }

    @Override
    protected void tableDataChanged() {
        this.getLuceneSupport().\u0101(0, this._model.getRowCount() - 1, false);
        super.tableDataChanged();
    }

    @Override
    protected void tableStructureChanged() {
        this.getLuceneSupport().\u0101(0, this._model.getRowCount() - 1, false);
        super.tableStructureChanged();
    }

    @Override
    protected void tableRowsInserted(int n2, int n3) {
        this.getLuceneSupport().\u0101(n2, this._model.getRowCount() - 1, false);
        super.tableRowsInserted(n2, n3);
    }

    @Override
    protected void tableRowsDeleted(int n2, int n3) {
        this.getLuceneSupport().\u0101(n2, this._model.getRowCount() - 1, false);
        super.tableRowsDeleted(n2, n3);
    }

    @Override
    protected void tableRowsUpdated(int n2, int n3) {
        this.getLuceneSupport().\u0101(n2, n3, false);
        super.tableRowsUpdated(n2, n3);
    }

    @Override
    protected void tableCellsUpdated(int n2, int n3, int n4) {
        this.getLuceneSupport().\u0101(n3, n4, false);
        super.tableCellsUpdated(n2, n3, n4);
    }

    @Override
    protected List<Integer> getReservedRows(int n2, int n3) {
        if (this.getLuceneSupport().\u0108()) {
            return super.getReservedRows(n2, n3);
        }
        this.prepareFilters();
        Set<Integer> set = this.getLuceneSupport().\u0106();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!set.contains(i2)) continue;
            arrayList.add(i2);
        }
        return arrayList;
    }

    @Override
    protected void filter(boolean bl) {
        Object object;
        if (this.getLuceneSupport().\u0108()) {
            super.filter(bl);
            return;
        }
        if (this.getLuceneQuery() == null) {
            this.\u01de();
            if (this.getLuceneQuery() == null) {
                super.filter(bl);
                return;
            }
        }
        List<Integer> list = this.getReservedRows(0, this._model.getRowCount());
        if (this.\u01df()) {
            this.invalidateFilterCache();
            object = new ArrayList<Integer>(list);
            list.clear();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                boolean bl2 = this.shouldBeFiltered(n2);
                if (bl2) continue;
                list.add(n2);
            }
        }
        object = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object[i2] = list.get(i2);
        }
        this.setIndexes((int[])object);
    }

    protected Query getLuceneQuery() {
        return this.getLuceneSupport().\u0109();
    }

    private void \u01de() {
        if (this._eachColumnFilters == null || this.getColumnCount() == 0) {
            this.getLuceneSupport().\u0103();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i2 = 0; i2 < this._eachColumnFilters.length; ++i2) {
            List list = this._eachColumnFilters[i2];
            if (list == null || list.size() == 0) continue;
            if (bl) {
                bl = false;
            } else if (this.isAndMode()) {
                stringBuffer.append(" AND ");
            } else {
                stringBuffer.append("OR");
            }
            stringBuffer.append("(");
            for (Filter filter : list) {
                String string = this.convertFilterToLuceneQueryText(i2, filter);
                if (string == null) {
                    return;
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(")");
        }
        if (stringBuffer.length() == 0) {
            this.getLuceneSupport().\u0103();
            return;
        }
        this.getLuceneSupport().\u0101(stringBuffer.toString(), this.\u0c9e[0]);
    }

    protected String convertFilterToLuceneQueryText(int n2, Filter filter) {
        if (filter instanceof SingleValueFilter) {
            ConverterContext converterContext = null;
            if (this._model instanceof ContextSensitiveTableModel) {
                converterContext = ((ContextSensitiveTableModel)this._model).getConverterContextAt(0, n2);
            }
            String string = ObjectConverterManager.toString(((SingleValueFilter)filter).getValue(), this._model.getColumnClass(n2), converterContext).toLowerCase();
            return this.getFieldNameForColumn(n2) + ":\"" + string + "\"";
        }
        if (filter instanceof MultipleValuesFilter) {
            ConverterContext converterContext = null;
            if (this._model instanceof ContextSensitiveTableModel) {
                converterContext = ((ContextSensitiveTableModel)this._model).getConverterContextAt(0, n2);
            }
            T[] TArray = ((MultipleValuesFilter)filter).getValues();
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getFieldNameForColumn(n2);
            for (Object t2 : TArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(");
                String string2 = ObjectConverterManager.toString(t2, this._model.getColumnClass(n2), converterContext).toLowerCase();
                stringBuffer.append(string).append(":").append("\"").append(string2).append("\"");
                stringBuffer.append(")");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public void fireFilterChanged(FilterableTableModelEvent filterableTableModelEvent) {
        this.getLuceneSupport().\u0103();
        super.fireFilterChanged(filterableTableModelEvent);
    }

    public B getLuceneSupport() {
        return this.\u0c9c;
    }

    public void setLuceneSupport(B b2) {
        this.\u0c9c = b2;
    }

    public int getBooleanQueryMaxClauseCount() {
        return this.\u0c9c.\u0107();
    }

    public void setBooleanQueryMaxClauseCount(int n2) {
        this.\u0c9c.\u0103(n2);
    }

    public boolean isRangeQueryInclusive() {
        return this.\u0c9c.\u0105();
    }

    public void setRangeQueryInclusive(boolean bl) {
        this.\u0c9c.\u0103(bl);
    }

    public boolean isAllowLeadingWildcard() {
        return this.\u0c9c.\u0102();
    }

    public void setAllowLeadingWildcard(boolean bl) {
        this.\u0c9c.\u0102(bl);
    }

    boolean \u01df() {
        return this.\u0c9d;
    }

    void \u011d(boolean bl) {
        this.\u0c9d = bl;
    }
}

