/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class StyledListCellRenderer
extends StyledLabel
implements ListCellRenderer,
Serializable {
    protected static Border noFocusBorder;

    public StyledListCellRenderer() {
        if (noFocusBorder == null) {
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
        this.applyComponentOrientation(jList.getComponentOrientation());
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setIgnoreColorSettings(bl);
        this.customizeStyledLabel(jList, object, n2, bl, bl2);
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        Border border = null;
        if (bl2) {
            if (bl) {
                border = UIDefaultsLookup.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIDefaultsLookup.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = noFocusBorder;
        }
        this.setBorder(border);
        return this;
    }

    protected void customizeStyledLabel(JList jList, Object object, int n2, boolean bl, boolean bl2) {
        this.clearStyleRanges();
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(object == null ? "" : object.toString());
        }
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l2, int n2, int n3, int n4, int n5) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string.equals("text")) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c2, char c3) {
    }

    @Override
    public void firePropertyChange(String string, short s2, short s3) {
    }

    @Override
    public void firePropertyChange(String string, int n2, int n3) {
    }

    @Override
    public void firePropertyChange(String string, long l2, long l3) {
    }

    @Override
    public void firePropertyChange(String string, float f2, float f3) {
    }

    @Override
    public void firePropertyChange(String string, double d2, double d3) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public static class UIResource
    extends StyledListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

